/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.SingleSender;
import org.apache.drill.exec.planner.fragment.ParallelizationInfo;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ArrayListMultimap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuxExchange
extends AbstractExchange {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMuxExchange.class);
    protected Map<Integer, MinorFragmentEndpoint> senderToReceiverMapping;
    protected ArrayListMultimap<Integer, MinorFragmentEndpoint> receiverToSenderMapping;
    private boolean isSenderReceiverMappingCreated;

    public AbstractMuxExchange(@JsonProperty(value="child") PhysicalOperator child) {
        super(child);
    }

    @Override
    public ParallelizationInfo getReceiverParallelizationInfo(List<CoordinationProtos.DrillbitEndpoint> senderFragmentEndpoints) {
        Preconditions.checkArgument(senderFragmentEndpoints != null && senderFragmentEndpoints.size() > 0, "Sender fragment endpoint list should not be empty");
        ImmutableList<CoordinationProtos.DrillbitEndpoint> drillbitEndpoints = ImmutableSet.copyOf(senderFragmentEndpoints).asList();
        ArrayList<EndpointAffinity> affinities = Lists.newArrayList();
        for (CoordinationProtos.DrillbitEndpoint ep : drillbitEndpoints) {
            affinities.add(new EndpointAffinity(ep, Double.POSITIVE_INFINITY));
        }
        return ParallelizationInfo.create(affinities.size(), affinities.size(), affinities);
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        this.createSenderReceiverMapping();
        MinorFragmentEndpoint receiver = this.senderToReceiverMapping.get(minorFragmentId);
        if (receiver == null) {
            throw new IllegalStateException(String.format("Failed to find receiver for sender [%d]", minorFragmentId));
        }
        return new SingleSender(this.receiverMajorFragmentId, receiver.getId(), child, receiver.getEndpoint());
    }

    protected final List<MinorFragmentEndpoint> getSenders(int minorFragmentId) {
        this.createSenderReceiverMapping();
        List senders = this.receiverToSenderMapping.get((Object)minorFragmentId);
        logger.debug("Minor fragment {}, receives data from following senders {}", (Object)minorFragmentId, (Object)senders);
        if (senders == null || senders.size() <= 0) {
            throw new IllegalStateException(String.format("Failed to find senders for receiver [%d]", minorFragmentId));
        }
        return senders;
    }

    protected void createSenderReceiverMapping() {
        if (this.isSenderReceiverMappingCreated) {
            return;
        }
        this.senderToReceiverMapping = Maps.newHashMap();
        this.receiverToSenderMapping = ArrayListMultimap.create();
        ArrayListMultimap endpointSenderList = ArrayListMultimap.create();
        int senderFragmentId = 0;
        for (CoordinationProtos.DrillbitEndpoint senderLocation : this.senderLocations) {
            endpointSenderList.put(senderLocation, (Object)senderFragmentId);
            ++senderFragmentId;
        }
        int receiverFragmentId = 0;
        for (CoordinationProtos.DrillbitEndpoint receiverLocation : this.receiverLocations) {
            List senderFragmentIds = endpointSenderList.get(receiverLocation);
            for (Integer senderId : senderFragmentIds) {
                this.senderToReceiverMapping.put(senderId, new MinorFragmentEndpoint(receiverFragmentId, receiverLocation));
                this.receiverToSenderMapping.put((Object)receiverFragmentId, (Object)new MinorFragmentEndpoint(senderId, (CoordinationProtos.DrillbitEndpoint)this.senderLocations.get(senderId)));
            }
            ++receiverFragmentId;
        }
        this.isSenderReceiverMappingCreated = true;
    }
}

