/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractSender;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;

@JsonTypeName(value="hash-partition-sender")
public class HashPartitionSender
extends AbstractSender {
    public static final String OPERATOR_TYPE = "HASH_PARTITION_SENDER";
    private final LogicalExpression expr;
    private final int outgoingBatchSize;

    @JsonCreator
    public HashPartitionSender(@JsonProperty(value="receiver-major-fragment") int oppositeMajorFragmentId, @JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr, @JsonProperty(value="destinations") List<MinorFragmentEndpoint> endpoints, @JsonProperty(value="outgoingBatchSize") int outgoingBatchSize) {
        super(oppositeMajorFragmentId, child, endpoints);
        this.expr = expr;
        this.outgoingBatchSize = outgoingBatchSize;
    }

    public HashPartitionSender(int oppositeMajorFragmentId, PhysicalOperator child, LogicalExpression expr, List<MinorFragmentEndpoint> endpoints) {
        this(oppositeMajorFragmentId, child, expr, endpoints, 1023);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new HashPartitionSender(this.oppositeMajorFragmentId, child, this.expr, this.destinations, this.outgoingBatchSize);
    }

    public LogicalExpression getExpr() {
        return this.expr;
    }

    public int getOutgoingBatchSize() {
        return this.outgoingBatchSize;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitHashPartitionSender(this, value);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

