/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.physical.config.MergingReceiverPOP;

@JsonTypeName(value="hash-to-merge-exchange")
public class HashToMergeExchange
extends AbstractExchange {
    private final LogicalExpression distExpr;
    private final List<Order.Ordering> orderExprs;

    @JsonCreator
    public HashToMergeExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr, @JsonProperty(value="orderings") List<Order.Ordering> orderExprs) {
        super(child);
        this.distExpr = expr;
        this.orderExprs = orderExprs;
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new HashPartitionSender(this.receiverMajorFragmentId, child, this.distExpr, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.receiverLocations));
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new MergingReceiverPOP(this.senderMajorFragmentId, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.senderLocations), this.orderExprs, true);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new HashToMergeExchange(child, this.distExpr, this.orderExprs);
    }

    @JsonProperty(value="orderExpr")
    public List<Order.Ordering> getOrderExpressions() {
        return this.orderExprs;
    }
}

