/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractJoinPop;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.config.UnnestPOP;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="lateral-join")
public class LateralJoinPOP
extends AbstractJoinPop {
    public static final String OPERATOR_TYPE = "LATERAL_JOIN";
    @JsonProperty(value="excludedColumns")
    private List<SchemaPath> excludedColumns;
    @JsonProperty(value="implicitRIDColumn")
    private String implicitRIDColumn;
    @JsonProperty(value="unnestForLateralJoin")
    private UnnestPOP unnestForLateralJoin;

    @JsonCreator
    public LateralJoinPOP(@JsonProperty(value="left") PhysicalOperator left, @JsonProperty(value="right") PhysicalOperator right, @JsonProperty(value="joinType") JoinRelType joinType, @JsonProperty(value="implicitRIDColumn") String implicitRIDColumn, @JsonProperty(value="excludedColumns") List<SchemaPath> excludedColumns) {
        super(left, right, joinType, false, null, null);
        Preconditions.checkArgument(joinType != JoinRelType.FULL, "Full outer join is currently not supported with Lateral Join");
        Preconditions.checkArgument(joinType != JoinRelType.RIGHT, "Right join is currently not supported with Lateral Join");
        this.excludedColumns = excludedColumns;
        this.implicitRIDColumn = implicitRIDColumn;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.size() == 2, "Lateral join should have two physical operators");
        LateralJoinPOP newPOP = new LateralJoinPOP(children.get(0), children.get(1), this.joinType, this.implicitRIDColumn, this.excludedColumns);
        newPOP.unnestForLateralJoin = this.unnestForLateralJoin;
        return newPOP;
    }

    @JsonProperty(value="unnestForLateralJoin")
    public UnnestPOP getUnnestForLateralJoin() {
        return this.unnestForLateralJoin;
    }

    @JsonProperty(value="excludedColumns")
    public List<SchemaPath> getExcludedColumns() {
        return this.excludedColumns;
    }

    public void setUnnestForLateralJoin(UnnestPOP unnest) {
        this.unnestForLateralJoin = unnest;
    }

    @JsonProperty(value="implicitRIDColumn")
    public String getImplicitRIDColumn() {
        return this.implicitRIDColumn;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitLateralJoin(this, value);
    }
}

