/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.metastore.analyze.MetadataControllerContext;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="metadataController")
public class MetadataControllerPOP
extends AbstractBase {
    public static final String OPERATOR_TYPE = "METADATA_CONTROLLER";
    private final MetadataControllerContext context;
    private final PhysicalOperator left;
    private final PhysicalOperator right;

    @JsonCreator
    public MetadataControllerPOP(@JsonProperty(value="left") PhysicalOperator left, @JsonProperty(value="right") PhysicalOperator right, @JsonProperty(value="context") MetadataControllerContext context) {
        this.context = context;
        this.left = left;
        this.right = right;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitOp(this, value);
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.size() == 2);
        return new MetadataControllerPOP(children.get(0), children.get(1), this.context);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Arrays.asList(this.left, this.right).iterator();
    }

    @JsonProperty
    public MetadataControllerContext getContext() {
        return this.context;
    }

    @JsonProperty
    public PhysicalOperator getLeft() {
        return this.left;
    }

    @JsonProperty
    public PhysicalOperator getRight() {
        return this.right;
    }
}

