/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.OrderedPartitionSender;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="ordered-partition-exchange")
public class OrderedPartitionExchange
extends AbstractExchange {
    static final Logger logger = LoggerFactory.getLogger(OrderedPartitionExchange.class);
    private final List<Order.Ordering> orderings;
    private final FieldReference ref;
    private int recordsToSample = 10000;
    private int samplingFactor = 10;
    private float completionFactor = 0.75f;

    @JsonCreator
    public OrderedPartitionExchange(@JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="ref") FieldReference ref, @JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="recordsToSample") Integer recordsToSample, @JsonProperty(value="samplingFactor") Integer samplingFactor, @JsonProperty(value="completionFactor") Float completionFactor) {
        super(child);
        this.orderings = orderings;
        this.ref = ref;
        if (recordsToSample != null) {
            Preconditions.checkArgument(recordsToSample > 0, "recordsToSample must be greater than 0");
            this.recordsToSample = recordsToSample;
        }
        if (samplingFactor != null) {
            Preconditions.checkArgument(samplingFactor > 0, "samplingFactor must be greater than 0");
            this.samplingFactor = samplingFactor;
        }
        if (completionFactor != null) {
            Preconditions.checkArgument(completionFactor.floatValue() > 0.0f, "completionFactor must be greater than 0");
            Preconditions.checkArgument((double)completionFactor.floatValue() <= 1.0, "completionFactor cannot be greater than 1.0");
            this.completionFactor = completionFactor.floatValue();
        }
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new OrderedPartitionSender(this.orderings, this.ref, child, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.receiverLocations), this.receiverMajorFragmentId, this.senderLocations.size(), this.recordsToSample, this.samplingFactor, this.completionFactor);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new UnorderedReceiver(this.senderMajorFragmentId, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.senderLocations), false);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new OrderedPartitionExchange(this.orderings, this.ref, child, this.recordsToSample, this.samplingFactor, Float.valueOf(this.completionFactor));
    }
}

