/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractSender;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

@JsonTypeName(value="OrderedPartitionSender")
public class OrderedPartitionSender
extends AbstractSender {
    public static final String OPERATOR_TYPE = "ORDERED_PARTITION_SENDER";
    private final List<Order.Ordering> orderings;
    private final FieldReference ref;
    private final int sendingWidth;
    private final int recordsToSample;
    private final int samplingFactor;
    private final float completionFactor;

    @JsonCreator
    public OrderedPartitionSender(@JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="ref") FieldReference ref, @JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="destinations") List<MinorFragmentEndpoint> endpoints, @JsonProperty(value="receiver-major-fragment") int oppositeMajorFragmentId, @JsonProperty(value="sending-fragment-width") int sendingWidth, @JsonProperty(value="recordsToSample") int recordsToSample, @JsonProperty(value="samplingFactor") int samplingFactor, @JsonProperty(value="completionFactor") float completionFactor) {
        super(oppositeMajorFragmentId, child, endpoints);
        this.orderings = orderings == null ? Lists.newArrayList() : orderings;
        this.ref = ref;
        this.sendingWidth = sendingWidth;
        this.recordsToSample = recordsToSample;
        this.samplingFactor = samplingFactor;
        this.completionFactor = completionFactor;
    }

    public int getSendingWidth() {
        return this.sendingWidth;
    }

    public List<Order.Ordering> getOrderings() {
        return this.orderings;
    }

    public FieldReference getRef() {
        return this.ref;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitOrderedPartitionSender(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new OrderedPartitionSender(this.orderings, this.ref, child, this.destinations, this.oppositeMajorFragmentId, this.sendingWidth, this.recordsToSample, this.samplingFactor, this.completionFactor);
    }

    public int getRecordsToSample() {
        return this.recordsToSample;
    }

    public int getSamplingFactor() {
        return this.samplingFactor;
    }

    public float getCompletionFactor() {
        return this.completionFactor;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public String toString() {
        return "OrderedPartitionSender[orderings=" + this.orderings + ", ref=" + this.ref + ", sendingWidth=" + this.sendingWidth + ", recordsToSample=" + this.recordsToSample + ", samplingFactor=" + this.samplingFactor + ", completionFactor=" + this.completionFactor + "]";
    }
}

