/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.config.Limit;
import org.apache.drill.exec.record.BatchSchema;

@JsonTypeName(value="partition-limit")
public class PartitionLimit
extends Limit {
    public static final String OPERATOR_TYPE = "PARTITION_LIMIT";
    private final String partitionColumn;

    @JsonCreator
    public PartitionLimit(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="first") Integer first, @JsonProperty(value="last") Integer last, @JsonProperty(value="partitionColumn") String partitionColumn) {
        super(child, first, last);
        this.partitionColumn = partitionColumn;
    }

    public String getPartitionColumn() {
        return this.partitionColumn;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new PartitionLimit(child, this.getFirst(), this.getLast(), this.getPartitionColumn());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitLimit(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode getSVMode() {
        return BatchSchema.SelectionVectorMode.TWO_BYTE;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public String toString() {
        return "PartitionLimit[partitionColumn=" + this.partitionColumn + "]";
    }
}

