/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.record.BatchSchema;

@JsonTypeName(value="project")
public class Project
extends AbstractSingle {
    public static final String OPERATOR_TYPE = "PROJECT";
    private final List<NamedExpression> exprs;
    private boolean outputProj = false;

    @JsonCreator
    public Project(@JsonProperty(value="exprs") List<NamedExpression> exprs, @JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="outputProj") boolean outputProj) {
        super(child);
        this.exprs = exprs;
        this.outputProj = outputProj;
    }

    public Project(List<NamedExpression> exprs, PhysicalOperator child) {
        super(child);
        this.exprs = exprs;
    }

    public List<NamedExpression> getExprs() {
        return this.exprs;
    }

    public boolean isOutputProj() {
        return this.outputProj;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitProject(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new Project(this.exprs, child, this.outputProj);
    }

    @Override
    public BatchSchema.SelectionVectorMode getSVMode() {
        return this.child.getSVMode();
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

