/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.List;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.base.AbstractSender;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.proto.CoordinationProtos;

@JsonTypeName(value="single-sender")
public class SingleSender
extends AbstractSender {
    public static final String OPERATOR_TYPE = "SINGLE_SENDER";

    @JsonCreator
    public SingleSender(@JsonProperty(value="receiver-major-fragment") int oppositeMajorFragmentId, @JsonProperty(value="receiver-minor-fragment") int oppositeMinorFragmentId, @JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="destination") CoordinationProtos.DrillbitEndpoint destination) {
        super(oppositeMajorFragmentId, child, Collections.singletonList(new MinorFragmentEndpoint(oppositeMinorFragmentId, destination)));
    }

    public SingleSender(int oppositeMajorFragmentId, PhysicalOperator child, CoordinationProtos.DrillbitEndpoint destination) {
        this(oppositeMajorFragmentId, 0, child, destination);
    }

    @Override
    @JsonIgnore
    public List<MinorFragmentEndpoint> getDestinations() {
        return this.destinations;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new SingleSender(this.oppositeMajorFragmentId, this.getOppositeMinorFragmentId(), child, this.getDestination());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitSingleSender(this, value);
    }

    @JsonProperty(value="destination")
    public CoordinationProtos.DrillbitEndpoint getDestination() {
        return this.getDestinations().get(0).getEndpoint();
    }

    @JsonProperty(value="receiver-minor-fragment")
    public int getOppositeMinorFragmentId() {
        return this.getDestinations().get(0).getId();
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

