/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.record.BatchSchema;

@JsonTypeName(value="sort")
public class Sort
extends AbstractSingle {
    public static final String OPERATOR_TYPE = "OLD_SORT";
    protected final List<Order.Ordering> orderings;
    protected boolean reverse;

    @JsonCreator
    public Sort(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="reverse") boolean reverse) {
        super(child);
        this.orderings = orderings;
        this.reverse = reverse;
    }

    public List<Order.Ordering> getOrderings() {
        return this.orderings;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitSort(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new Sort(child, this.orderings, this.reverse);
    }

    @Override
    public BatchSchema.SelectionVectorMode getSVMode() {
        return BatchSchema.SelectionVectorMode.FOUR_BYTE;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public String toString() {
        return "Sort[orderings=" + this.orderings + ", reverse=" + this.reverse + "]";
    }
}

