/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

@JsonTypeName(value="statistics-merge")
public class StatisticsMerge
extends AbstractSingle {
    public static final String OPERATOR_TYPE = "STATISTICS_MERGE";
    private final Map<String, String> functions;
    private final double samplePercent;

    @JsonCreator
    public StatisticsMerge(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="functions") Map<String, String> functions, @JsonProperty(value="samplePercent") double samplePercent) {
        super(child);
        this.functions = ImmutableMap.copyOf(functions);
        this.samplePercent = samplePercent;
    }

    public Map<String, String> getFunctions() {
        return this.functions;
    }

    public double getSamplePercent() {
        return this.samplePercent;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitStatisticsMerge(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new StatisticsMerge(child, this.functions, this.samplePercent);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

