/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.SingleSender;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.planner.fragment.ParallelizationInfo;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="union-exchange")
public class UnionExchange
extends AbstractExchange {
    public UnionExchange(@JsonProperty(value="child") PhysicalOperator child) {
        super(child);
    }

    @Override
    public ParallelizationInfo getReceiverParallelizationInfo(List<CoordinationProtos.DrillbitEndpoint> senderFragmentEndpoints) {
        Preconditions.checkArgument(senderFragmentEndpoints != null && senderFragmentEndpoints.size() > 0, "Sender fragment endpoint list should not be empty");
        return ParallelizationInfo.create(1, 1, UnionExchange.getDefaultAffinityMap(senderFragmentEndpoints));
    }

    @Override
    public void setupSenders(List<CoordinationProtos.DrillbitEndpoint> senderLocations) {
        this.senderLocations = senderLocations;
    }

    @Override
    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        Preconditions.checkArgument(receiverLocations.size() == 1, "Union Exchange only supports a single receiver endpoint.");
        super.setupReceivers(receiverLocations);
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new SingleSender(this.receiverMajorFragmentId, child, (CoordinationProtos.DrillbitEndpoint)this.receiverLocations.get(0));
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new UnorderedReceiver(this.senderMajorFragmentId, PhysicalOperatorUtil.getIndexOrderedEndpoints(this.senderLocations), false);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new UnionExchange(child);
    }
}

