/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.Leaf;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.impl.unnest.UnnestRecordBatch;

@JsonTypeName(value="unnest")
public class UnnestPOP
extends AbstractBase
implements Leaf {
    public static final String OPERATOR_TYPE = "UNNEST";
    @JsonProperty(value="implicitColumn")
    private final String implicitColumn;
    private final SchemaPath column;
    @JsonIgnore
    private UnnestRecordBatch unnestBatch;

    @JsonCreator
    public UnnestPOP(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="column") SchemaPath column, @JsonProperty(value="implicitColumn") String implicitColumn) {
        this.column = column;
        this.implicitColumn = implicitColumn;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        assert (children.isEmpty());
        UnnestPOP newUnnest = new UnnestPOP(null, this.column, this.implicitColumn);
        newUnnest.addUnnestBatch(this.unnestBatch);
        return newUnnest;
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    public SchemaPath getColumn() {
        return this.column;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitUnnest(this, value);
    }

    public void addUnnestBatch(UnnestRecordBatch unnestBatch) {
        this.unnestBatch = unnestBatch;
    }

    @JsonIgnore
    public UnnestRecordBatch getUnnestBatch() {
        return this.unnestBatch;
    }

    @JsonProperty(value="implicitColumn")
    public String getImplicitColumn() {
        return this.implicitColumn;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

