/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;

@JsonTypeName(value="window")
public class WindowPOP
extends AbstractSingle {
    public static final String OPERATOR_TYPE = "WINDOW";
    private final List<NamedExpression> withins;
    private final List<NamedExpression> aggregations;
    private final List<Order.Ordering> orderings;
    private final boolean frameUnitsRows;
    private final Bound start;
    private final Bound end;

    public WindowPOP(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="within") List<NamedExpression> withins, @JsonProperty(value="aggregations") List<NamedExpression> aggregations, @JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="frameUnitsRows") boolean frameUnitsRows, @JsonProperty(value="start") Bound start, @JsonProperty(value="end") Bound end) {
        super(child);
        this.withins = withins;
        this.aggregations = aggregations;
        this.orderings = orderings;
        this.frameUnitsRows = frameUnitsRows;
        this.start = start;
        this.end = end;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new WindowPOP(child, this.withins, this.aggregations, this.orderings, this.frameUnitsRows, this.start, this.end);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitWindowFrame(this, value);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public Bound getStart() {
        return this.start;
    }

    public Bound getEnd() {
        return this.end;
    }

    public List<NamedExpression> getAggregations() {
        return this.aggregations;
    }

    public List<NamedExpression> getWithins() {
        return this.withins;
    }

    public List<Order.Ordering> getOrderings() {
        return this.orderings;
    }

    public boolean isFrameUnitsRows() {
        return this.frameUnitsRows;
    }

    public String toString() {
        return "WindowPOP[withins=" + this.withins + ", aggregations=" + this.aggregations + ", orderings=" + this.orderings + ", frameUnitsRows=" + this.frameUnitsRows + ", start=" + this.start + ", end=" + this.end + "]";
    }

    public static Bound newBound(RexWindowBound windowBound) {
        return new Bound(windowBound.isUnbounded(), windowBound.isCurrentRow() ? 0L : Long.MIN_VALUE);
    }

    @JsonTypeName(value="windowBound")
    public static class Bound {
        private final boolean unbounded;
        private final long offset;

        public Bound(@JsonProperty(value="unbounded") boolean unbounded, @JsonProperty(value="offset") long offset) {
            this.unbounded = unbounded;
            this.offset = offset;
        }

        public boolean isUnbounded() {
            return this.unbounded;
        }

        @JsonIgnore
        public boolean isCurrent() {
            return this.offset == 0L;
        }

        public long getOffset() {
            return this.offset;
        }

        public String toString() {
            return "Bound[unbounded=" + this.unbounded + ", offset=" + this.offset + "]";
        }
    }
}

