/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BaseRootExec;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.physical.impl.validate.IteratorValidatorInjector;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.util.AssertionUtil;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplCreator {
    private static final Logger logger = LoggerFactory.getLogger(ImplCreator.class);
    private final LinkedList<CloseableRecordBatch> operators = Lists.newLinkedList();

    private ImplCreator() {
    }

    private List<CloseableRecordBatch> getOperators() {
        return this.operators;
    }

    public static RootExec getExec(ExecutorFragmentContext context, FragmentRoot root) throws ExecutionSetupException {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(context);
        if (AssertionUtil.isAssertionsEnabled() || context.getOptions().getOption(ExecConstants.ENABLE_ITERATOR_VALIDATOR) || context.getConfig().getBoolean("drill.exec.debug.validate_iterators")) {
            root = IteratorValidatorInjector.rewritePlanWithIteratorValidator(context, root);
        }
        ImplCreator creator = new ImplCreator();
        Stopwatch watch = Stopwatch.createStarted();
        try {
            RootExec rootExec = creator.getRootExec(root, context);
            if (rootExec instanceof BaseRootExec) {
                ((BaseRootExec)rootExec).setOperators(creator.getOperators());
            }
            logger.debug("Took {} ms to create RecordBatch tree", (Object)watch.elapsed(TimeUnit.MILLISECONDS));
            if (rootExec == null) {
                throw new ExecutionSetupException("The provided fragment did not have a root node that correctly created a RootExec value.");
            }
            return rootExec;
        }
        catch (Exception e) {
            AutoCloseables.close((Throwable)e, creator.getOperators());
            context.getExecutorState().fail(e);
            return null;
        }
    }

    private RootExec getRootExec(FragmentRoot root, ExecutorFragmentContext context) throws ExecutionSetupException {
        List<RecordBatch> childRecordBatches = this.getChildren(root, context);
        if (context.isImpersonationEnabled()) {
            UserGroupInformation proxyUgi = ImpersonationUtil.createProxyUgi(root.getUserName(), context.getQueryUserName());
            try {
                return (RootExec)proxyUgi.doAs(() -> ((RootCreator)this.getOpCreator(root, context)).getRoot(context, root, childRecordBatches));
            }
            catch (IOException | InterruptedException e) {
                String errMsg = String.format("Failed to create RootExec for operator with id '%d'", root.getOperatorId());
                logger.error(errMsg, (Throwable)e);
                throw new ExecutionSetupException(errMsg, e);
            }
        }
        return ((RootCreator)this.getOpCreator(root, context)).getRoot(context, root, childRecordBatches);
    }

    @VisibleForTesting
    public RecordBatch getRecordBatch(PhysicalOperator op, ExecutorFragmentContext context) throws ExecutionSetupException {
        Preconditions.checkNotNull(op);
        List<RecordBatch> childRecordBatches = this.getChildren(op, context);
        if (context.isImpersonationEnabled()) {
            UserGroupInformation proxyUgi = ImpersonationUtil.createProxyUgi(op.getUserName(), context.getQueryUserName());
            try {
                return (RecordBatch)proxyUgi.doAs(() -> {
                    CloseableRecordBatch batch = ((BatchCreator)this.getOpCreator(op, context)).getBatch(context, op, childRecordBatches);
                    this.operators.addFirst(batch);
                    return batch;
                });
            }
            catch (IOException | InterruptedException e) {
                String errMsg = String.format("Failed to create RecordBatch for operator with id '%d'", op.getOperatorId());
                logger.error(errMsg, (Throwable)e);
                throw new ExecutionSetupException(errMsg, e);
            }
        }
        CloseableRecordBatch batch = ((BatchCreator)this.getOpCreator(op, context)).getBatch(context, op, childRecordBatches);
        this.operators.addFirst(batch);
        return batch;
    }

    private Object getOpCreator(PhysicalOperator op, ExecutorFragmentContext context) throws ExecutionSetupException {
        Class<?> opClass = op.getClass();
        Object opCreator = context.getOperatorCreatorRegistry().getOperatorCreator(opClass);
        if (opCreator == null) {
            throw new UnsupportedOperationException(String.format("BatchCreator for PhysicalOperator type '%s' not found.", opClass.getCanonicalName()));
        }
        return opCreator;
    }

    private List<RecordBatch> getChildren(PhysicalOperator op, ExecutorFragmentContext context) throws ExecutionSetupException {
        ArrayList<RecordBatch> children = Lists.newArrayList();
        for (PhysicalOperator child : op) {
            children.add(this.getRecordBatch(child, context));
        }
        return children;
    }
}

