/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.physical.impl.WriterRecordBatch;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.BigIntVector;

public class InsertWriterRecordBatch
extends WriterRecordBatch {
    public InsertWriterRecordBatch(Writer writer, RecordBatch incoming, FragmentContext context, RecordWriter recordWriter) throws OutOfMemoryException {
        super(writer, incoming, context, recordWriter);
    }

    @Override
    protected void addOutputContainerData() {
        BigIntVector rowcountVector = (BigIntVector)this.container.getValueAccessorById(BigIntVector.class, this.container.getValueVectorId(SchemaPath.getSimplePath("ROWCOUNT")).getFieldIds()).getValueVector();
        AllocationHelper.allocate(rowcountVector, 1, 8);
        rowcountVector.getMutator().setSafe(0, this.counter);
        rowcountVector.getMutator().setValueCount(1);
        this.container.setRecordCount(1);
    }

    @Override
    protected void addOutputSchema() {
        MaterializedField rowcountField = MaterializedField.create("ROWCOUNT", Types.required(TypeProtos.MinorType.BIGINT));
        this.container.addOrGet(rowcountField);
    }
}

