/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import io.netty.buffer.DrillBuf;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.exec.util.CallBack;
import org.apache.drill.exec.util.Text;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanBatch
implements CloseableRecordBatch {
    private static final Logger logger = LoggerFactory.getLogger(ScanBatch.class);
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(ScanBatch.class);
    private final VectorContainer container = new VectorContainer();
    private int recordCount;
    private final FragmentContext context;
    private final OperatorContext oContext;
    private Iterator<? extends RecordReader> readers;
    private RecordReader currentReader;
    private BatchSchema schema;
    private final Mutator mutator;
    private boolean done;
    private final Iterator<Map<String, String>> implicitColumns;
    private Map<String, String> implicitValues;
    private final BufferAllocator allocator;
    private final List<Map<String, String>> implicitColumnList;
    private String currentReaderClassName;
    private final RecordBatchStats.RecordBatchStatsContext batchStatsContext;
    private RecordBatch.IterOutcome lastOutcome;
    private List<RecordReader> readerList;
    private boolean isRepeatableScan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanBatch(FragmentContext context, OperatorContext oContext, List<? extends RecordReader> readerList, List<Map<String, String>> implicitColumnList) {
        this.context = context;
        this.readers = readerList.iterator();
        this.implicitColumns = implicitColumnList.iterator();
        if (!this.readers.hasNext()) {
            throw UserException.internalError(new ExecutionSetupException("A scan batch must contain at least one reader.")).build(logger);
        }
        this.oContext = oContext;
        this.allocator = oContext.getAllocator();
        this.mutator = new Mutator(oContext, this.allocator, this.container);
        oContext.getStats().startProcessing();
        try {
            if (!this.verifyImplcitColumns(readerList.size(), implicitColumnList)) {
                ExecutionSetupException ex = new ExecutionSetupException("Either implicit column list does not have same cardinality as reader list, or implicit columns are not same across all the record readers!");
                throw UserException.internalError(ex).addContext("Setup failed for", readerList.get(0).getClass().getSimpleName()).build(logger);
            }
            this.implicitColumnList = implicitColumnList;
            this.addImplicitVectors();
            this.currentReader = null;
            this.batchStatsContext = new RecordBatchStats.RecordBatchStatsContext(context, oContext);
        }
        finally {
            oContext.getStats().stopProcessing();
        }
    }

    public ScanBatch(PhysicalOperator subScanConfig, FragmentContext context, List<RecordReader> readers) throws ExecutionSetupException {
        this(context, context.newOperatorContext(subScanConfig), readers, Collections.emptyList());
    }

    public ScanBatch(PhysicalOperator subScanConfig, FragmentContext context, List<RecordReader> readerList, boolean isRepeatableScan) throws ExecutionSetupException {
        this(context, context.newOperatorContext(subScanConfig), readerList, Collections.emptyList());
        this.readerList = readerList;
        this.isRepeatableScan = isRepeatableScan;
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    public OperatorContext getOperatorContext() {
        return this.oContext;
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public void cancel() {
        this.done = true;
        this.releaseAssets();
    }

    private RecordBatch.IterOutcome cleanAndReturnNone() {
        if (this.isRepeatableScan) {
            this.readers = this.readerList.iterator();
        } else {
            this.releaseAssets();
            this.done = true;
        }
        return RecordBatch.IterOutcome.NONE;
    }

    private boolean shouldContinueAfterNoRecords() {
        logger.trace("scan got 0 record.");
        if (this.isRepeatableScan) {
            if (!this.currentReader.hasNext()) {
                this.currentReader = null;
                this.readers = this.readerList.iterator();
                return false;
            }
            return true;
        }
        this.closeCurrentReader();
        return true;
    }

    private void closeCurrentReader() {
        AutoCloseables.closeSilently(this.currentReader);
        this.currentReader = null;
    }

    private RecordBatch.IterOutcome internalNext() {
        block8: {
            boolean toContinueIter;
            do {
                if (this.currentReader == null && !this.getNextReaderIfHas()) {
                    logger.trace("currentReader is null");
                    return this.cleanAndReturnNone();
                }
                injector.injectChecked(this.context.getExecutionControls(), "next-allocate", OutOfMemoryException.class);
                this.currentReader.allocate(this.mutator.fieldVectorMap());
                this.recordCount = this.currentReader.next();
                logger.trace("currentReader.next return recordCount={}", (Object)this.recordCount);
                Preconditions.checkArgument(this.recordCount >= 0, "recordCount from RecordReader.next() should not be negative");
                boolean isNewSchema = this.mutator.isNewSchema();
                if (this.implicitValues != null) {
                    String projectMetadataColumn = this.context.getOptions().getOption(ExecConstants.IMPLICIT_PROJECT_METADATA_COLUMN_LABEL_VALIDATOR);
                    if (this.recordCount > 0) {
                        this.implicitValues.replace(projectMetadataColumn, null);
                    } else if (Boolean.FALSE.toString().equals(this.implicitValues.get(projectMetadataColumn))) {
                        ++this.recordCount;
                        this.implicitValues.put(projectMetadataColumn, Boolean.TRUE.toString());
                    }
                }
                this.populateImplicitVectors();
                this.mutator.container.setValueCount(this.recordCount);
                this.oContext.getStats().batchReceived(0, this.recordCount, isNewSchema);
                toContinueIter = true;
                if (this.recordCount == 0) {
                    toContinueIter = this.shouldContinueAfterNoRecords();
                }
                if (isNewSchema) {
                    this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                    this.schema = this.container.getSchema();
                    this.lastOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                    return this.lastOutcome;
                }
                if (this.recordCount != 0) break block8;
            } while (toContinueIter);
            this.lastOutcome = RecordBatch.IterOutcome.NONE;
            return this.lastOutcome;
        }
        this.lastOutcome = RecordBatch.IterOutcome.OK;
        return this.lastOutcome;
    }

    @Override
    public RecordBatch.IterOutcome next() {
        if (this.done) {
            this.lastOutcome = RecordBatch.IterOutcome.NONE;
            return this.lastOutcome;
        }
        this.oContext.getStats().startProcessing();
        try {
            RecordBatch.IterOutcome iterOutcome = this.internalNext();
            return iterOutcome;
        }
        catch (OutOfMemoryException ex) {
            this.clearFieldVectorMap();
            throw UserException.memoryError(ex).build(logger);
        }
        catch (UserException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw UserException.internalError(ex).build(logger);
        }
        finally {
            this.oContext.getStats().stopProcessing();
        }
    }

    private void releaseAssets() {
        this.container.zeroVectors();
    }

    private void clearFieldVectorMap() {
        VectorAccessibleUtilities.clear(this.mutator.fieldVectorMap().values());
        VectorAccessibleUtilities.clear(this.mutator.implicitFieldVectorMap.values());
    }

    private boolean getNextReaderIfHas() {
        if (!this.readers.hasNext()) {
            return false;
        }
        this.currentReader = this.readers.next();
        if (!this.isRepeatableScan && this.readers.hasNext()) {
            this.readers.remove();
        }
        this.implicitValues = this.implicitColumns.hasNext() ? this.implicitColumns.next() : null;
        this.currentReaderClassName = this.currentReader.getClass().getSimpleName();
        try {
            this.currentReader.setup(this.oContext, this.mutator);
        }
        catch (ExecutionSetupException e) {
            this.closeCurrentReader();
            throw UserException.executionError(e).addContext("Failed to setup reader", this.currentReaderClassName).build(logger);
        }
        return true;
    }

    private void addImplicitVectors() {
        try {
            if (!this.implicitColumnList.isEmpty()) {
                for (String column : this.implicitColumnList.get(0).keySet()) {
                    MaterializedField field = MaterializedField.create(column, Types.optional(TypeProtos.MinorType.VARCHAR));
                    this.mutator.addField(field, NullableVarCharVector.class, true);
                }
            }
        }
        catch (SchemaChangeException e) {
            throw UserException.internalError(e).addContext("Failure while allocating implicit vectors").build(logger);
        }
    }

    private void populateImplicitVectors() {
        this.mutator.populateImplicitVectors(this.implicitValues, this.recordCount);
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        return null;
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    private void logRecordBatchStats() {
        int MAX_FQN_LENGTH = 50;
        if (this.recordCount == 0) {
            return;
        }
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this.getFQNForLogging(50), this, this.batchStatsContext);
    }

    private String getFQNForLogging(int maxLength) {
        Text fqnObj;
        String FQNKey = "FQN";
        ValueVector v = (ValueVector)this.mutator.implicitFieldVectorMap.get("FQN");
        if (v == null || v.getAccessor().getValueCount() == 0 || (fqnObj = ((NullableVarCharVector)v).getAccessor().getObject(0)) == null) {
            return "NA";
        }
        String fqn = ((Object)fqnObj).toString();
        if (fqn != null && fqn.length() > maxLength) {
            fqn = fqn.substring(fqn.length() - maxLength, fqn.length());
        }
        return fqn;
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public WritableBatch getWritableBatch() {
        return WritableBatch.get(this);
    }

    @Override
    public void close() throws Exception {
        this.container.clear();
        this.mutator.clear();
        this.closeCurrentReader();
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        throw new UnsupportedOperationException(String.format("You should not call getOutgoingContainer() for class %s", this.getClass().getCanonicalName()));
    }

    @Override
    public VectorContainer getContainer() {
        return this.container;
    }

    private boolean verifyImplcitColumns(int numReaders, List<Map<String, String>> implicitColumnList) {
        if (implicitColumnList.isEmpty()) {
            return true;
        }
        if (numReaders != implicitColumnList.size()) {
            return false;
        }
        Map<String, String> firstMap = implicitColumnList.get(0);
        for (int i = 1; i < implicitColumnList.size(); ++i) {
            Map<String, String> nonFirstMap = implicitColumnList.get(i);
            if (firstMap.keySet().equals(nonFirstMap.keySet())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dump() {
        logger.error("ScanBatch[container={}, currentReader={}, schema={}]", new Object[]{this.container, this.currentReader, this.schema});
    }

    @VisibleForTesting
    public static class Mutator
    implements OutputMutator {
        private boolean schemaChanged;
        private final CaseInsensitiveMap<ValueVector> regularFieldVectorMap = CaseInsensitiveMap.newHashMap();
        private final CaseInsensitiveMap<ValueVector> implicitFieldVectorMap = CaseInsensitiveMap.newHashMap();
        private final SchemaChangeCallBack callBack = new SchemaChangeCallBack();
        private final BufferAllocator allocator;
        private final VectorContainer container;
        private final OperatorContext oContext;

        public Mutator(OperatorContext oContext, BufferAllocator allocator, VectorContainer container) {
            this.oContext = oContext;
            this.allocator = allocator;
            this.container = container;
            this.schemaChanged = false;
        }

        public Map<String, ValueVector> fieldVectorMap() {
            return this.regularFieldVectorMap;
        }

        public Map<String, ValueVector> implicitFieldVectorMap() {
            return this.implicitFieldVectorMap;
        }

        @Override
        public <T extends ValueVector> T addField(MaterializedField field, Class<T> clazz) throws SchemaChangeException {
            return this.addField(field, clazz, false);
        }

        @Override
        public void allocate(int recordCount) {
            for (ValueVector v : this.regularFieldVectorMap.values()) {
                AllocationHelper.allocate(v, recordCount, 50, 10);
            }
        }

        @Override
        public boolean isNewSchema() {
            boolean deeperSchemaChanged = this.callBack.getSchemaChangedAndReset();
            if (this.schemaChanged || deeperSchemaChanged) {
                this.schemaChanged = false;
                return true;
            }
            return false;
        }

        @Override
        public DrillBuf getManagedBuffer() {
            return this.oContext.getManagedBuffer();
        }

        @Override
        public CallBack getCallBack() {
            return this.callBack;
        }

        @Override
        public void clear() {
            this.regularFieldVectorMap.clear();
            this.implicitFieldVectorMap.clear();
            this.container.clear();
            this.schemaChanged = false;
        }

        private <T extends ValueVector> T addField(MaterializedField field, Class<T> clazz, boolean isImplicitField) throws SchemaChangeException {
            CaseInsensitiveMap<ValueVector> fieldVectorMap = isImplicitField ? this.implicitFieldVectorMap : this.regularFieldVectorMap;
            if (!isImplicitField && this.implicitFieldVectorMap.containsKey(field.getName()) || isImplicitField && this.regularFieldVectorMap.containsKey(field.getName())) {
                throw new SchemaChangeException(String.format("It's not allowed to have regular field and implicit field share common name %s. Either change regular field name in datasource, or change the default implicit field names.", field.getName()));
            }
            ValueVector v = (ValueVector)fieldVectorMap.get(field.getName());
            if (v == null || !v.getField().getType().equals(field.getType())) {
                v = TypeHelper.getNewVector(field, this.allocator, this.callBack);
                if (!clazz.isAssignableFrom(v.getClass())) {
                    throw new SchemaChangeException(String.format("The class that was provided, %s, does not correspond to the expected vector type of %s.", clazz.getSimpleName(), v.getClass().getSimpleName()));
                }
                ValueVector old = fieldVectorMap.put(field.getName(), v);
                if (old != null) {
                    old.clear();
                    this.container.remove(old);
                }
                this.container.add(v);
                if (!isImplicitField) {
                    this.schemaChanged = true;
                }
            }
            return (T)((ValueVector)clazz.cast(v));
        }

        private void populateImplicitVectors(Map<String, String> implicitValues, int recordCount) {
            if (implicitValues != null) {
                for (Map.Entry<String, String> entry : implicitValues.entrySet()) {
                    NullableVarCharVector v = (NullableVarCharVector)this.implicitFieldVectorMap.get(entry.getKey());
                    String val = entry.getValue();
                    if (val != null) {
                        AllocationHelper.allocate(v, recordCount, val.length());
                        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
                        for (int j = 0; j < recordCount; ++j) {
                            v.getMutator().setSafe(j, bytes, 0, bytes.length);
                        }
                        v.getMutator().setValueCount(recordCount);
                        continue;
                    }
                    AllocationHelper.allocate(v, recordCount, 0);
                    v.getMutator().setValueCount(recordCount);
                }
            }
        }
    }
}

