/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.TopN;

import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.drill.common.DrillAutoCloseables;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.TopN;
import org.apache.drill.exec.physical.impl.TopN.PriorityQueue;
import org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import org.apache.drill.exec.physical.impl.sort.SortRecordBatchBuilder;
import org.apache.drill.exec.physical.impl.svremover.Copier;
import org.apache.drill.exec.physical.impl.svremover.GenericCopierFactory;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.ExpandableHyperContainer;
import org.apache.drill.exec.record.HyperVectorWrapper;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.SchemaUtil;
import org.apache.drill.exec.record.SimpleRecordBatch;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNBatch
extends AbstractRecordBatch<TopN> {
    private static final Logger logger = LoggerFactory.getLogger(TopNBatch.class);
    private final MappingSet mainMapping = TopNBatch.createMainMappingSet();
    private final MappingSet leftMapping = TopNBatch.createLeftMappingSet();
    private final MappingSet rightMapping = TopNBatch.createRightMappingSet();
    private final int batchPurgeThreshold;
    private final boolean codegenDump;
    private final RecordBatch incoming;
    private BatchSchema schema;
    private boolean schemaChanged;
    private PriorityQueue priorityQueue;
    private final TopN config;
    private SelectionVector4 sv4;
    private long countSincePurge;
    private int batchCount;
    private Copier copier;
    private boolean first = true;
    private int recordCount;
    private RecordBatch.IterOutcome lastKnownOutcome = RecordBatch.IterOutcome.OK;
    private boolean firstBatchForSchema = true;
    private boolean hasOutputRecords;

    public TopNBatch(TopN popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context);
        this.incoming = incoming;
        this.config = popConfig;
        DrillConfig drillConfig = context.getConfig();
        this.batchPurgeThreshold = drillConfig.getInt("drill.exec.sort.purge.threshold");
        this.codegenDump = drillConfig.getBoolean("drill.exec.compile.codegen.debug.topn");
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        return this.sv4;
    }

    @Override
    public void close() {
        this.releaseResource();
        super.close();
    }

    @Override
    public void buildSchema() {
        RecordBatch.IterOutcome outcome = this.next(this.incoming);
        switch (outcome) {
            case OK: 
            case OK_NEW_SCHEMA: {
                for (VectorWrapper w : this.incoming) {
                    Object v = this.container.addOrGet(w.getField());
                    if (v instanceof AbstractContainerVector) {
                        w.getValueVector().makeTransferPair((ValueVector)v);
                        v.clear();
                    }
                    v.allocateNew();
                }
                this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                this.container.setRecordCount(0);
                return;
            }
            case NONE: {
                this.state = AbstractRecordBatch.BatchState.DONE;
                return;
            }
            case EMIT: {
                throw new IllegalStateException("Unexpected EMIT outcome received in buildSchema phase");
            }
        }
        throw new IllegalStateException("Unexpected outcome received in buildSchema phase");
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        this.recordCount = 0;
        if (this.state == AbstractRecordBatch.BatchState.DONE) {
            return RecordBatch.IterOutcome.NONE;
        }
        if (this.hasOutputRecords) {
            return this.handleRemainingOutput();
        }
        this.resetTopNState();
        boolean incomingHasSv2 = false;
        switch (this.incoming.getSchema().getSelectionVectorMode()) {
            case NONE: {
                break;
            }
            case TWO_BYTE: {
                incomingHasSv2 = true;
                break;
            }
            case FOUR_BYTE: {
                throw UserException.internalError(null).message("TopN doesn't support incoming with SV4 mode", new Object[0]).build(logger);
            }
            default: {
                throw new UnsupportedOperationException("Unsupported SV mode detected in TopN incoming batch");
            }
        }
        block16: do {
            Stopwatch watch = Stopwatch.createStarted();
            if (this.first) {
                this.lastKnownOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                this.sv4 = new SelectionVector4(this.context.getAllocator(), 0);
                this.first = false;
            } else {
                this.lastKnownOutcome = this.next(this.incoming);
            }
            if (this.lastKnownOutcome == RecordBatch.IterOutcome.OK && this.schema == null) {
                this.lastKnownOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                this.container.clear();
            }
            logger.debug("Took {} us to get next", (Object)watch.elapsed(TimeUnit.MICROSECONDS));
            switch (this.lastKnownOutcome) {
                case NONE: {
                    break block16;
                }
                case NOT_YET: {
                    throw new UnsupportedOperationException();
                }
                case OK_NEW_SCHEMA: {
                    this.container.clear();
                    this.firstBatchForSchema = true;
                    if (!this.incoming.getSchema().equals(this.schema)) {
                        if (this.schema != null) {
                            if (!this.unionTypeEnabled) {
                                throw new UnsupportedOperationException(String.format("TopN currently doesn't support changing schemas with union type disabled. Please try enabling union type: %s and re-execute the query", "exec.enable_union_type"));
                            }
                            this.schema = SchemaUtil.mergeSchemas(this.schema, this.incoming.getSchema());
                            this.purgeAndResetPriorityQueue();
                            this.schemaChanged = true;
                        } else {
                            this.schema = this.incoming.getSchema();
                        }
                    }
                }
                case OK: 
                case EMIT: {
                    if (this.incoming.getRecordCount() == 0) {
                        for (VectorWrapper w : this.incoming) {
                            w.clear();
                        }
                        if (!incomingHasSv2) continue block16;
                        this.incoming.getSelectionVector2().clear();
                        break;
                    }
                    this.countSincePurge += (long)this.incoming.getRecordCount();
                    ++this.batchCount;
                    RecordBatchData batch = this.schemaChanged ? new RecordBatchData(SchemaUtil.coerceContainer((VectorAccessible)this.incoming, this.schema, this.oContext), this.oContext.getAllocator()) : new RecordBatchData(this.incoming, this.oContext.getAllocator());
                    boolean success = false;
                    try {
                        if (this.priorityQueue == null) {
                            this.priorityQueue = this.createNewPriorityQueue(new ExpandableHyperContainer(batch.getContainer()), this.config.getLimit());
                        } else if (!this.priorityQueue.isInitialized()) {
                            this.priorityQueue.init(this.config.getLimit(), this.oContext.getAllocator(), this.schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE);
                        }
                        this.priorityQueue.add(batch);
                        if (this.countSincePurge > (long)this.config.getLimit() && this.batchCount > this.batchPurgeThreshold) {
                            this.purge();
                            this.countSincePurge = 0L;
                            this.batchCount = 0;
                        }
                        success = true;
                        continue block16;
                    }
                    catch (SchemaChangeException e) {
                        throw this.schemaChangeException(e, logger);
                    }
                    finally {
                        if (!success) {
                            batch.clear();
                        }
                    }
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        } while (this.lastKnownOutcome != RecordBatch.IterOutcome.EMIT);
        if (this.schema == null || this.priorityQueue == null || !this.priorityQueue.isInitialized()) {
            return this.handleEmptyBatches(this.lastKnownOutcome);
        }
        this.priorityQueue.generate();
        this.prepareOutputContainer(this.priorityQueue.getHyperBatch(), this.priorityQueue.getFinalSv4());
        return this.getFinalOutcome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        Stopwatch watch = Stopwatch.createStarted();
        VectorContainer c = this.priorityQueue.getHyperBatch();
        VectorContainer newContainer = new VectorContainer(this.oContext);
        SelectionVector4 selectionVector4 = this.priorityQueue.getSv4();
        SimpleSV4RecordBatch batch = new SimpleSV4RecordBatch(c, selectionVector4, this.context);
        if (this.copier == null) {
            this.copier = GenericCopierFactory.createAndSetupCopier(batch, newContainer, null);
        } else {
            for (VectorWrapper<?> i : batch) {
                ValueVector v = TypeHelper.getNewVector(i.getField(), this.oContext.getAllocator());
                newContainer.add(v);
            }
            this.copier.setup(batch, newContainer);
        }
        SortRecordBatchBuilder builder = new SortRecordBatchBuilder(this.oContext.getAllocator());
        try {
            this.copyToPurge(newContainer, builder);
            VectorContainer newQueue = new VectorContainer();
            builder.build(newQueue);
            try {
                this.priorityQueue.resetQueue(newQueue, builder.getSv4().createNewWrapperCurrent());
            }
            catch (SchemaChangeException e) {
                throw this.schemaChangeException(e, logger);
            }
            builder.getSv4().clear();
        }
        finally {
            DrillAutoCloseables.closeNoChecked(builder);
        }
        logger.debug("Took {} us to purge", (Object)watch.elapsed(TimeUnit.MICROSECONDS));
    }

    private PriorityQueue createNewPriorityQueue(VectorAccessible batch, int limit) {
        return TopNBatch.createNewPriorityQueue(this.mainMapping, this.leftMapping, this.rightMapping, this.config.getOrderings(), batch, this.unionTypeEnabled, this.codegenDump, limit, this.oContext.getAllocator(), this.schema.getSelectionVectorMode(), this.context);
    }

    public static MappingSet createMainMappingSet() {
        return new MappingSet((String)null, null, ClassGenerator.DEFAULT_SCALAR_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    }

    public static MappingSet createLeftMappingSet() {
        return new MappingSet("leftIndex", null, ClassGenerator.DEFAULT_SCALAR_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    }

    public static MappingSet createRightMappingSet() {
        return new MappingSet("rightIndex", null, ClassGenerator.DEFAULT_SCALAR_MAP, ClassGenerator.DEFAULT_SCALAR_MAP);
    }

    public static PriorityQueue createNewPriorityQueue(MappingSet mainMapping, MappingSet leftMapping, MappingSet rightMapping, List<Order.Ordering> orderings, VectorAccessible batch, boolean unionTypeEnabled, boolean codegenDump, int limit, BufferAllocator allocator, BatchSchema.SelectionVectorMode mode, FragmentContext context) {
        OptionManager optionSet = context.getOptions();
        FunctionLookupContext functionLookupContext = context.getFunctionRegistry();
        CodeGenerator<PriorityQueue> cg = CodeGenerator.get(PriorityQueue.TEMPLATE_DEFINITION, optionSet);
        cg.plainJavaCapable(true);
        cg.saveCodeForDebugging(codegenDump);
        ClassGenerator<PriorityQueue> g = cg.getRoot();
        g.setMappingSet(mainMapping);
        for (Order.Ordering od : orderings) {
            ErrorCollectorImpl collector = new ErrorCollectorImpl();
            LogicalExpression expr = ExpressionTreeMaterializer.materialize(od.getExpr(), batch, collector, functionLookupContext, unionTypeEnabled);
            collector.reportErrors(logger);
            g.setMappingSet(leftMapping);
            ClassGenerator.HoldingContainer left = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(rightMapping);
            ClassGenerator.HoldingContainer right = g.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            g.setMappingSet(mainMapping);
            LogicalExpression fh = FunctionGenerationHelper.getOrderingComparator(od.nullsSortHigh(), left, right, functionLookupContext);
            ClassGenerator.HoldingContainer out = g.addExpr(fh, ClassGenerator.BlkCreateMode.FALSE);
            JConditional jc = g.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)));
            if (od.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                jc._then()._return((JExpression)out.getValue());
            } else {
                jc._then()._return(out.getValue().minus());
            }
            g.rotateBlock();
        }
        g.rotateBlock();
        g.getEvalBlock()._return(JExpr.lit((int)0));
        PriorityQueue q = context.getImplementationClass(cg);
        try {
            q.init(limit, allocator, mode == BatchSchema.SelectionVectorMode.TWO_BYTE);
        }
        catch (SchemaChangeException e) {
            throw TopNBatch.schemaChangeException(e, "Top N", logger);
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAndResetPriorityQueue() {
        Stopwatch watch = Stopwatch.createStarted();
        VectorContainer c = this.priorityQueue.getHyperBatch();
        VectorContainer newContainer = new VectorContainer(this.oContext);
        SelectionVector4 selectionVector4 = this.priorityQueue.getSv4();
        SimpleSV4RecordBatch batch = new SimpleSV4RecordBatch(c, selectionVector4, this.context);
        this.copier = GenericCopierFactory.createAndSetupCopier(batch, newContainer, null);
        SortRecordBatchBuilder builder = new SortRecordBatchBuilder(this.oContext.getAllocator());
        try {
            this.copyToPurge(newContainer, builder);
            VectorContainer oldSchemaContainer = new VectorContainer(this.oContext);
            builder.build(oldSchemaContainer);
            oldSchemaContainer.setRecordCount(builder.getSv4().getCount());
            VectorContainer newSchemaContainer = SchemaUtil.coerceContainer((VectorAccessible)oldSchemaContainer, this.schema, this.oContext);
            newSchemaContainer.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
            this.priorityQueue.cleanup();
            this.priorityQueue = this.createNewPriorityQueue(newSchemaContainer, this.config.getLimit());
            try {
                this.priorityQueue.resetQueue(newSchemaContainer, builder.getSv4().createNewWrapperCurrent());
            }
            catch (SchemaChangeException e) {
                throw this.schemaChangeException(e, logger);
            }
        }
        finally {
            builder.clear();
            builder.close();
        }
        logger.debug("Took {} us to purge and recreate queue for new schema", (Object)watch.elapsed(TimeUnit.MICROSECONDS));
    }

    @Override
    public WritableBatch getWritableBatch() {
        throw new UnsupportedOperationException("A sort batch is not writable.");
    }

    @Override
    protected void cancelIncoming() {
        this.incoming.cancel();
    }

    private void resetTopNState() {
        this.lastKnownOutcome = RecordBatch.IterOutcome.OK;
        this.countSincePurge = 0L;
        this.batchCount = 0;
        this.hasOutputRecords = false;
        this.releaseResource();
    }

    private void releaseResource() {
        if (this.sv4 != null) {
            this.sv4.clear();
        }
        if (this.priorityQueue != null) {
            this.priorityQueue.cleanup();
        }
        this.container.zeroVectors();
    }

    private RecordBatch.IterOutcome getFinalOutcome() {
        RecordBatch.IterOutcome outcomeToReturn;
        if (this.firstBatchForSchema) {
            outcomeToReturn = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            this.firstBatchForSchema = false;
        } else if (this.recordCount == 0) {
            outcomeToReturn = this.lastKnownOutcome == RecordBatch.IterOutcome.EMIT ? RecordBatch.IterOutcome.EMIT : RecordBatch.IterOutcome.NONE;
            this.resetTopNState();
        } else if (this.lastKnownOutcome == RecordBatch.IterOutcome.EMIT) {
            boolean hasMoreRecords = this.sv4.hasNext();
            outcomeToReturn = hasMoreRecords ? RecordBatch.IterOutcome.OK : RecordBatch.IterOutcome.EMIT;
            this.hasOutputRecords = hasMoreRecords;
        } else {
            outcomeToReturn = RecordBatch.IterOutcome.OK;
        }
        return outcomeToReturn;
    }

    private void copyToPurge(VectorContainer newContainer, SortRecordBatchBuilder batchBuilder) {
        VectorContainer c = this.priorityQueue.getHyperBatch();
        SelectionVector4 queueSv4 = this.priorityQueue.getSv4();
        SimpleSV4RecordBatch newBatch = new SimpleSV4RecordBatch(newContainer, null, this.context);
        do {
            int count = queueSv4.getCount();
            int copiedRecords = this.copier.copyRecords(0, count);
            assert (copiedRecords == count);
            newContainer.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            newContainer.setValueCount(count);
            batchBuilder.add(newBatch);
        } while (queueSv4.next());
        queueSv4.clear();
        c.clear();
    }

    private void prepareOutputContainer(VectorContainer dataContainer, SelectionVector4 dataSv4) {
        this.container.zeroVectors();
        this.hasOutputRecords = true;
        if (this.firstBatchForSchema) {
            this.container.clear();
            for (VectorWrapper<?> w : dataContainer) {
                this.container.add(w.getValueVectors());
            }
            this.container.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
            this.sv4 = dataSv4;
        } else {
            int index = 0;
            for (VectorWrapper<?> w : dataContainer) {
                HyperVectorWrapper wrapper = (HyperVectorWrapper)this.container.getValueVector(index++);
                wrapper.updateVectorList(w.getValueVectors());
            }
            this.sv4.copy(dataSv4);
        }
        this.recordCount = this.sv4.getCount();
        this.container.setRecordCount(this.recordCount);
    }

    private RecordBatch.IterOutcome handleRemainingOutput() {
        if (this.priorityQueue != null && this.sv4.next()) {
            this.recordCount = this.sv4.getCount();
            this.container.setRecordCount(this.recordCount);
        } else {
            this.recordCount = 0;
            this.container.setRecordCount(0);
        }
        return this.getFinalOutcome();
    }

    private RecordBatch.IterOutcome handleEmptyBatches(RecordBatch.IterOutcome incomingOutcome) {
        RecordBatch.IterOutcome outcomeToReturn = incomingOutcome;
        if (incomingOutcome == RecordBatch.IterOutcome.NONE) {
            this.state = AbstractRecordBatch.BatchState.DONE;
            this.container.clear();
            this.recordCount = 0;
            this.container.setRecordCount(this.recordCount);
        } else if (incomingOutcome == RecordBatch.IterOutcome.EMIT) {
            assert (this.countSincePurge == 0L && this.batchCount == 0);
            ExpandableHyperContainer hyperContainer = new ExpandableHyperContainer(this.incoming.getContainer());
            this.prepareOutputContainer(hyperContainer, this.sv4);
            outcomeToReturn = this.getFinalOutcome();
        }
        return outcomeToReturn;
    }

    @Override
    public void dump() {
        logger.error("TopNBatch[container={}, config={}, schema={}, sv4={}, countSincePurge={}, batchCount={}, recordCount={}]", new Object[]{this.container, this.config, this.schema, this.sv4, this.countSincePurge, this.batchCount, this.recordCount});
    }

    public static class SimpleSV4RecordBatch
    extends SimpleRecordBatch {
        private final SelectionVector4 sv4;

        public SimpleSV4RecordBatch(VectorContainer container, SelectionVector4 sv4, FragmentContext context) {
            super(container, context);
            this.sv4 = sv4;
        }

        @Override
        public int getRecordCount() {
            if (this.sv4 != null) {
                return this.sv4.getCount();
            }
            return super.getRecordCount();
        }

        @Override
        public SelectionVector4 getSelectionVector4() {
            return this.sv4;
        }
    }
}

