/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.util.ArrayList;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.Trace;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceInjector
extends AbstractPhysicalVisitor<PhysicalOperator, FragmentContext, ExecutionSetupException> {
    static final Logger logger = LoggerFactory.getLogger(TraceInjector.class);
    static int traceTagCount = 0;
    RootExec root = null;

    public static PhysicalOperator getExec(FragmentContext context, FragmentRoot root) throws ExecutionSetupException {
        TraceInjector tI = new TraceInjector();
        PhysicalOperator newOp = root.accept(tI, context);
        return newOp;
    }

    @Override
    public PhysicalOperator visitOp(PhysicalOperator op, FragmentContext context) throws ExecutionSetupException {
        ArrayList<PhysicalOperator> newChildren = Lists.newArrayList();
        ArrayList<PhysicalOperator> list = null;
        PhysicalOperator newOp = op;
        for (PhysicalOperator child : op) {
            newChildren.add(child.accept(this, context));
        }
        list = Lists.newArrayList();
        for (int i = 0; i < newChildren.size(); ++i) {
            String traceTag = ((PhysicalOperator)newChildren.get(i)).toString() + Integer.toString(traceTagCount++);
            Trace traceOp = new Trace((PhysicalOperator)newChildren.get(i), traceTag);
            list.add(traceOp);
        }
        if (list.size() > 0) {
            newOp = op.getNewWithChildren(list);
        }
        newOp.setOperatorId(op.getOperatorId());
        return newOp;
    }
}

