/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterRecordBatch
extends AbstractRecordBatch<Writer> {
    private static final Logger logger = LoggerFactory.getLogger(WriterRecordBatch.class);
    private EventBasedRecordWriter eventBasedRecordWriter;
    private RecordWriter recordWriter;
    protected long counter;
    private final RecordBatch incoming;
    private boolean processed;
    private final String fragmentUniqueId;
    private BatchSchema schema;

    public WriterRecordBatch(Writer writer, RecordBatch incoming, FragmentContext context, RecordWriter recordWriter) throws OutOfMemoryException {
        super(writer, context, false);
        this.incoming = incoming;
        ExecProtos.FragmentHandle handle = context.getHandle();
        this.fragmentUniqueId = String.format("%d_%d", handle.getMajorFragmentId(), handle.getMinorFragmentId());
        this.recordWriter = recordWriter;
    }

    @Override
    public int getRecordCount() {
        return this.container.getRecordCount();
    }

    @Override
    protected void cancelIncoming() {
        this.incoming.cancel();
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        RecordBatch.IterOutcome upstream;
        if (this.processed) {
            return RecordBatch.IterOutcome.NONE;
        }
        block8: do {
            upstream = this.next(this.incoming);
            switch (upstream) {
                case NOT_YET: {
                    break;
                }
                case NONE: {
                    if (this.schema != null) continue block8;
                }
                case OK_NEW_SCHEMA: {
                    this.setupNewSchema();
                }
                case OK: {
                    try {
                        this.counter += (long)this.eventBasedRecordWriter.write(this.incoming.getRecordCount());
                    }
                    catch (IOException e) {
                        throw UserException.dataWriteError(e).addContext("Failure when writing the batch").build(logger);
                    }
                    logger.debug("Total records written so far: {}", (Object)this.counter);
                    for (VectorWrapper v : this.incoming) {
                        v.getValueVector().clear();
                    }
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        } while (upstream != RecordBatch.IterOutcome.NONE);
        this.addOutputContainerData();
        this.processed = true;
        this.closeWriter();
        return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
    }

    protected void addOutputContainerData() {
        VarCharVector fragmentIdVector = (VarCharVector)this.container.getValueAccessorById(VarCharVector.class, this.container.getValueVectorId(SchemaPath.getSimplePath("Fragment")).getFieldIds()).getValueVector();
        AllocationHelper.allocate(fragmentIdVector, 1, 50);
        BigIntVector summaryVector = (BigIntVector)this.container.getValueAccessorById(BigIntVector.class, this.container.getValueVectorId(SchemaPath.getSimplePath("Number of records written")).getFieldIds()).getValueVector();
        AllocationHelper.allocate(summaryVector, 1, 8);
        fragmentIdVector.getMutator().setSafe(0, this.fragmentUniqueId.getBytes(StandardCharsets.UTF_8));
        fragmentIdVector.getMutator().setValueCount(1);
        summaryVector.getMutator().setSafe(0, this.counter);
        summaryVector.getMutator().setValueCount(1);
        this.container.setRecordCount(1);
    }

    protected void setupNewSchema() {
        try {
            this.stats.startSetup();
            try {
                this.recordWriter.updateSchema(this.incoming);
            }
            catch (IOException e) {
                throw UserException.dataWriteError(e).addContext("Failure updating record writer schema").build(logger);
            }
            this.addOutputSchema();
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
        finally {
            this.stats.stopSetup();
        }
        try {
            this.eventBasedRecordWriter = new EventBasedRecordWriter(this.incoming, this.recordWriter);
        }
        catch (IOException e) {
            throw UserException.dataWriteError(e).addContext("Failed to create the event record writer").build(logger);
        }
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.schema = this.container.getSchema();
    }

    protected void addOutputSchema() {
        MaterializedField fragmentIdField = MaterializedField.create("Fragment", Types.required(TypeProtos.MinorType.VARCHAR));
        MaterializedField summaryField = MaterializedField.create("Number of records written", Types.required(TypeProtos.MinorType.BIGINT));
        this.container.addOrGet(fragmentIdField);
        this.container.addOrGet(summaryField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeWriter() {
        if (this.recordWriter == null) {
            return;
        }
        try {
            this.recordWriter.postProcessing();
            this.recordWriter.cleanup();
            return;
        }
        catch (IOException ex) {
            this.context.getExecutorState().fail(ex);
            return;
        }
        finally {
            try {
                if (!this.processed) {
                    this.recordWriter.abort();
                }
            }
            catch (IOException e) {
                logger.error("Abort failed. There could be leftover output files.", (Throwable)e);
            }
            finally {
                this.recordWriter = null;
            }
        }
    }

    @Override
    public void close() {
        this.closeWriter();
        super.close();
    }

    @Override
    public void dump() {
        logger.error("WriterRecordBatch[container={}, popConfig={}, counter={}, fragmentUniqueId={}, schema={}]", new Object[]{this.container, this.popConfig, this.counter, this.fragmentUniqueId, this.schema});
    }
}

