/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.aggregate;

import org.apache.drill.exec.physical.impl.common.AbstractSpilledPartitionMetadata;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class HashAggSpilledPartition
extends AbstractSpilledPartitionMetadata {
    private final int spilledBatches;
    private final String spillFile;

    public HashAggSpilledPartition(int cycle, int originPartition, int prevOriginPartition, int spilledBatches, String spillFile) {
        super(cycle, originPartition, prevOriginPartition);
        this.spilledBatches = spilledBatches;
        this.spillFile = Preconditions.checkNotNull(spillFile);
    }

    public int getSpilledBatches() {
        return this.spilledBatches;
    }

    public String getSpillFile() {
        return this.spillFile;
    }

    @Override
    public String makeDebugString() {
        return String.format("Start reading spilled partition %d (prev %d) from cycle %d.", this.getOriginPartition(), this.getPrevOriginPartition(), this.getCycle());
    }
}

