/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.drill.common.exceptions.RetryAfterSpillException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.cache.VectorSerializer;
import org.apache.drill.exec.compile.sig.RuntimeOverridden;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BaseAllocator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.config.HashAggregate;
import org.apache.drill.exec.physical.impl.aggregate.HashAggBatch;
import org.apache.drill.exec.physical.impl.aggregate.HashAggSpilledPartition;
import org.apache.drill.exec.physical.impl.aggregate.HashAggUpdater;
import org.apache.drill.exec.physical.impl.aggregate.HashAggregator;
import org.apache.drill.exec.physical.impl.aggregate.SpilledRecordBatch;
import org.apache.drill.exec.physical.impl.common.ChainedHashTable;
import org.apache.drill.exec.physical.impl.common.CodeGenMemberInjector;
import org.apache.drill.exec.physical.impl.common.HashTable;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.physical.impl.common.HashTableStats;
import org.apache.drill.exec.physical.impl.common.IndexPointer;
import org.apache.drill.exec.physical.impl.common.SpilledState;
import org.apache.drill.exec.physical.impl.spill.SpillSet;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ObjectVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HashAggTemplate
implements HashAggregator {
    protected static final Logger logger = LoggerFactory.getLogger(HashAggTemplate.class);
    private static final int VARIABLE_MAX_WIDTH_VALUE_SIZE = 50;
    private static final int VARIABLE_MIN_WIDTH_VALUE_SIZE = 8;
    private static final boolean EXTRA_DEBUG_1 = false;
    private static final boolean EXTRA_DEBUG_2 = false;
    private static final boolean EXTRA_DEBUG_SPILL = false;
    private int nextPartitionToReturn;
    private int rowsInPartition;
    private int rowsNotSpilled;
    private int rowsSpilled;
    private int rowsSpilledReturned;
    private int rowsReturnedEarly;
    private AggPrelBase.OperatorPhase phase;
    private boolean canSpill = true;
    private ChainedHashTable baseHashTable;
    private boolean earlyOutput;
    private int earlyPartition;
    private boolean retrySameIndex;
    private boolean useMemoryPrediction;
    private long estMaxBatchSize;
    private long estRowWidth;
    private long estValuesRowWidth;
    private long estOutputRowWidth;
    private long estValuesBatchSize;
    private long estOutgoingAllocSize;
    private long reserveValueBatchMemory;
    private long reserveOutgoingMemory;
    private int maxColumnWidth = 8;
    private long minBatchesPerPartition;
    private long plannedBatches;
    private int underlyingIndex;
    private int currentIndex;
    private RecordBatch.IterOutcome outcome;
    private int numGroupedRecords;
    private int currentBatchRecordCount;
    private int lastBatchOutputCount;
    private RecordBatch incoming;
    private BatchSchema schema;
    private HashAggBatch outgoing;
    private VectorContainer outContainer;
    protected FragmentContext context;
    protected ClassGenerator<?> cg;
    private OperatorContext oContext;
    private BufferAllocator allocator;
    private HashTable[] htables;
    private ArrayList<BatchHolder>[] batchHolders;
    private int[] outBatchIndex;
    private HashAggUpdater updater;
    private final SpilledState<HashAggSpilledPartition> spilledState = new SpilledState();
    private SpillSet spillSet;
    SpilledRecordBatch newIncoming;
    private VectorSerializer.Writer[] writers;
    private int[] spilledBatchesCount;
    private String[] spillFiles;
    private int originalPartition = -1;
    private IndexPointer htIdxHolder;
    private int numGroupByOutFields;
    private TypedFieldId[] groupByOutFieldIds;
    private MaterializedField[] materializedValueFields;
    private boolean allFlushed;
    private boolean buildComplete;
    private boolean handlingSpills;
    private boolean handleEmit;
    private OperatorStats stats;
    private final HashTableStats htStats = new HashTableStats();

    @Override
    public void setup(HashAggregate hashAggrConfig, HashTableConfig htConfig, FragmentContext context, OperatorContext oContext, RecordBatch incoming, HashAggBatch outgoing, LogicalExpression[] valueExprs, List<TypedFieldId> valueFieldIds, ClassGenerator<?> cg, TypedFieldId[] groupByOutFieldIds, VectorContainer outContainer, int extraRowBytes) {
        if (valueExprs == null || valueFieldIds == null) {
            throw new IllegalArgumentException("Invalid aggr value exprs or workspace variables.");
        }
        if (valueFieldIds.size() < valueExprs.length) {
            throw new IllegalArgumentException("Wrong number of workspace variables.");
        }
        this.context = context;
        this.stats = oContext.getStats();
        this.allocator = oContext.getAllocator();
        this.updater = new HashAggUpdater(this.allocator);
        this.oContext = oContext;
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.cg = cg;
        this.outContainer = outContainer;
        this.useMemoryPrediction = context.getOptions().getOption(ExecConstants.HASHAGG_USE_MEMORY_PREDICTION_VALIDATOR);
        this.phase = hashAggrConfig.getAggPhase();
        this.canSpill = this.phase.hasTwo();
        this.minBatchesPerPartition = context.getOptions().getOption(ExecConstants.HASHAGG_MIN_BATCHES_PER_PARTITION_VALIDATOR);
        long memoryLimit = this.allocator.getLimit();
        long configLimit = context.getOptions().getOption(ExecConstants.HASHAGG_MAX_MEMORY_VALIDATOR);
        if (configLimit > 0L) {
            logger.warn("Memory limit was changed to {}", (Object)configLimit);
            memoryLimit = Math.min(memoryLimit, configLimit);
            this.allocator.setLimit(memoryLimit);
        }
        if (hashAggrConfig.getGroupByExprs().size() == 0) {
            throw new IllegalArgumentException("Currently, hash aggregation is only applicable if there are group-by expressions.");
        }
        this.htIdxHolder = new IndexPointer();
        this.materializedValueFields = new MaterializedField[valueFieldIds.size()];
        if (valueFieldIds.size() > 0) {
            int i = 0;
            FieldReference ref = new FieldReference("dummy", ExpressionPosition.UNKNOWN, valueFieldIds.get(0).getIntermediateType());
            for (TypedFieldId id : valueFieldIds) {
                this.materializedValueFields[i++] = MaterializedField.create(ref.getAsNamePart().getName(), id.getIntermediateType());
            }
        }
        this.spillSet = new SpillSet(context, hashAggrConfig);
        this.baseHashTable = new ChainedHashTable(htConfig, context, this.allocator, incoming, null, outgoing);
        this.groupByOutFieldIds = groupByOutFieldIds;
        this.numGroupByOutFields = groupByOutFieldIds.length;
        this.estRowWidth = extraRowBytes;
        this.estValuesRowWidth = extraRowBytes;
        try {
            this.doSetup(incoming);
        }
        catch (SchemaChangeException e) {
            throw HashAggBatch.schemaChangeException(e, "Hash Aggregate", logger);
        }
    }

    private void delayedSetup() {
        boolean fallbackEnabled = this.context.getOptions().getOption((String)"drill.exec.hashagg.fallback.enabled").bool_val;
        int numPartitions = (int)this.context.getOptions().getOption(ExecConstants.HASHAGG_NUM_PARTITIONS_VALIDATOR);
        if (numPartitions == 1 && this.phase.is2nd()) {
            this.canSpill = false;
            logger.warn("Spilling is disabled due to configuration setting of num_partitions to 1");
        }
        numPartitions = BaseAllocator.nextPowerOfTwo(numPartitions);
        if (this.schema == null) {
            this.estMaxBatchSize = 0L;
            this.estOutgoingAllocSize = 0L;
            this.estValuesBatchSize = 0L;
        } else {
            this.updateEstMaxBatchSize(this.incoming);
        }
        this.reserveValueBatchMemory = this.reserveOutgoingMemory = this.estValuesBatchSize;
        long newMemoryLimit = this.allocator.getLimit() - this.reserveValueBatchMemory - this.reserveOutgoingMemory;
        long memAvail = newMemoryLimit - this.allocator.getAllocatedMemory();
        if (memAvail <= 0L) {
            throw new OutOfMemoryException("Too little memory available");
        }
        this.allocator.setLimit(newMemoryLimit);
        if (!this.canSpill) {
            numPartitions = 1;
        } else {
            while ((long)numPartitions * (this.estMaxBatchSize * this.minBatchesPerPartition + 0x200000L) > memAvail) {
                if ((numPartitions /= 2) >= 2) continue;
                if (!this.phase.is2nd()) break;
                this.canSpill = false;
                if (fallbackEnabled) {
                    logger.warn("Spilling is disabled - not enough memory available for internal partitioning. Falling back to use unbounded memory");
                    break;
                }
                throw UserException.resourceError().message(String.format("Not enough memory for internal partitioning and fallback mechanism for HashAgg to use unbounded memory is disabled. Either enable fallback config %s using Alter session/system command or increase memory limit for Drillbit", "drill.exec.hashagg.fallback.enabled"), new Object[0]).build(logger);
            }
        }
        logger.debug("{} phase. Number of partitions chosen: {}. {} spill", new Object[]{this.phase.getName(), numPartitions, this.canSpill ? "Can" : "Cannot"});
        if (numPartitions == 1 && !this.canSpill) {
            this.allocator.setLimit(AbstractBase.MAX_ALLOCATION);
        }
        this.spilledState.initialize(numPartitions);
        this.htables = new HashTable[numPartitions];
        this.batchHolders = new ArrayList[numPartitions];
        this.outBatchIndex = new int[numPartitions];
        this.writers = new VectorSerializer.Writer[numPartitions];
        this.spilledBatchesCount = new int[numPartitions];
        this.spillFiles = new String[numPartitions];
        this.plannedBatches = numPartitions;
        for (int i = 0; i < numPartitions; ++i) {
            try {
                this.htables[i] = this.baseHashTable.createAndSetupHashTable(this.groupByOutFieldIds);
            }
            catch (ClassTransformationException e) {
                throw UserException.unsupportedError(e).message("Code generation error - likely an error in the code.", new Object[0]).build(logger);
            }
            catch (IOException e) {
                throw UserException.resourceError(e).message("IO Error while creating a hash table.", new Object[0]).build(logger);
            }
            catch (SchemaChangeException sce) {
                throw new IllegalStateException("Unexpected Schema Change while creating a hash table", sce);
            }
            this.batchHolders[i] = new ArrayList();
        }
        try {
            this.htables[0].updateBatches();
        }
        catch (SchemaChangeException sc) {
            throw new UnsupportedOperationException(sc);
        }
    }

    @Override
    public RecordBatch getNewIncoming() {
        return this.newIncoming;
    }

    private void initializeSetup(RecordBatch newIncoming) throws SchemaChangeException, IOException {
        this.baseHashTable.updateIncoming(newIncoming, null);
        this.incoming = newIncoming;
        this.currentBatchRecordCount = newIncoming.getRecordCount();
        this.nextPartitionToReturn = 0;
        for (int i = 0; i < this.spilledState.getNumPartitions(); ++i) {
            this.htables[i].updateIncoming(newIncoming.getContainer(), null);
            this.htables[i].reset();
            if (this.batchHolders[i] != null) {
                for (BatchHolder bh : this.batchHolders[i]) {
                    bh.clear();
                }
                this.batchHolders[i].clear();
                this.batchHolders[i] = new ArrayList();
            }
            this.outBatchIndex[i] = 0;
            this.writers[i] = null;
            this.spilledBatchesCount[i] = 0;
            this.spillFiles[i] = null;
        }
    }

    private void updateEstMaxBatchSize(RecordBatch incoming) {
        if (this.estMaxBatchSize > 0L) {
            return;
        }
        RecordBatchSizer sizer = this.outgoing.getRecordBatchMemoryManager().getRecordBatchSizer();
        logger.trace("Incoming sizer: {}", (Object)sizer);
        long estInputRowWidth = sizer.rowCount() == 0 ? (long)sizer.getStdRowWidth() : (long)sizer.getNetRowWidthCap50();
        this.maxColumnWidth = Math.max(sizer.getMaxAvgColumnSize(), 8);
        this.maxColumnWidth = Math.min(this.maxColumnWidth, 50);
        Iterator<VectorWrapper<?>> outgoingIter = this.outContainer.iterator();
        int fieldId = 0;
        while (outgoingIter.hasNext()) {
            Object vv = outgoingIter.next().getValueVector();
            MaterializedField mr = vv.getField();
            int fieldSize = vv instanceof VariableWidthVector ? this.maxColumnWidth : TypeHelper.getSize(mr.getType());
            this.estRowWidth += (long)fieldSize;
            this.estOutputRowWidth += (long)fieldSize;
            if (fieldId < this.numGroupByOutFields) {
                ++fieldId;
                continue;
            }
            this.estValuesRowWidth += (long)fieldSize;
        }
        long estimatedMaxWidth = Math.max(this.estRowWidth, estInputRowWidth);
        this.estMaxBatchSize = estimatedMaxWidth * 65536L;
        int configuredBatchSize = this.outgoing.getRecordBatchMemoryManager().getOutputBatchSize();
        this.estMaxBatchSize = Math.min(this.estMaxBatchSize, (long)configuredBatchSize);
        long rowsInBatch = this.estMaxBatchSize / estimatedMaxWidth;
        this.estOutgoingAllocSize = this.estValuesBatchSize = Math.max(this.estValuesRowWidth, 1L) * rowsInBatch;
        logger.trace("{} phase. Estimated internal row width: {} Values row width: {} batch size: {}  memory limit: {}  max column width: {}", new Object[]{this.phase.getName(), this.estRowWidth, this.estValuesRowWidth, this.estMaxBatchSize, this.allocator.getLimit(), this.maxColumnWidth});
        if (this.estMaxBatchSize > this.allocator.getLimit()) {
            logger.warn("HashAggregate: Estimated max batch size {} is larger than the memory limit {}", (Object)this.estMaxBatchSize, (Object)this.allocator.getLimit());
        }
    }

    @Override
    public HashAggregator.AggOutcome doWork() {
        block12: while (true) {
            if (this.schema == null && this.incoming.getRecordCount() > 0) {
                this.schema = this.incoming.getSchema();
                this.currentBatchRecordCount = this.incoming.getRecordCount();
                this.delayedSetup();
                this.outgoing.getRecordBatchMemoryManager().update(this.incoming);
            }
            while (this.underlyingIndex < this.currentBatchRecordCount) {
                this.checkGroupAndAggrValues(this.currentIndex);
                if (this.retrySameIndex) {
                    this.retrySameIndex = false;
                } else {
                    this.incIndex();
                }
                if (!this.earlyOutput) continue;
                this.outputCurrentBatch();
                return HashAggregator.AggOutcome.RETURN_OUTCOME;
            }
            VectorAccessibleUtilities.clear(this.incoming);
            if (this.handleEmit) {
                this.outcome = RecordBatch.IterOutcome.NONE;
            } else {
                long memAllocBeforeNext = this.allocator.getAllocatedMemory();
                this.outcome = this.handlingSpills ? this.incoming.next() : this.outgoing.next(0, this.incoming);
                long memAllocAfterNext = this.allocator.getAllocatedMemory();
                long incomingBatchSize = memAllocAfterNext - memAllocBeforeNext;
                if (this.estMaxBatchSize < incomingBatchSize) {
                    logger.debug("Found a bigger next {} batch: {} , prior estimate was: {}, mem allocated {}", new Object[]{this.handlingSpills ? "spill" : "incoming", incomingBatchSize, this.estMaxBatchSize, memAllocAfterNext});
                    this.estMaxBatchSize = incomingBatchSize;
                }
            }
            switch (this.outcome) {
                case NOT_YET: {
                    return HashAggregator.AggOutcome.RETURN_OUTCOME;
                }
                case OK_NEW_SCHEMA: {
                    this.cleanup();
                    return HashAggregator.AggOutcome.UPDATE_AGGREGATOR;
                }
                case EMIT: {
                    this.handleEmit = true;
                }
                case OK: {
                    this.outgoing.getRecordBatchMemoryManager().update(this.incoming);
                    this.currentBatchRecordCount = this.incoming.getRecordCount();
                    this.resetIndex();
                    continue block12;
                }
                case NONE: {
                    this.resetIndex();
                    this.buildComplete = true;
                    if (this.handleEmit) {
                        this.buildComplete = false;
                        this.currentBatchRecordCount = 0;
                    }
                    this.updateStats(this.htables);
                    HashAggregator.AggIterOutcome aggOutcome = this.outputCurrentBatch();
                    switch (aggOutcome) {
                        case AGG_RESTART: {
                            return HashAggregator.AggOutcome.CALL_WORK_AGAIN;
                        }
                        case AGG_EMIT: {
                            break;
                        }
                        case AGG_NONE: {
                            break;
                        }
                        default: {
                            this.outcome = RecordBatch.IterOutcome.OK;
                        }
                    }
                    return HashAggregator.AggOutcome.RETURN_OUTCOME;
                }
            }
            break;
        }
        return HashAggregator.AggOutcome.CLEANUP_AND_RETURN;
    }

    private void useReservedValuesMemory() {
        long reservedMemory = this.reserveValueBatchMemory;
        if (reservedMemory > 0L) {
            this.allocator.setLimit(this.allocator.getLimit() + reservedMemory);
        }
        this.reserveValueBatchMemory = 0L;
    }

    private void useReservedOutgoingMemory() {
        long reservedMemory = this.reserveOutgoingMemory;
        if (reservedMemory > 0L) {
            this.allocator.setLimit(this.allocator.getLimit() + reservedMemory);
        }
        this.reserveOutgoingMemory = 0L;
    }

    private void restoreReservedMemory() {
        long memAvail;
        if (0L == this.reserveOutgoingMemory && (memAvail = this.allocator.getLimit() - this.allocator.getAllocatedMemory()) > this.estOutgoingAllocSize) {
            this.allocator.setLimit(this.allocator.getLimit() - this.estOutgoingAllocSize);
            this.reserveOutgoingMemory = this.estOutgoingAllocSize;
        }
        if (0L == this.reserveValueBatchMemory && (memAvail = this.allocator.getLimit() - this.allocator.getAllocatedMemory()) > this.estValuesBatchSize) {
            this.allocator.setLimit(this.allocator.getLimit() - this.estValuesBatchSize);
            this.reserveValueBatchMemory = this.estValuesBatchSize;
        }
    }

    private void allocateOutgoing(int records) {
        Iterator<VectorWrapper<?>> outgoingIter = this.outContainer.iterator();
        for (int i = 0; i < this.numGroupByOutFields; ++i) {
            outgoingIter.next();
        }
        this.useReservedOutgoingMemory();
        long allocatedBefore = this.allocator.getAllocatedMemory();
        while (outgoingIter.hasNext()) {
            Object vv = outgoingIter.next().getValueVector();
            TypeProtos.MajorType majorType = vv.getField().getType();
            if (Types.isComplex(majorType) || Types.isUnion(majorType) || Types.isRepeated(majorType)) continue;
            AllocationHelper.allocatePrecomputedChildCount(vv, records, this.maxColumnWidth, 0);
        }
        long memAdded = this.allocator.getAllocatedMemory() - allocatedBefore;
        if (memAdded > this.estOutgoingAllocSize) {
            logger.trace("Output values allocated {} but the estimate was only {}. Adjusting ...", (Object)memAdded, (Object)this.estOutgoingAllocSize);
            this.estOutgoingAllocSize = memAdded;
        }
        this.outContainer.setRecordCount(records);
        this.restoreReservedMemory();
    }

    @Override
    public RecordBatch.IterOutcome getOutcome() {
        return this.outcome;
    }

    @Override
    public int getOutputCount() {
        return this.lastBatchOutputCount;
    }

    @Override
    public void adjustOutputCount(int outputBatchSize, int oldRowWidth, int newRowWidth) {
        for (int i = 0; i < this.spilledState.getNumPartitions(); ++i) {
            if (this.batchHolders[i] == null || this.batchHolders[i].size() == 0) continue;
            BatchHolder bh = this.batchHolders[i].get(this.batchHolders[i].size() - 1);
            int remainingRows = RecordBatchSizer.safeDivide(Math.max(outputBatchSize - bh.getCurrentRowCount() * oldRowWidth, 0), newRowWidth);
            int newRowCount = Math.min(bh.getTargetBatchRowCount(), bh.getCurrentRowCount() + remainingRows);
            bh.setTargetBatchRowCount(newRowCount);
            this.htables[i].setTargetBatchRowCount(newRowCount);
        }
    }

    @Override
    public void cleanup() {
        if (this.schema == null) {
            return;
        }
        if (this.phase.is2nd() && this.spillSet.getWriteBytes() > 0L) {
            this.stats.setLongStat(Metric.SPILL_MB, (int)Math.round((double)this.spillSet.getWriteBytes() / 1024.0 / 1024.0));
        }
        for (int i = 0; i < this.spilledState.getNumPartitions(); ++i) {
            if (this.htables[i] != null) {
                this.htables[i].clear();
                this.htables[i] = null;
            }
            if (this.batchHolders[i] != null) {
                for (BatchHolder bh : this.batchHolders[i]) {
                    bh.clear();
                }
                this.batchHolders[i].clear();
                this.batchHolders[i] = null;
            }
            if (this.writers[i] == null || this.spillFiles[i] == null) continue;
            try {
                this.spillSet.close(this.writers[i]);
                this.writers[i] = null;
                this.spillSet.delete(this.spillFiles[i]);
                this.spillFiles[i] = null;
                continue;
            }
            catch (IOException e) {
                logger.warn("Cleanup: Failed to delete spill file {}", (Object)this.spillFiles[i], (Object)e);
            }
        }
        while (!this.spilledState.isEmpty()) {
            HashAggSpilledPartition sp = this.spilledState.getNextSpilledPartition();
            try {
                this.spillSet.delete(sp.getSpillFile());
            }
            catch (IOException e) {
                logger.warn("Cleanup: Failed to delete spill file {}", (Object)sp.getSpillFile());
            }
        }
        if (this.newIncoming != null) {
            this.newIncoming.close();
        }
        this.spillSet.close();
        this.htIdxHolder = null;
        this.materializedValueFields = null;
    }

    private void reinitPartition(int part) {
        assert (this.htables[part] != null);
        this.htables[part].reset();
        if (this.batchHolders[part] != null) {
            for (BatchHolder bh : this.batchHolders[part]) {
                bh.clear();
            }
            this.batchHolders[part].clear();
        }
        this.batchHolders[part] = new ArrayList();
        this.outBatchIndex[part] = 0;
        this.restoreReservedMemory();
    }

    private final void incIndex() {
        ++this.underlyingIndex;
        if (this.underlyingIndex >= this.currentBatchRecordCount) {
            this.currentIndex = Integer.MAX_VALUE;
            return;
        }
        try {
            this.currentIndex = this.getVectorIndex(this.underlyingIndex);
        }
        catch (SchemaChangeException sc) {
            throw new UnsupportedOperationException(sc);
        }
    }

    private final void resetIndex() {
        this.underlyingIndex = -1;
        this.incIndex();
    }

    private boolean isSpilled(int part) {
        return this.writers[part] != null;
    }

    private int chooseAPartitionToFlush(int currPart, boolean tryAvoidCurr) {
        if (this.phase.is1st() && !tryAvoidCurr) {
            return currPart;
        }
        int currPartSize = this.batchHolders[currPart].size();
        if (currPartSize == 1) {
            currPartSize = -1;
        }
        int maxSizeSpilled = -1;
        int indexMaxSpilled = -1;
        for (int isp = 0; isp < this.spilledState.getNumPartitions(); ++isp) {
            if (!this.isSpilled(isp) || maxSizeSpilled >= this.batchHolders[isp].size()) continue;
            maxSizeSpilled = this.batchHolders[isp].size();
            indexMaxSpilled = isp;
        }
        if (!tryAvoidCurr && this.isSpilled(currPart) && currPartSize + 1 >= maxSizeSpilled) {
            maxSizeSpilled = currPartSize;
            indexMaxSpilled = currPart;
        }
        int maxSize = -1;
        int indexMax = -1;
        if (indexMaxSpilled > -1 && maxSizeSpilled > 1) {
            indexMax = indexMaxSpilled;
            maxSize = 4 * maxSizeSpilled;
        }
        for (int insp = 0; insp < this.spilledState.getNumPartitions(); ++insp) {
            if (this.isSpilled(insp) || maxSize >= this.batchHolders[insp].size()) continue;
            indexMax = insp;
            maxSize = this.batchHolders[insp].size();
        }
        if (!tryAvoidCurr && !this.isSpilled(currPart) && currPartSize + 1 >= maxSize) {
            return currPart;
        }
        if (maxSize <= 1) {
            return -1;
        }
        return indexMax;
    }

    private void spillAPartition(int part) {
        ArrayList<BatchHolder> currPartition = this.batchHolders[part];
        this.rowsInPartition = 0;
        if (currPartition.size() == 0) {
            return;
        }
        if (!this.isSpilled(part)) {
            this.spillFiles[part] = this.spillSet.getNextSpillFile(this.spilledState.getCycle() > 0 ? Integer.toString(this.spilledState.getCycle()) : null);
            try {
                this.writers[part] = this.spillSet.writer(this.spillFiles[part]);
            }
            catch (IOException ioe) {
                throw UserException.resourceError(ioe).message("Hash Aggregation failed to open spill file: " + this.spillFiles[part], new Object[0]).build(logger);
            }
        }
        for (int currOutBatchIndex = 0; currOutBatchIndex < currPartition.size(); ++currOutBatchIndex) {
            int numOutputRecords = currPartition.get(currOutBatchIndex).getNumPendingOutput();
            this.rowsInPartition += numOutputRecords;
            this.rowsSpilled += numOutputRecords;
            this.allocateOutgoing(numOutputRecords);
            currPartition.get(currOutBatchIndex).outputValues();
            this.htables[part].outputKeys(currOutBatchIndex, this.outContainer, numOutputRecords);
            this.outContainer.setValueCount(numOutputRecords);
            WritableBatch batch = WritableBatch.getBatchNoHVWrap(numOutputRecords, this.outContainer, false);
            try {
                this.writers[part].write(batch, null);
            }
            catch (IOException ioe) {
                throw UserException.dataWriteError(ioe).message("Hash Aggregation failed to write to output file: " + this.spillFiles[part], new Object[0]).build(logger);
            }
            finally {
                batch.clear();
            }
            this.outContainer.zeroVectors();
            logger.trace("HASH AGG: Took {} us to spill {} records", (Object)this.writers[part].time(TimeUnit.MICROSECONDS), (Object)numOutputRecords);
        }
        int n = part;
        this.spilledBatchesCount[n] = this.spilledBatchesCount[n] + currPartition.size();
        logger.trace("HASH AGG: Spilled {} rows from {} batches of partition {}", new Object[]{this.rowsInPartition, currPartition.size(), part});
    }

    private void addBatchHolder(int part, int batchRowCount) {
        BatchHolder bh = this.newBatchHolder(batchRowCount);
        this.batchHolders[part].add(bh);
        bh.setup();
    }

    protected BatchHolder newBatchHolder(int batchRowCount) {
        return this.injectMembers(new BatchHolder(batchRowCount));
    }

    protected BatchHolder injectMembers(BatchHolder batchHolder) {
        CodeGenMemberInjector.injectMembers(this.cg, batchHolder, this.context);
        return batchHolder;
    }

    @Override
    public HashAggregator.AggIterOutcome outputCurrentBatch() {
        if (this.handleEmit && (this.batchHolders == null || this.batchHolders[0].size() == 0)) {
            this.lastBatchOutputCount = 0;
            this.allocateOutgoing(0);
            this.outgoing.getContainer().setValueCount(0);
            this.outcome = RecordBatch.IterOutcome.EMIT;
            this.handleEmit = false;
            if (this.outBatchIndex != null) {
                this.outBatchIndex[0] = 0;
            }
            return HashAggregator.AggIterOutcome.AGG_EMIT;
        }
        if (this.schema == null) {
            logger.trace("Incoming was empty; output is an empty batch.");
            this.outcome = RecordBatch.IterOutcome.NONE;
            this.allFlushed = true;
            return HashAggregator.AggIterOutcome.AGG_NONE;
        }
        ArrayList<BatchHolder> currPartition = this.batchHolders[this.earlyPartition];
        int currOutBatchIndex = this.outBatchIndex[this.earlyPartition];
        int partitionToReturn = this.earlyPartition;
        if (!this.earlyOutput) {
            HashAggSpilledPartition sp;
            while (this.nextPartitionToReturn < this.spilledState.getNumPartitions()) {
                if (this.isSpilled(this.nextPartitionToReturn)) {
                    this.spillAPartition(this.nextPartitionToReturn);
                    sp = new HashAggSpilledPartition(this.spilledState.getCycle(), this.nextPartitionToReturn, this.originalPartition, this.spilledBatchesCount[this.nextPartitionToReturn], this.spillFiles[this.nextPartitionToReturn]);
                    this.spilledState.addPartition(sp);
                    this.reinitPartition(this.nextPartitionToReturn);
                    try {
                        this.spillSet.close(this.writers[this.nextPartitionToReturn]);
                    }
                    catch (IOException ioe) {
                        throw UserException.resourceError(ioe).message("IO Error while closing output stream", new Object[0]).build(logger);
                    }
                    this.writers[this.nextPartitionToReturn] = null;
                } else {
                    currOutBatchIndex = this.outBatchIndex[this.nextPartitionToReturn];
                    currPartition = this.batchHolders[this.nextPartitionToReturn];
                    if (currOutBatchIndex < currPartition.size() && 0 != currPartition.get(currOutBatchIndex).getNumPendingOutput()) break;
                }
                ++this.nextPartitionToReturn;
            }
            if (this.nextPartitionToReturn >= this.spilledState.getNumPartitions()) {
                if (this.spilledState.isEmpty()) {
                    this.allFlushed = true;
                    this.outcome = RecordBatch.IterOutcome.NONE;
                    if (this.phase.is2nd() && this.spillSet.getWriteBytes() > 0L) {
                        this.stats.setLongStat(Metric.SPILL_MB, (int)Math.round((double)this.spillSet.getWriteBytes() / 1024.0 / 1024.0));
                    }
                    return HashAggregator.AggIterOutcome.AGG_NONE;
                }
                this.buildComplete = false;
                this.handlingSpills = true;
                sp = this.spilledState.getNextSpilledPartition();
                this.newIncoming = new SpilledRecordBatch(sp.getSpillFile(), sp.getSpilledBatches(), this.context, this.schema, this.oContext, this.spillSet);
                this.originalPartition = sp.getOriginPartition();
                logger.trace("Reading back spilled original partition {} as an incoming", (Object)this.originalPartition);
                try {
                    this.initializeSetup(this.newIncoming);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.spilledState.updateCycle(this.stats, sp, this.updater);
                return HashAggregator.AggIterOutcome.AGG_RESTART;
            }
            partitionToReturn = this.nextPartitionToReturn;
        }
        int numPendingOutput = currPartition.get(currOutBatchIndex).getNumPendingOutput();
        this.rowsInPartition += numPendingOutput;
        if (!this.handlingSpills) {
            this.rowsNotSpilled += numPendingOutput;
        } else {
            this.rowsSpilledReturned += numPendingOutput;
        }
        if (this.earlyOutput) {
            this.rowsReturnedEarly += numPendingOutput;
        }
        this.allocateOutgoing(numPendingOutput);
        currPartition.get(currOutBatchIndex).outputValues();
        int numOutputRecords = numPendingOutput;
        this.htables[partitionToReturn].outputKeys(currOutBatchIndex, this.outContainer, numPendingOutput);
        this.outgoing.getContainer().setValueCount(numOutputRecords);
        this.outgoing.getRecordBatchMemoryManager().updateOutgoingStats(numOutputRecords);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this.outgoing, this.outgoing.getRecordBatchStatsContext());
        this.outcome = RecordBatch.IterOutcome.OK;
        this.lastBatchOutputCount = numOutputRecords;
        int n = partitionToReturn;
        this.outBatchIndex[n] = this.outBatchIndex[n] + 1;
        if (this.outBatchIndex[partitionToReturn] == currPartition.size()) {
            this.rowsInPartition = 0;
            this.reinitPartition(partitionToReturn);
            if (this.earlyOutput) {
                this.outBatchIndex[this.earlyPartition] = 0;
                this.earlyOutput = false;
            } else {
                if (this.handleEmit) {
                    this.outcome = RecordBatch.IterOutcome.EMIT;
                    this.handleEmit = false;
                    this.outBatchIndex[partitionToReturn] = 0;
                    return HashAggregator.AggIterOutcome.AGG_EMIT;
                }
                if (partitionToReturn + 1 == this.spilledState.getNumPartitions() && this.spilledState.isEmpty()) {
                    this.allFlushed = true;
                    logger.trace("HashAggregate: All batches flushed.");
                    this.cleanup();
                }
            }
        }
        return HashAggregator.AggIterOutcome.AGG_OK;
    }

    @Override
    public boolean allFlushed() {
        return this.allFlushed;
    }

    @Override
    public boolean buildComplete() {
        return this.buildComplete;
    }

    @Override
    public boolean handlingEmit() {
        return this.handleEmit;
    }

    @Override
    public boolean earlyOutput() {
        return this.earlyOutput;
    }

    public int numGroupedRecords() {
        return this.numGroupedRecords;
    }

    private String getOOMErrorMsg(String prefix) {
        String errmsg;
        if (!this.phase.hasTwo()) {
            errmsg = "Single Phase Hash Aggregate operator can not spill.";
        } else if (!this.canSpill) {
            errmsg = "Too little memory available to operator to facilitate spilling.";
        } else {
            errmsg = prefix + " OOM at " + this.phase.getName() + " Phase. Partitions: " + this.spilledState.getNumPartitions() + ". Estimated batch size: " + this.estMaxBatchSize + ". values size: " + this.estValuesBatchSize + ". Output alloc size: " + this.estOutgoingAllocSize;
            if (this.plannedBatches > 0L) {
                errmsg = errmsg + ". Planned batches: " + this.plannedBatches;
            }
            if (this.rowsSpilled > 0) {
                errmsg = errmsg + ". Rows spilled so far: " + this.rowsSpilled;
            }
        }
        errmsg = errmsg + " Memory limit: " + this.allocator.getLimit() + " so far allocated: " + this.allocator.getAllocatedMemory() + ". ";
        return errmsg;
    }

    private int getTargetBatchCount() {
        return this.outgoing.getOutputRowCount();
    }

    /*
     * Unable to fully structure code
     */
    private void checkGroupAndAggrValues(int incomingRowIdx) {
        if (!HashAggTemplate.$assertionsDisabled && incomingRowIdx < 0) {
            throw new AssertionError();
        }
        if (!HashAggTemplate.$assertionsDisabled && this.earlyOutput) {
            throw new AssertionError();
        }
        try {
            hashCode = this.htables[0].getBuildHashCode(incomingRowIdx);
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException("Unexpected schema change", e);
        }
        for (i = 0; i < this.spilledState.getCycle(); ++i) {
            hashCode >>>= this.spilledState.getBitsInMask();
        }
        currentPartition = hashCode & this.spilledState.getPartitionMask();
        hashCode >>>= this.spilledState.getBitsInMask();
        putStatus = null;
        allocatedBeforeHTput = this.allocator.getAllocatedMemory();
        v0 = tryingTo = this.phase.is1st() != false ? "early return" : "spill";
        if (this.reserveValueBatchMemory == 0L && this.canSpill) {
            HashAggTemplate.logger.trace("Reserved memory runs short, trying to {} a partition and retry Hash Table put() again.", (Object)tryingTo);
            this.doSpill(currentPartition);
            this.retrySameIndex = true;
            return;
        }
        try {
            putStatus = this.htables[currentPartition].put(incomingRowIdx, this.htIdxHolder, hashCode, this.getTargetBatchCount());
        }
        catch (RetryAfterSpillException re) {
            if (!this.canSpill) {
                throw new OutOfMemoryException(this.getOOMErrorMsg("Can not spill"));
            }
            HashAggTemplate.logger.trace("HT put failed with an OOM, trying to {} a partition and retry Hash Table put() again.", (Object)tryingTo);
            memDiff = this.allocator.getAllocatedMemory() - allocatedBeforeHTput;
            if (memDiff > 0L) {
                HashAggTemplate.logger.warn("Leak: HashTable put() OOM left behind {} bytes allocated", (Object)memDiff);
            }
            this.doSpill(currentPartition);
            this.retrySameIndex = true;
            return;
        }
        catch (OutOfMemoryException exc) {
            throw new OutOfMemoryException(this.getOOMErrorMsg("HT was: " + allocatedBeforeHTput), exc);
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException("Unexpected schema change", e);
        }
        allocatedBeforeAggCol = this.allocator.getAllocatedMemory();
        v1 = needToCheckIfSpillIsNeeded = allocatedBeforeAggCol > allocatedBeforeHTput;
        if (putStatus == HashTable.PutStatus.NEW_BATCH_ADDED) {
            try {
                this.useReservedValuesMemory();
                this.addBatchHolder(currentPartition, this.getTargetBatchCount());
                this.restoreReservedMemory();
                v2 = needToCheckIfSpillIsNeeded = 0L == this.reserveValueBatchMemory;
                if (this.plannedBatches > 0L) {
                    --this.plannedBatches;
                }
                totalAddedMem = this.allocator.getAllocatedMemory() - allocatedBeforeHTput;
                aggValuesAddedMem = this.allocator.getAllocatedMemory() - allocatedBeforeAggCol;
                HashAggTemplate.logger.trace("MEMORY CHECK AGG: allocated now {}, added {}, total (with HT) added {}", new Object[]{this.allocator.getAllocatedMemory(), aggValuesAddedMem, totalAddedMem});
                if (totalAddedMem > this.estMaxBatchSize) {
                    HashAggTemplate.logger.trace("Adjusting Batch size estimate from {} to {}", (Object)this.estMaxBatchSize, (Object)totalAddedMem);
                    this.estMaxBatchSize = totalAddedMem;
                    needToCheckIfSpillIsNeeded = true;
                }
                if (aggValuesAddedMem <= this.estValuesBatchSize) ** GOTO lbl67
                HashAggTemplate.logger.trace("Adjusting Values Batch size from {} to {}", (Object)this.estValuesBatchSize, (Object)aggValuesAddedMem);
                this.estValuesBatchSize = aggValuesAddedMem;
                needToCheckIfSpillIsNeeded = true;
            }
            catch (OutOfMemoryException exc) {
                throw new OutOfMemoryException(this.getOOMErrorMsg("AGGR"), exc);
            }
        } else if (putStatus == HashTable.PutStatus.KEY_ADDED_LAST) {
            ++this.plannedBatches;
            needToCheckIfSpillIsNeeded = true;
        }
lbl67:
        // 5 sources

        currentIdx = this.htIdxHolder.value;
        bh = this.batchHolders[currentPartition].get(currentIdx >>> 16 & 65535);
        idxWithinBatch = currentIdx & 65535;
        if (BatchHolder.access$900(bh, incomingRowIdx, idxWithinBatch)) {
            ++this.numGroupedRecords;
        }
        if (needToCheckIfSpillIsNeeded && this.canSpill && this.useMemoryPrediction) {
            this.spillIfNeeded(currentPartition);
        }
    }

    private void spillIfNeeded(int currentPartition) {
        this.spillIfNeeded(currentPartition, false);
    }

    private void doSpill(int currentPartition) {
        this.spillIfNeeded(currentPartition, true);
    }

    private void spillIfNeeded(int currentPartition, boolean forceSpill) {
        long maxMemoryNeeded = 0L;
        if (!forceSpill) {
            maxMemoryNeeded = this.minBatchesPerPartition * Math.max(1L, this.plannedBatches) * (this.estMaxBatchSize + 524288L);
            int maxSize = 1;
            for (int insp = 0; insp < this.spilledState.getNumPartitions(); ++insp) {
                maxSize = Math.max(maxSize, this.batchHolders[insp].size());
            }
            logger.trace("MEMORY CHECK: Allocated mem: {}, agg phase: {}, trying to add to partition {} with {} batches. Max memory needed {}, Est batch size {}, mem limit {}", new Object[]{this.allocator.getAllocatedMemory(), this.phase.getName(), currentPartition, this.batchHolders[currentPartition].size(), maxMemoryNeeded += (long)(0x100000 * maxSize), this.estMaxBatchSize, this.allocator.getLimit()});
        }
        if (forceSpill || this.allocator.getAllocatedMemory() + maxMemoryNeeded > this.allocator.getLimit()) {
            int victimPartition = this.chooseAPartitionToFlush(currentPartition, forceSpill);
            if (victimPartition < 0) {
                if (forceSpill) {
                    throw new OutOfMemoryException(this.getOOMErrorMsg("AGGR"));
                }
                return;
            }
            if (this.phase.is2nd()) {
                boolean spillAgain;
                long before = this.allocator.getAllocatedMemory();
                this.spillAPartition(victimPartition);
                logger.trace("RAN OUT OF MEMORY: Spilled partition {}", (Object)victimPartition);
                this.reinitPartition(victimPartition);
                boolean bl = spillAgain = this.reserveOutgoingMemory == 0L || this.reserveValueBatchMemory == 0L;
                if (spillAgain || this.allocator.getAllocatedMemory() + maxMemoryNeeded > this.allocator.getLimit()) {
                    int victimPartition2 = this.chooseAPartitionToFlush(victimPartition, true);
                    if (victimPartition2 < 0) {
                        if (forceSpill) {
                            throw new OutOfMemoryException(this.getOOMErrorMsg("AGGR"));
                        }
                        return;
                    }
                    long after = this.allocator.getAllocatedMemory();
                    this.spillAPartition(victimPartition2);
                    this.reinitPartition(victimPartition2);
                    logger.warn("A Second Spill was Needed: allocated before {}, after first spill {}, after second {}, memory needed {}", new Object[]{before, after, this.allocator.getAllocatedMemory(), maxMemoryNeeded});
                    logger.trace("Second Partition Spilled: {}", (Object)victimPartition2);
                }
            } else {
                this.earlyOutput = true;
                this.earlyPartition = victimPartition;
            }
        }
    }

    private void updateStats(HashTable[] htables) {
        if (!this.spilledState.isFirstCycle() || this.handleEmit) {
            return;
        }
        long numSpilled = 0L;
        HashTableStats newStats = new HashTableStats();
        for (int ind = 0; ind < this.spilledState.getNumPartitions(); ++ind) {
            htables[ind].getStats(newStats);
            this.htStats.addStats(newStats);
            if (!this.isSpilled(ind)) continue;
            ++numSpilled;
        }
        this.stats.setLongStat(Metric.NUM_BUCKETS, this.htStats.numBuckets);
        this.stats.setLongStat(Metric.NUM_ENTRIES, this.htStats.numEntries);
        this.stats.setLongStat(Metric.NUM_RESIZING, this.htStats.numResizing);
        this.stats.setLongStat(Metric.RESIZING_TIME_MS, this.htStats.resizingTime);
        this.stats.setLongStat(Metric.NUM_PARTITIONS, this.spilledState.getNumPartitions());
        this.stats.setLongStat(Metric.SPILL_CYCLE, this.spilledState.getCycle());
        if (this.phase.is2nd()) {
            this.stats.setLongStat(Metric.SPILLED_PARTITIONS, numSpilled);
        }
        if (this.rowsReturnedEarly > 0) {
            this.stats.setLongStat(Metric.SPILL_MB, (int)Math.round((double)((long)this.rowsReturnedEarly * this.estOutputRowWidth) / 1024.0 / 1024.0));
        }
    }

    public String toString() {
        String[] excludedFields = new String[]{"baseHashTable", "incoming", "outgoing", "context", "oContext", "allocator", "htables", "newIncoming"};
        return ReflectionToStringBuilder.toStringExclude((Object)this, (String[])excludedFields);
    }

    public abstract void doSetup(@Named(value="incoming") RecordBatch var1) throws SchemaChangeException;

    public abstract int getVectorIndex(@Named(value="recordIndex") int var1) throws SchemaChangeException;

    public abstract boolean resetValues() throws SchemaChangeException;

    public class BatchHolder {
        private final VectorContainer aggrValuesContainer = new VectorContainer();
        private int maxOccupiedIdx = -1;
        private int targetBatchRowCount;

        public int getTargetBatchRowCount() {
            return this.targetBatchRowCount;
        }

        public void setTargetBatchRowCount(int batchRowCount) {
            this.targetBatchRowCount = batchRowCount;
        }

        public int getCurrentRowCount() {
            return this.maxOccupiedIdx + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BatchHolder(int batchRowCount) {
            boolean success = false;
            this.targetBatchRowCount = batchRowCount;
            try {
                for (int i = 0; i < HashAggTemplate.this.materializedValueFields.length; ++i) {
                    MaterializedField outputField = HashAggTemplate.this.materializedValueFields[i];
                    ValueVector vector = TypeHelper.getNewVector(outputField, HashAggTemplate.this.allocator);
                    if (vector instanceof FixedWidthVector) {
                        ((FixedWidthVector)vector).allocateNew(batchRowCount);
                    } else if (vector instanceof VariableWidthVector) {
                        ((VariableWidthVector)vector).allocateNew(HashAggTemplate.this.maxColumnWidth, batchRowCount);
                    } else if (vector instanceof ObjectVector) {
                        ((ObjectVector)vector).allocateNew(batchRowCount);
                    } else {
                        vector.allocateNew();
                    }
                    this.aggrValuesContainer.add(vector);
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.aggrValuesContainer.clear();
                }
            }
        }

        private boolean updateAggrValues(int incomingRowIdx, int idxWithinBatch) {
            try {
                this.updateAggrValuesInternal(incomingRowIdx, idxWithinBatch);
            }
            catch (SchemaChangeException sc) {
                throw new UnsupportedOperationException(sc);
            }
            this.maxOccupiedIdx = Math.max(this.maxOccupiedIdx, idxWithinBatch);
            return true;
        }

        private void setup() {
            try {
                this.setupInterior(HashAggTemplate.this.incoming, HashAggTemplate.this.outgoing, this.aggrValuesContainer);
            }
            catch (SchemaChangeException sc) {
                throw new UnsupportedOperationException(sc);
            }
        }

        private void outputValues() {
            for (int i = 0; i <= this.maxOccupiedIdx; ++i) {
                try {
                    this.outputRecordValues(i, i);
                    continue;
                }
                catch (SchemaChangeException sc) {
                    throw new UnsupportedOperationException(sc);
                }
            }
        }

        private void clear() {
            this.aggrValuesContainer.clear();
        }

        private int getNumGroups() {
            return this.maxOccupiedIdx + 1;
        }

        private int getNumPendingOutput() {
            return this.getNumGroups();
        }

        @RuntimeOverridden
        public void setupInterior(@Named(value="incoming") RecordBatch incoming, @Named(value="outgoing") RecordBatch outgoing, @Named(value="aggrValuesContainer") VectorContainer aggrValuesContainer) throws SchemaChangeException {
        }

        @RuntimeOverridden
        public void updateAggrValuesInternal(@Named(value="incomingRowIdx") int incomingRowIdx, @Named(value="htRowIdx") int htRowIdx) throws SchemaChangeException {
        }

        @RuntimeOverridden
        public void outputRecordValues(@Named(value="htRowIdx") int htRowIdx, @Named(value="outRowIdx") int outRowIdx) throws SchemaChangeException {
        }

        static /* synthetic */ boolean access$900(BatchHolder x0, int x1, int x2) {
            return x0.updateAggrValues(x1, x2);
        }
    }

    public static enum Metric implements MetricDef
    {
        NUM_BUCKETS,
        NUM_ENTRIES,
        NUM_RESIZING,
        RESIZING_TIME_MS,
        NUM_PARTITIONS,
        SPILLED_PARTITIONS,
        SPILL_MB,
        SPILL_CYCLE,
        INPUT_BATCH_COUNT,
        AVG_INPUT_BATCH_BYTES,
        AVG_INPUT_ROW_BYTES,
        INPUT_RECORD_COUNT,
        OUTPUT_BATCH_COUNT,
        AVG_OUTPUT_BATCH_BYTES,
        AVG_OUTPUT_ROW_BYTES,
        OUTPUT_RECORD_COUNT;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

