/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.aggregate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.cache.VectorAccessibleSerializable;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.spill.SpillSet;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpilledRecordBatch
implements CloseableRecordBatch {
    private static final Logger logger = LoggerFactory.getLogger(SpilledRecordBatch.class);
    private VectorContainer container;
    private InputStream spillStream;
    private int spilledBatches;
    private final FragmentContext context;
    private final BatchSchema schema;
    private final SpillSet spillSet;
    private final String spillFile;
    VectorAccessibleSerializable vas;
    private final RecordBatch.IterOutcome initialOutcome;
    private RecordBatch.IterOutcome lastOutcome;

    public SpilledRecordBatch(String spillFile, int spilledBatches, FragmentContext context, BatchSchema schema, OperatorContext oContext, SpillSet spillSet) {
        this.context = context;
        this.schema = schema;
        this.spilledBatches = spilledBatches;
        this.spillSet = spillSet;
        this.spillFile = spillFile;
        this.vas = new VectorAccessibleSerializable(oContext.getAllocator());
        this.container = this.vas.get();
        try {
            this.spillStream = this.spillSet.openForInput(spillFile);
        }
        catch (IOException e) {
            throw UserException.resourceError(e).build(logger);
        }
        this.lastOutcome = this.initialOutcome = this.next();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    @Override
    public WritableBatch getWritableBatch() {
        return WritableBatch.get(this);
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.container;
    }

    @Override
    public VectorContainer getContainer() {
        return this.container;
    }

    @Override
    public int getRecordCount() {
        return this.container.getRecordCount();
    }

    @Override
    public void cancel() {
        this.close();
    }

    @Override
    public RecordBatch.IterOutcome next() {
        this.context.getExecutorState().checkContinue();
        if (this.spilledBatches <= 0) {
            this.close();
            this.lastOutcome = RecordBatch.IterOutcome.NONE;
            return this.lastOutcome;
        }
        if (this.spillStream == null) {
            throw new IllegalStateException("Spill stream was null");
        }
        if (this.spillSet.getPosition(this.spillStream) < 0L) {
            logger.warn("Position is {} for stream {}", (Object)this.spillSet.getPosition(this.spillStream), (Object)this.spillStream.toString());
        }
        try {
            if (this.container.getNumberOfColumns() > 0) {
                this.vas.readFromStreamWithContainer(this.container, this.spillStream);
            } else {
                this.vas.readFromStream(this.spillStream);
                this.container = this.vas.get();
            }
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).addContext("Failed reading from a spill file").build(logger);
        }
        catch (Exception e) {
            throw UserException.executionError(e).build(logger);
        }
        --this.spilledBatches;
        this.lastOutcome = RecordBatch.IterOutcome.OK;
        return this.lastOutcome;
    }

    public RecordBatch.IterOutcome getInitialOutcome() {
        return this.initialOutcome;
    }

    @Override
    public void dump() {
        logger.error("SpilledRecordbatch[container={}, spilledBatches={}, schema={}, spillFile={}, spillSet={}]", new Object[]{this.container, this.spilledBatches, this.schema, this.spillFile, this.spillSet});
    }

    @Override
    public void close() {
        this.container.clear();
        try {
            if (this.spillStream != null) {
                this.spillStream.close();
                this.spillStream = null;
            }
            this.spillSet.delete(this.spillFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

