/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.aggregate;

import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.aggregate.InternalBatch;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggBatch;
import org.apache.drill.exec.physical.impl.aggregate.StreamingAggregator;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamingAggTemplate
implements StreamingAggregator {
    private static final Logger logger = LoggerFactory.getLogger(StreamingAggTemplate.class);
    private static final boolean EXTRA_DEBUG = false;
    private int maxOutputRows = 65536;
    private RecordBatch.IterOutcome lastOutcome;
    private boolean first = true;
    private boolean firstBatchForSchema;
    private boolean firstBatchForDataSet = true;
    private boolean newSchema;
    private boolean done;
    private int underlyingIndex;
    private int previousIndex = -1;
    private int currentIndex = Integer.MAX_VALUE;
    private long addedRecordCount;
    private RecordBatch.IterOutcome outcome;
    private int outputCount;
    private RecordBatch incoming;
    private StreamingAggBatch outgoing;
    private OperatorContext context;

    @Override
    public void setup(OperatorContext context, RecordBatch incoming, StreamingAggBatch outgoing, int outputRowCount) throws SchemaChangeException {
        this.context = context;
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.maxOutputRows = outputRowCount;
        this.setupInterior(incoming, outgoing);
    }

    private void allocateOutgoing() {
        for (VectorWrapper<?> w : this.outgoing) {
            w.getValueVector().allocateNew();
        }
    }

    @Override
    public RecordBatch.IterOutcome getOutcome() {
        return this.outcome;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    /*
     * Exception decompiling
     */
    @Override
    public StreamingAggregator.AggOutcome doWork(RecordBatch.IterOutcome outerOutcome) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 39[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    private boolean processRemainingRecordsInBatch() {
        while (this.underlyingIndex < this.incoming.getRecordCount()) {
            if (this.previousIndex == -1) {
                this.addRecordInc(this.currentIndex);
            } else if (this.isSame(this.previousIndex, this.currentIndex)) {
                this.addRecordInc(this.currentIndex);
            } else if (!this.outputToBatch(this.previousIndex)) {
                this.addRecordInc(this.currentIndex);
            } else {
                this.previousIndex = -1;
                return false;
            }
            this.previousIndex = this.currentIndex;
            this.incIndex();
        }
        return true;
    }

    private final void incIndex() {
        ++this.underlyingIndex;
        if (this.underlyingIndex >= this.incoming.getRecordCount()) {
            this.currentIndex = Integer.MAX_VALUE;
            return;
        }
        this.currentIndex = this.getVectorIndex(this.underlyingIndex);
    }

    private final void resetIndex() {
        this.underlyingIndex = 0;
        this.currentIndex = Integer.MAX_VALUE;
    }

    private final StreamingAggregator.AggOutcome setOkAndReturn(RecordBatch.IterOutcome seenOutcome) {
        RecordBatch.IterOutcome outcomeToReturn;
        this.firstBatchForDataSet = false;
        if (this.firstBatchForSchema) {
            outcomeToReturn = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            this.firstBatchForSchema = false;
        } else {
            outcomeToReturn = RecordBatch.IterOutcome.OK;
        }
        this.outcome = outcomeToReturn;
        this.outgoing.getContainer().setValueCount(this.outputCount);
        return seenOutcome == RecordBatch.IterOutcome.EMIT ? StreamingAggregator.AggOutcome.RETURN_AND_RESET : StreamingAggregator.AggOutcome.RETURN_OUTCOME;
    }

    private final StreamingAggregator.AggOutcome setOkAndReturnEmit() {
        RecordBatch.IterOutcome outcomeToReturn;
        this.firstBatchForDataSet = true;
        this.previousIndex = -1;
        if (this.firstBatchForSchema) {
            outcomeToReturn = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            this.firstBatchForSchema = false;
        } else {
            outcomeToReturn = RecordBatch.IterOutcome.EMIT;
        }
        this.outcome = outcomeToReturn;
        this.outgoing.getContainer().setValueCount(this.outputCount);
        return StreamingAggregator.AggOutcome.RETURN_AND_RESET;
    }

    private final boolean outputToBatch(int inIndex) {
        assert (this.outputCount < this.maxOutputRows) : "Outgoing RecordBatch is not flushed. It reached its max capacity in the last update";
        this.outputRecordKeys(inIndex, this.outputCount);
        this.outputRecordValues(this.outputCount);
        this.resetValues();
        ++this.outputCount;
        this.addedRecordCount = 0L;
        return this.outputCount == this.maxOutputRows;
    }

    private final boolean outputToBatchPrev(InternalBatch b1, int inIndex, int outIndex) {
        assert (this.outputCount < this.maxOutputRows) : "Outgoing RecordBatch is not flushed. It reached its max capacity in the last update";
        this.outputRecordKeysPrev(b1, inIndex, outIndex);
        this.outputRecordValues(outIndex);
        this.resetValues();
        ++this.outputCount;
        this.addedRecordCount = 0L;
        return this.outputCount == this.maxOutputRows;
    }

    private void addRecordInc(int index) {
        this.addRecord(index);
        ++this.addedRecordCount;
    }

    @Override
    public void cleanup() {
    }

    public String toString() {
        return "StreamingAggTemplate[underlyingIndex=" + this.underlyingIndex + ", previousIndex=" + this.previousIndex + ", currentIndex=" + this.currentIndex + ", addedRecordCount=" + this.addedRecordCount + ", outputCount=" + this.outputCount + "]";
    }

    @Override
    public boolean previousBatchProcessed() {
        return this.currentIndex == Integer.MAX_VALUE;
    }

    public abstract void setupInterior(@Named(value="incoming") RecordBatch var1, @Named(value="outgoing") RecordBatch var2) throws SchemaChangeException;

    public abstract boolean isSame(@Named(value="index1") int var1, @Named(value="index2") int var2);

    public abstract boolean isSamePrev(@Named(value="b1Index") int var1, @Named(value="b1") InternalBatch var2, @Named(value="b2Index") int var3);

    public abstract void addRecord(@Named(value="index") int var1);

    public abstract void outputRecordKeys(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2);

    public abstract void outputRecordKeysPrev(@Named(value="previous") InternalBatch var1, @Named(value="previousIndex") int var2, @Named(value="outIndex") int var3);

    public abstract void outputRecordValues(@Named(value="outIndex") int var1);

    public abstract int getVectorIndex(@Named(value="recordIndex") int var1);

    public abstract boolean resetValues();
}

