/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import com.sun.codemodel.JVar;
import io.netty.buffer.DrillBuf;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.util.Pair;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.shaded.guava.com.google.common.base.Function;

public class CodeGenMemberInjector {
    public static void injectMembers(ClassGenerator<?> cg, Object instance, FragmentContext context) {
        HashMap<Integer, Object> cachedInstances = new HashMap<Integer, Object>();
        for (Map.Entry<Pair<Integer, JVar>, Function<DrillBuf, ValueHolder>> setter : cg.getConstantVars().entrySet()) {
            try {
                JVar var = (JVar)setter.getKey().getValue();
                Integer depth = (Integer)setter.getKey().getKey();
                Object varInstance = CodeGenMemberInjector.getFieldInstance(instance, depth, cachedInstances);
                Field field = varInstance.getClass().getDeclaredField(var.name());
                field.setAccessible(true);
                field.set(varInstance, setter.getValue().apply(context.getManagedBuffer()));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Object getFieldInstance(Object instance, Integer depth, Map<Integer, Object> cache) throws ReflectiveOperationException {
        if (depth <= 1) {
            return instance;
        }
        Object methodInstance = cache.get(depth);
        if (methodInstance != null) {
            return methodInstance;
        }
        methodInstance = CodeGenMemberInjector.getFieldInstance(instance, depth);
        cache.put(depth, methodInstance);
        return methodInstance;
    }

    private static Object getFieldInstance(Object instance, Integer depth) throws ReflectiveOperationException {
        if (depth <= 1) {
            return instance;
        }
        Field field = instance.getClass().getDeclaredField("innerClassField");
        field.setAccessible(true);
        return CodeGenMemberInjector.getFieldInstance(field.get(instance), depth - 1);
    }
}

