/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.exceptions.RetryAfterSpillException;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.physical.impl.common.HashTableStats;
import org.apache.drill.exec.physical.impl.common.HashTableTemplate;
import org.apache.drill.exec.physical.impl.common.IndexPointer;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;

public interface HashTable {
    public static final TemplateClassDefinition<HashTable> TEMPLATE_DEFINITION = new TemplateClassDefinition<HashTable>(HashTable.class, HashTableTemplate.class);
    public static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int BATCH_SIZE = 65536;
    public static final int BATCH_MASK = 65535;

    public void setup(HashTableConfig var1, BufferAllocator var2, VectorContainer var3, RecordBatch var4, RecordBatch var5, VectorContainer var6, FragmentContext var7, ClassGenerator<?> var8);

    public void updateBatches() throws SchemaChangeException;

    public int getBuildHashCode(int var1) throws SchemaChangeException;

    public int getProbeHashCode(int var1) throws SchemaChangeException;

    public PutStatus put(int var1, IndexPointer var2, int var3, int var4) throws SchemaChangeException, RetryAfterSpillException;

    public int probeForKey(int var1, int var2) throws SchemaChangeException;

    public int getRecordNumForKey(int var1);

    public void setRecordNumForKey(int var1, int var2);

    public void decreaseRecordNumForKey(int var1);

    public void getStats(HashTableStats var1);

    public int size();

    public boolean isEmpty();

    public void clear();

    public void updateInitialCapacity(int var1);

    public void updateIncoming(VectorContainer var1, RecordBatch var2);

    public void reset();

    public boolean outputKeys(int var1, VectorContainer var2, int var3);

    public String makeDebugString();

    public long getActualSize();

    public void setTargetBatchRowCount(int var1);

    public int getTargetBatchRowCount();

    public Pair<VectorContainer, Integer> nextBatch();

    public static enum PutStatus {
        KEY_PRESENT,
        KEY_ADDED,
        NEW_BATCH_ADDED,
        KEY_ADDED_LAST,
        PUT_FAILED;

    }
}

