/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

class HashTableAllocationTracker {
    private final HashTableConfig config;
    private State state = State.NO_ALLOCATION_IN_PROGRESS;
    private int remainingCapacity;

    protected HashTableAllocationTracker(HashTableConfig config) {
        this.config = Preconditions.checkNotNull(config);
        this.remainingCapacity = config.getInitialCapacity();
    }

    public int getNextBatchHolderSize(int batchSize) {
        this.state = State.ALLOCATION_IN_PROGRESS;
        if (!this.config.getInitialSizeIsFinal()) {
            return batchSize;
        }
        Preconditions.checkState(this.remainingCapacity > 0);
        return this.computeNextBatchHolderSize(batchSize);
    }

    private int computeNextBatchHolderSize(int batchSize) {
        return Math.min(batchSize, this.remainingCapacity);
    }

    public void commit(int batchSize) {
        Preconditions.checkState(this.state.equals((Object)State.ALLOCATION_IN_PROGRESS));
        this.remainingCapacity -= batchSize;
        this.state = State.NO_ALLOCATION_IN_PROGRESS;
    }

    private static enum State {
        NO_ALLOCATION_IN_PROGRESS,
        ALLOCATION_IN_PROGRESS;

    }
}

