/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.filter;

import java.util.ArrayList;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.Filter;
import org.apache.drill.exec.physical.impl.filter.Filterer;
import org.apache.drill.exec.physical.impl.filter.ReturnValueExpression;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRecordBatch
extends AbstractSingleRecordBatch<Filter> {
    private static final Logger logger = LoggerFactory.getLogger(FilterRecordBatch.class);
    private SelectionVector2 sv2;
    private SelectionVector4 sv4;
    private Filterer filter;

    public FilterRecordBatch(Filter pop, RecordBatch incoming, FragmentContext context) throws OutOfMemoryException {
        super(pop, context, incoming);
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    @Override
    public int getRecordCount() {
        return this.sv2 != null ? this.sv2.getCount() : this.sv4.getCount();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        return this.sv2;
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        return this.sv4;
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        try {
            this.container.zeroVectors();
            int recordCount = this.incoming.getRecordCount();
            this.filter.filterBatch(recordCount);
            this.container.setRecordCount(this.sv2 != null ? this.sv2.getBatchActualRecordCount() : recordCount);
            return this.getFinalOutcome(false);
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void close() {
        this.clearSv();
        super.close();
    }

    private void clearSv() {
        if (this.sv2 != null) {
            this.sv2.clear();
        }
        if (this.sv4 != null) {
            this.sv4.clear();
        }
    }

    @Override
    protected boolean setupNewSchema() {
        this.clearSv();
        switch (this.incoming.getSchema().getSelectionVectorMode()) {
            case NONE: {
                if (this.sv2 == null) {
                    this.sv2 = new SelectionVector2(this.oContext.getAllocator());
                }
                this.filter = this.generateSV2Filterer();
                break;
            }
            case TWO_BYTE: {
                this.sv2 = new SelectionVector2(this.oContext.getAllocator());
                this.filter = this.generateSV2Filterer();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.container.isSchemaChanged()) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.TWO_BYTE);
            return true;
        }
        return false;
    }

    protected Filterer generateSV4Filterer() throws SchemaChangeException {
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        ArrayList<TransferPair> transfers = Lists.newArrayList();
        ClassGenerator<Filterer> cg = CodeGenerator.getRoot(Filterer.TEMPLATE_DEFINITION4, this.context.getOptions());
        LogicalExpression expr = ExpressionTreeMaterializer.materialize(((Filter)this.popConfig).getExpr(), this.incoming, collector, this.context.getFunctionRegistry());
        if (collector.hasErrors()) {
            throw new SchemaChangeException(String.format("Failure while trying to materialize incoming schema.  Errors:\n %s.", collector.toErrorString()));
        }
        cg.addExpr(new ReturnValueExpression(expr), ClassGenerator.BlkCreateMode.FALSE);
        for (VectorWrapper vw : this.incoming) {
            for (ValueVector vv : vw.getValueVectors()) {
                TransferPair pair = vv.getTransferPair(this.oContext.getAllocator());
                this.container.add(pair.getTo());
                transfers.add(pair);
            }
        }
        this.container.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
        TransferPair[] tx = transfers.toArray(new TransferPair[transfers.size()]);
        Filterer filter = this.context.getImplementationClass(cg);
        filter.setup(this.context, this.incoming, this, tx);
        return filter;
    }

    protected Filterer generateSV2Filterer() {
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        ArrayList<TransferPair> transfers = Lists.newArrayList();
        ClassGenerator<Filterer> cg = CodeGenerator.getRoot(Filterer.TEMPLATE_DEFINITION2, this.context.getOptions());
        cg.getCodeGenerator().plainJavaCapable(true);
        LogicalExpression expr = ExpressionTreeMaterializer.materialize(((Filter)this.popConfig).getExpr(), this.incoming, (ErrorCollector)collector, this.context.getFunctionRegistry(), false, this.unionTypeEnabled);
        collector.reportErrors(logger);
        cg.addExpr(new ReturnValueExpression(expr), ClassGenerator.BlkCreateMode.FALSE);
        for (VectorWrapper v : this.incoming) {
            TransferPair pair = v.getValueVector().makeTransferPair((ValueVector)this.container.addOrGet(v.getField(), this.callBack));
            transfers.add(pair);
        }
        TransferPair[] tx = transfers.toArray(new TransferPair[transfers.size()]);
        CodeGenerator<Filterer> codeGen = cg.getCodeGenerator();
        codeGen.plainJavaCapable(true);
        Filterer filter = this.context.getImplementationClass(codeGen);
        try {
            filter.setup(this.context, this.incoming, this, tx);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        return filter;
    }

    @Override
    public void dump() {
        logger.error("FilterRecordBatch[container={}, selectionVector2={}, filter={}, popConfig={}]", new Object[]{this.container, this.sv2, this.filter, this.popConfig});
    }
}

