/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.flatten;

import java.util.List;
import javax.inject.Named;
import org.apache.drill.exec.exception.OversizedAllocationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.flatten.Flattener;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlattenTemplate
implements Flattener {
    private static final Logger logger = LoggerFactory.getLogger(FlattenTemplate.class);
    private static final int OUTPUT_ROW_COUNT = 65536;
    private ImmutableList<TransferPair> transfers;
    private BatchSchema.SelectionVectorMode svMode;
    private RepeatedValueVector fieldToFlatten;
    private RepeatedValueVector.RepeatedAccessor accessor;
    private int valueIndex;
    private int outputLimit = 65536;
    private int innerValueIndex = -1;
    private int currentInnerValueIndex;

    @Override
    public void setFlattenField(RepeatedValueVector flattenField) {
        this.fieldToFlatten = flattenField;
        this.accessor = (RepeatedValueVector.RepeatedAccessor)RepeatedValueVector.RepeatedAccessor.class.cast(flattenField.getAccessor());
    }

    @Override
    public RepeatedValueVector getFlattenField() {
        return this.fieldToFlatten;
    }

    @Override
    public void setOutputCount(int outputCount) {
        this.outputLimit = outputCount;
    }

    @Override
    public final int flattenRecords(int recordCount, int firstOutputIndex, Flattener.Monitor monitor) {
        switch (this.svMode) {
            case FOUR_BYTE: {
                throw new UnsupportedOperationException("Flatten does not support selection vector inputs.");
            }
            case TWO_BYTE: {
                throw new UnsupportedOperationException("Flatten does not support selection vector inputs.");
            }
            case NONE: {
                int valueIndexLocal;
                if (this.innerValueIndex == -1) {
                    this.innerValueIndex = 0;
                }
                int initialInnerValueIndex = this.currentInnerValueIndex;
                int innerValueIndexLocal = this.innerValueIndex;
                int currentInnerValueIndexLocal = this.currentInnerValueIndex;
                int outputIndex = firstOutputIndex;
                int recordsThisCall = 0;
                int valueCount = this.accessor.getValueCount();
                block8: for (valueIndexLocal = this.valueIndex; valueIndexLocal < valueCount; ++valueIndexLocal) {
                    int innerValueCount = this.accessor.getInnerValueCountAt(valueIndexLocal);
                    while (innerValueIndexLocal < innerValueCount) {
                        if (recordsThisCall == this.outputLimit) break block8;
                        try {
                            this.doEval(valueIndexLocal, outputIndex);
                        }
                        catch (OversizedAllocationException ex) {
                            logger.debug("Reached allocation limit. Splitting the batch at input index: {} - inner index: {} - current completed index: {}", new Object[]{valueIndexLocal, innerValueIndexLocal, currentInnerValueIndexLocal});
                            break block8;
                        }
                        catch (SchemaChangeException e) {
                            throw new UnsupportedOperationException(e);
                        }
                        ++outputIndex;
                        ++currentInnerValueIndexLocal;
                        ++recordsThisCall;
                        ++innerValueIndexLocal;
                    }
                    innerValueIndexLocal = 0;
                }
                this.valueIndex = valueIndexLocal;
                this.innerValueIndex = innerValueIndexLocal;
                this.currentInnerValueIndex = currentInnerValueIndexLocal;
                int delta = currentInnerValueIndexLocal - initialInnerValueIndex;
                for (TransferPair t : this.transfers) {
                    t.splitAndTransfer(initialInnerValueIndex, delta);
                }
                return delta;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setup(FragmentContext context, RecordBatch incoming, RecordBatch outgoing, List<TransferPair> transfers) throws SchemaChangeException {
        this.svMode = incoming.getSchema().getSelectionVectorMode();
        switch (this.svMode) {
            case FOUR_BYTE: {
                throw new UnsupportedOperationException("Flatten does not support selection vector inputs.");
            }
            case TWO_BYTE: {
                throw new UnsupportedOperationException("Flatten does not support selection vector inputs.");
            }
        }
        this.transfers = ImmutableList.copyOf(transfers);
        this.doSetup(context, incoming, outgoing);
    }

    @Override
    public void resetGroupIndex() {
        this.valueIndex = 0;
        this.currentInnerValueIndex = 0;
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") RecordBatch var2, @Named(value="outgoing") RecordBatch var3) throws SchemaChangeException;

    public abstract boolean doEval(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;

    public String toString() {
        return "FlattenTemplate[svMode=" + (Object)((Object)this.svMode) + ", fieldToFlatten=" + this.fieldToFlatten + ", valueIndex=" + this.valueIndex + ", outputLimit=" + this.outputLimit + ", innerValueIndex=" + this.innerValueIndex + ", currentInnerValueIndex=" + this.currentInnerValueIndex + "]";
    }
}

