/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.Map;
import org.apache.drill.exec.physical.impl.join.BatchSizePredictor;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class BatchSizePredictorImpl
implements BatchSizePredictor {
    private RecordBatch batch;
    private double fragmentationFactor;
    private double safetyFactor;
    private long batchSize;
    private int numRecords;
    private boolean updatedStats;
    private boolean hasData;

    public BatchSizePredictorImpl(RecordBatch batch, double fragmentationFactor, double safetyFactor) {
        this.batch = Preconditions.checkNotNull(batch);
        this.fragmentationFactor = fragmentationFactor;
        this.safetyFactor = safetyFactor;
    }

    @Override
    public long getBatchSize() {
        Preconditions.checkState(this.updatedStats);
        return this.hasData ? this.batchSize : 0L;
    }

    @Override
    public int getNumRecords() {
        Preconditions.checkState(this.updatedStats);
        return this.hasData ? this.numRecords : 0;
    }

    @Override
    public boolean hadDataLastTime() {
        return this.hasData;
    }

    @Override
    public void updateStats() {
        RecordBatchSizer batchSizer = new RecordBatchSizer(this.batch);
        this.numRecords = batchSizer.rowCount();
        this.updatedStats = true;
        boolean bl = this.hasData = this.numRecords > 0;
        if (this.hasData) {
            this.batchSize = BatchSizePredictorImpl.getBatchSizeEstimate(this.batch);
        }
    }

    @Override
    public long predictBatchSize(int desiredNumRecords, boolean reserveHash) {
        Preconditions.checkState(this.hasData);
        return BatchSizePredictorImpl.computeMaxBatchSize(this.batchSize, this.numRecords, desiredNumRecords, this.fragmentationFactor, this.safetyFactor, reserveHash);
    }

    public static long computeValueVectorSize(long numRecords, long byteSize) {
        long naiveSize = numRecords * byteSize;
        return BatchSizePredictorImpl.roundUpToPowerOf2(naiveSize);
    }

    public static long computeValueVectorSize(long numRecords, long byteSize, double safetyFactor) {
        long naiveSize = RecordBatchSizer.multiplyByFactor(numRecords * byteSize, safetyFactor);
        return BatchSizePredictorImpl.roundUpToPowerOf2(naiveSize);
    }

    public static long roundUpToPowerOf2(long num) {
        Preconditions.checkArgument(num >= 1L);
        return num == 1L ? 1L : Long.highestOneBit(num - 1L) << 1;
    }

    public static long computeMaxBatchSizeNoHash(long incomingBatchSize, int incomingNumRecords, int desiredNumRecords, double fragmentationFactor, double safetyFactor) {
        long maxBatchSize = BatchSizePredictorImpl.computePartitionBatchSize(incomingBatchSize, incomingNumRecords, desiredNumRecords);
        return RecordBatchSizer.multiplyByFactors(maxBatchSize, fragmentationFactor, safetyFactor);
    }

    public static long computeMaxBatchSize(long incomingBatchSize, int incomingNumRecords, int desiredNumRecords, double fragmentationFactor, double safetyFactor, boolean reserveHash) {
        long size = BatchSizePredictorImpl.computeMaxBatchSizeNoHash(incomingBatchSize, incomingNumRecords, desiredNumRecords, fragmentationFactor, safetyFactor);
        if (!reserveHash) {
            return size;
        }
        long hashSize = (long)desiredNumRecords * 4L;
        hashSize = RecordBatchSizer.multiplyByFactors(hashSize, fragmentationFactor);
        return size + hashSize;
    }

    public static long computePartitionBatchSize(long incomingBatchSize, int incomingNumRecords, int desiredNumRecords) {
        return (long)Math.ceil((double)incomingBatchSize / (double)incomingNumRecords * (double)desiredNumRecords);
    }

    public static long getBatchSizeEstimate(RecordBatch recordBatch) {
        RecordBatchSizer sizer = new RecordBatchSizer(recordBatch);
        long size = 0L;
        for (Map.Entry<String, RecordBatchSizer.ColumnSize> column : sizer.columns().entrySet()) {
            size += BatchSizePredictorImpl.computeValueVectorSize(recordBatch.getRecordCount(), column.getValue().getStdNetOrNetSizePerEntry());
        }
        return size;
    }

    public static class Factory
    implements BatchSizePredictor.Factory {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public BatchSizePredictor create(RecordBatch batch, double fragmentationFactor, double safetyFactor) {
            return new BatchSizePredictorImpl(batch, fragmentationFactor, safetyFactor);
        }
    }
}

