/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import com.carrotsearch.hppc.IntArrayList;
import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.record.selection.SelectionVector4;

public class HashJoinHelper {
    List<SelectionVector4> startIndices = new ArrayList<SelectionVector4>();
    List<BuildInfo> buildInfoList = new ArrayList<BuildInfo>();
    FragmentContext context;
    BufferAllocator allocator;
    static final int INDEX_EMPTY = -1;
    static final int SHIFT_SIZE = 16;
    public static final int LEFT_INPUT = 0;
    public static final int RIGHT_INPUT = 1;

    public HashJoinHelper(FragmentContext context, BufferAllocator allocator) {
        this.context = context;
        this.allocator = allocator;
    }

    public void addStartIndexBatch() throws SchemaChangeException {
        this.startIndices.add(this.getNewSV4(65536));
    }

    public SelectionVector4 getNewSV4(int recordCount) throws SchemaChangeException {
        DrillBuf vector = this.allocator.buffer(recordCount * 4);
        SelectionVector4 sv4 = new SelectionVector4(vector, recordCount, recordCount);
        for (int i = 0; i < recordCount; ++i) {
            sv4.set(i, -1);
        }
        return sv4;
    }

    public void addNewBatch(int recordCount) throws SchemaChangeException {
        BuildInfo info = new BuildInfo(this.getNewSV4(recordCount), new BitSet(recordCount), recordCount);
        this.buildInfoList.add(info);
    }

    public int getStartIndex(int keyIndex) {
        int batchIdx = keyIndex / 65536;
        int offsetIdx = keyIndex % 65536;
        assert (batchIdx < this.startIndices.size());
        SelectionVector4 sv4 = this.startIndices.get(batchIdx);
        return sv4.get(offsetIdx);
    }

    public int getNextIndex(int currentIdx) {
        int batchIdx = currentIdx >>> 16;
        int recordIdx = currentIdx & 0xFFFF;
        assert (batchIdx < this.buildInfoList.size());
        BuildInfo info = this.buildInfoList.get(batchIdx);
        return info.getLinks().get(recordIdx);
    }

    public IntArrayList getNextUnmatchedIndex() {
        IntArrayList compositeIndexes = new IntArrayList();
        for (int i = 0; i < this.buildInfoList.size(); ++i) {
            BuildInfo info = this.buildInfoList.get(i);
            int fromIndex = 0;
            while ((fromIndex = info.getKeyMatchBitVector().nextClearBit(fromIndex)) != -1 && fromIndex < info.recordCount) {
                compositeIndexes.add(i << 16 | fromIndex & 0xFFFF);
                ++fromIndex;
            }
        }
        return compositeIndexes;
    }

    public boolean setRecordMatched(int index) {
        int batchIdx = index >>> 16;
        int recordIdx = index & 0xFFFF;
        BuildInfo info = this.buildInfoList.get(batchIdx);
        BitSet bitVector = info.getKeyMatchBitVector();
        if (bitVector.get(recordIdx)) {
            return true;
        }
        bitVector.set(recordIdx);
        return false;
    }

    public void setCurrentIndex(int keyIndex, int batchIndex, int recordIndex) throws SchemaChangeException {
        SelectionVector4 startIndex;
        int linkIndex;
        if (keyIndex < 0) {
            return;
        }
        int batchIdx = keyIndex / 65536;
        int offsetIdx = keyIndex % 65536;
        if (keyIndex >= 65536 * this.startIndices.size()) {
            this.addStartIndexBatch();
        }
        if ((linkIndex = (startIndex = this.startIndices.get(batchIdx)).get(offsetIdx)) == -1) {
            startIndex.set(offsetIdx, batchIndex, recordIndex);
        } else {
            batchIdx = linkIndex >>> 16;
            offsetIdx = linkIndex & 0xFFFF;
            SelectionVector4 link = this.buildInfoList.get(batchIdx).getLinks();
            int firstLink = link.get(offsetIdx);
            if (firstLink == -1) {
                link.set(offsetIdx, batchIndex, recordIndex);
            } else {
                int firstLinkBatchIdx = firstLink >>> 16;
                int firstLinkOffsetIDx = firstLink & 0xFFFF;
                SelectionVector4 nextLink = this.buildInfoList.get(batchIndex).getLinks();
                nextLink.set(recordIndex, firstLinkBatchIdx, firstLinkOffsetIDx);
                link.set(offsetIdx, batchIndex, recordIndex);
            }
        }
    }

    public void clear() {
        for (SelectionVector4 sv4 : this.startIndices) {
            sv4.clear();
        }
        for (BuildInfo info : this.buildInfoList) {
            info.getLinks().clear();
        }
        this.buildInfoList.clear();
    }

    public class BuildInfo {
        private SelectionVector4 links;
        private BitSet keyMatchBitVector;
        private int recordCount;

        public BuildInfo(SelectionVector4 links, BitSet keyMatchBitVector, int recordCount) {
            this.links = links;
            this.keyMatchBitVector = keyMatchBitVector;
            this.recordCount = recordCount;
        }

        public SelectionVector4 getLinks() {
            return this.links;
        }

        public BitSet getKeyMatchBitVector() {
            return this.keyMatchBitVector;
        }

        public void clear() {
            this.keyMatchBitVector.clear();
        }
    }
}

