/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.drill.exec.physical.impl.join.HashJoinMemoryCalculator;
import org.apache.drill.exec.physical.impl.join.HashJoinMemoryCalculatorImpl;
import org.apache.drill.exec.physical.impl.join.HashJoinState;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class HashJoinMechanicalMemoryCalculator
implements HashJoinMemoryCalculator {
    private final int maxNumInMemBatches;
    private boolean doMemoryCalc;

    public HashJoinMechanicalMemoryCalculator(int maxNumInMemBatches) {
        this.maxNumInMemBatches = maxNumInMemBatches;
    }

    @Override
    public void initialize(boolean doMemoryCalc) {
        this.doMemoryCalc = doMemoryCalc;
    }

    @Override
    @Nullable
    public HashJoinMemoryCalculator.BuildSidePartitioning next() {
        if (this.doMemoryCalc) {
            return new MechanicalBuildSidePartitioning(this.maxNumInMemBatches);
        }
        return new HashJoinMemoryCalculatorImpl.NoopBuildSidePartitioningImpl();
    }

    @Override
    public HashJoinState getState() {
        return HashJoinState.INITIALIZING;
    }

    public static class MechanicalBuildSidePartitioning
    implements HashJoinMemoryCalculator.BuildSidePartitioning {
        private final int maxNumInMemBatches;
        private int initialPartitions;
        private HashJoinMemoryCalculator.PartitionStatSet partitionStatSet;
        private int recordsPerPartitionBatchProbe;

        public MechanicalBuildSidePartitioning(int maxNumInMemBatches) {
            this.maxNumInMemBatches = maxNumInMemBatches;
        }

        @Override
        public void initialize(boolean autoTune, boolean reserveHash, RecordBatch buildSideBatch, RecordBatch probeSideBatch, Set<String> joinColumns, boolean probeEmpty, long memoryAvailable, int initialPartitions, int recordsPerPartitionBatchBuild, int recordsPerPartitionBatchProbe, int maxBatchNumRecordsBuild, int maxBatchNumRecordsProbe, int outputBatchSize, double loadFactor) {
            this.initialPartitions = initialPartitions;
            this.recordsPerPartitionBatchProbe = recordsPerPartitionBatchProbe;
        }

        @Override
        public void setPartitionStatSet(HashJoinMemoryCalculator.PartitionStatSet partitionStatSet) {
            this.partitionStatSet = Preconditions.checkNotNull(partitionStatSet);
        }

        @Override
        public int getNumPartitions() {
            return this.initialPartitions;
        }

        @Override
        public long getBuildReservedMemory() {
            return 0L;
        }

        @Override
        public long getMaxReservedMemory() {
            return 0L;
        }

        @Override
        public boolean shouldSpill() {
            return this.partitionStatSet.getNumInMemoryBatches() > this.maxNumInMemBatches;
        }

        @Override
        public String makeDebugString() {
            return "Mechanical build side calculations";
        }

        @Override
        @Nullable
        public HashJoinMemoryCalculator.PostBuildCalculations next() {
            return new MechanicalPostBuildCalculations(this.maxNumInMemBatches, this.partitionStatSet, this.recordsPerPartitionBatchProbe);
        }

        @Override
        public HashJoinState getState() {
            return HashJoinState.BUILD_SIDE_PARTITIONING;
        }
    }

    public static class MechanicalPostBuildCalculations
    implements HashJoinMemoryCalculator.PostBuildCalculations {
        private final int maxNumInMemBatches;
        private final HashJoinMemoryCalculator.PartitionStatSet partitionStatSet;
        private final int recordsPerPartitionBatchProbe;

        public MechanicalPostBuildCalculations(int maxNumInMemBatches, HashJoinMemoryCalculator.PartitionStatSet partitionStatSet, int recordsPerPartitionBatchProbe) {
            this.maxNumInMemBatches = maxNumInMemBatches;
            this.partitionStatSet = Preconditions.checkNotNull(partitionStatSet);
            this.recordsPerPartitionBatchProbe = recordsPerPartitionBatchProbe;
        }

        @Override
        public void initialize(boolean probeEmty) {
        }

        @Override
        public int getProbeRecordsPerBatch() {
            return this.recordsPerPartitionBatchProbe;
        }

        @Override
        public boolean shouldSpill() {
            return this.partitionStatSet.getNumInMemoryBatches() > this.maxNumInMemBatches;
        }

        @Override
        public String makeDebugString() {
            return "Mechanical post build calculations";
        }

        @Override
        @Nullable
        public HashJoinMemoryCalculator next() {
            return null;
        }

        @Override
        public HashJoinState getState() {
            return HashJoinState.POST_BUILD_CALCULATIONS;
        }
    }
}

