/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.drill.exec.physical.impl.join.HashJoinStateCalculator;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public interface HashJoinMemoryCalculator
extends HashJoinStateCalculator<BuildSidePartitioning> {
    public void initialize(boolean var1);

    public static class BatchStat {
        private int numRecords;
        private long batchSize;

        public BatchStat(int numRecords, long batchSize) {
            this.numRecords = numRecords;
            this.batchSize = batchSize;
        }

        public long getNumRecords() {
            return this.numRecords;
        }

        public long getBatchSize() {
            return this.batchSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BatchStat batchStat = (BatchStat)o;
            if (this.numRecords != batchStat.numRecords) {
                return false;
            }
            return this.batchSize == batchStat.batchSize;
        }

        public int hashCode() {
            int result = this.numRecords;
            result = 31 * result + (int)(this.batchSize ^ this.batchSize >>> 32);
            return result;
        }
    }

    public static class PartitionStatSet {
        private final PartitionStat[] partitionStats;

        public PartitionStatSet(PartitionStat ... partitionStats) {
            this.partitionStats = Preconditions.checkNotNull(partitionStats);
            for (PartitionStat partitionStat : partitionStats) {
                Preconditions.checkNotNull(partitionStat);
            }
        }

        public PartitionStat get(int partitionIndex) {
            return this.partitionStats[partitionIndex];
        }

        public int getSize() {
            return this.partitionStats.length;
        }

        public long getNumInMemoryRecords() {
            long numRecords = 0L;
            for (PartitionStat partitionStat : this.partitionStats) {
                numRecords += partitionStat.getNumInMemoryRecords();
            }
            return numRecords;
        }

        public int getNumInMemoryBatches() {
            int numBatches = 0;
            for (PartitionStat partitionStat : this.partitionStats) {
                numBatches += partitionStat.getNumInMemoryBatches();
            }
            return numBatches;
        }

        public long getConsumedMemory() {
            long consumedMemory = 0L;
            for (PartitionStat partitionStat : this.partitionStats) {
                consumedMemory += partitionStat.getInMemorySize();
            }
            return consumedMemory;
        }

        public List<Integer> getSpilledPartitions() {
            return this.getPartitions(true);
        }

        public List<Integer> getInMemoryPartitions() {
            return this.getPartitions(false);
        }

        public List<Integer> getPartitions(boolean spilled) {
            ArrayList<Integer> partitionIndices = Lists.newArrayList();
            for (int partitionIndex = 0; partitionIndex < this.partitionStats.length; ++partitionIndex) {
                PartitionStat partitionStat = this.partitionStats[partitionIndex];
                if (partitionStat.isSpilled() != spilled) continue;
                partitionIndices.add(partitionIndex);
            }
            return partitionIndices;
        }

        public int getNumInMemoryPartitions() {
            return this.getInMemoryPartitions().size();
        }

        public int getNumSpilledPartitions() {
            return this.getSpilledPartitions().size();
        }

        public boolean allSpilled() {
            return this.getSize() == this.getNumSpilledPartitions();
        }

        public boolean noneSpilled() {
            return this.getSize() == this.getNumInMemoryPartitions();
        }

        public String makeDebugString() {
            StringBuilder sizeSb = new StringBuilder("Partition Sizes:\n");
            StringBuilder batchCountSb = new StringBuilder("Partition Batch Counts:\n");
            StringBuilder recordCountSb = new StringBuilder("Partition Record Counts:\n");
            for (int partitionIndex = 0; partitionIndex < this.partitionStats.length; ++partitionIndex) {
                PartitionStat partitionStat = this.partitionStats[partitionIndex];
                String partitionPrefix = partitionIndex + ": ";
                sizeSb.append(partitionPrefix);
                batchCountSb.append(partitionPrefix);
                recordCountSb.append(partitionPrefix);
                if (partitionStat.isSpilled()) {
                    sizeSb.append("Spilled");
                    batchCountSb.append("Spilled");
                    recordCountSb.append("Spilled");
                } else if (partitionStat.getNumInMemoryRecords() == 0L) {
                    sizeSb.append("Empty");
                    batchCountSb.append("Empty");
                    recordCountSb.append("Empty");
                } else {
                    sizeSb.append(PartitionStatSet.prettyPrintBytes(partitionStat.getInMemorySize()));
                    batchCountSb.append(partitionStat.getNumInMemoryBatches());
                    recordCountSb.append(partitionStat.getNumInMemoryRecords());
                }
                sizeSb.append("\n");
                batchCountSb.append("\n");
                recordCountSb.append("\n");
            }
            return sizeSb.toString() + "\n" + batchCountSb.toString() + "\n" + recordCountSb.toString();
        }

        public static String prettyPrintBytes(long byteCount) {
            return String.format("%d (%s)", byteCount, FileUtils.byteCountToDisplaySize((long)byteCount));
        }
    }

    public static interface PartitionStat {
        public List<BatchStat> getInMemoryBatches();

        public int getNumInMemoryBatches();

        public boolean isSpilled();

        public long getNumInMemoryRecords();

        public long getInMemorySize();
    }

    public static interface PostBuildCalculations
    extends HashJoinStateCalculator<HashJoinMemoryCalculator> {
        public void initialize(boolean var1);

        public int getProbeRecordsPerBatch();

        public boolean shouldSpill();

        public String makeDebugString();
    }

    public static interface BuildSidePartitioning
    extends HashJoinStateCalculator<PostBuildCalculations> {
        public void initialize(boolean var1, boolean var2, RecordBatch var3, RecordBatch var4, Set<String> var5, boolean var6, long var7, int var9, int var10, int var11, int var12, int var13, int var14, double var15);

        public void setPartitionStatSet(PartitionStatSet var1);

        public int getNumPartitions();

        public long getBuildReservedMemory();

        public long getMaxReservedMemory();

        public boolean shouldSpill();

        public String makeDebugString();
    }
}

