/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import org.apache.calcite.rel.core.JoinRelType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.physical.config.HashJoinPOP;
import org.apache.drill.exec.physical.impl.common.HashPartition;
import org.apache.drill.exec.physical.impl.join.AbstractHashBinaryRecordBatch;
import org.apache.drill.exec.physical.impl.join.HashJoinBatch;
import org.apache.drill.exec.physical.impl.join.Probe;
import org.apache.drill.exec.physical.impl.join.ProbeTemplate;
import org.apache.drill.exec.planner.common.JoinControl;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;

public class HashJoinProbeTemplate
extends ProbeTemplate<HashJoinPOP> {
    private JoinRelType joinType;
    private JoinControl joinControl;
    private boolean semiJoin;

    @Override
    public void setup(RecordBatch probeBatch, HashJoinBatch outgoing, JoinRelType joinRelType, boolean semiJoin, RecordBatch.IterOutcome leftStartState, HashPartition[] partitions, int cycleNum, VectorContainer container, AbstractHashBinaryRecordBatch.SpilledPartition[] spilledInners, boolean buildSideIsEmpty, int numPartitions, int rightHVColPosition) throws SchemaChangeException {
        super.setup(probeBatch, leftStartState, partitions, cycleNum, container, spilledInners, buildSideIsEmpty, numPartitions);
        this.outgoingBatch = outgoing;
        this.joinType = joinRelType;
        this.joinControl = new JoinControl(((HashJoinPOP)outgoing.getPopConfig()).getJoinControl());
        this.semiJoin = semiJoin;
        this.numberOfBuildSideColumns = semiJoin ? 0 : rightHVColPosition;
    }

    @Override
    protected void handleProbeResult(int probeIndex) {
        if (this.semiJoin) {
            if (probeIndex != -1) {
                this.outputRecords = this.outputRow(null, 0, this.probeBatch.getContainer(), this.recordsProcessed);
            }
            ++this.recordsProcessed;
            return;
        }
        if (probeIndex != -1) {
            Pair<Integer, Boolean> matchStatus = this.currPartition.getStartIndex(probeIndex);
            boolean matchExists = (Boolean)matchStatus.getRight();
            if (this.joinControl.isIntersectDistinct() && matchExists) {
                ++this.recordsProcessed;
                return;
            }
            this.currentCompositeIdx = (Integer)matchStatus.getLeft();
            this.outputRecords = this.outputRow(this.currPartition.getContainers(), this.currentCompositeIdx, this.probeBatch.getContainer(), this.recordsProcessed);
            int n = this.currentCompositeIdx = this.joinControl.isIntersectDistinct() ? -1 : this.currPartition.getNextIndex(this.currentCompositeIdx);
            if (this.currentCompositeIdx == -1) {
                ++this.recordsProcessed;
            } else {
                this.getNextRecord = false;
            }
        } else {
            if (this.joinType == JoinRelType.LEFT || this.joinType == JoinRelType.FULL) {
                this.outputRecords = this.outputRow(null, 0, this.probeBatch.getContainer(), this.recordsProcessed);
            }
            ++this.recordsProcessed;
        }
    }

    @Override
    public void changeToFinalProbeState() {
        this.probeState = this.joinType == JoinRelType.RIGHT || this.joinType == JoinRelType.FULL ? Probe.ProbeState.PROJECT_RIGHT : Probe.ProbeState.DONE;
    }

    public String toString() {
        return "HashJoinProbeTemplate[container=" + this.container + ", probeSchema=" + this.probeSchema + ", joinType=" + this.joinType + ", recordsToProcess=" + this.recordsToProcess + ", recordsProcessed=" + this.recordsProcessed + ", outputRecords=" + this.outputRecords + ", probeState=" + (Object)((Object)this.probeState) + ", unmatchedBuildIndexes=" + this.unmatchedBuildIndexes + "]";
    }
}

