/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.Map;
import org.apache.drill.exec.physical.impl.join.BatchSizePredictorImpl;
import org.apache.drill.exec.physical.impl.join.HashJoinMemoryCalculator;
import org.apache.drill.exec.physical.impl.join.HashTableSizeCalculator;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class HashTableSizeCalculatorConservativeImpl
implements HashTableSizeCalculator {
    public static final String TYPE = "CONSERVATIVE";
    public static final double HASHTABLE_DOUBLING_FACTOR = 2.0;
    private final int maxNumRecords;
    private final double hashTableDoublingFactor;

    public HashTableSizeCalculatorConservativeImpl(int maxNumRecords, double hashTableDoublingFactor) {
        this.maxNumRecords = maxNumRecords;
        this.hashTableDoublingFactor = hashTableDoublingFactor;
    }

    @Override
    public long calculateSize(HashJoinMemoryCalculator.PartitionStat partitionStat, Map<String, Long> keySizes, double loadFactor, double safetyFactor, double fragmentationFactor) {
        Preconditions.checkArgument(!keySizes.isEmpty());
        Preconditions.checkArgument(!partitionStat.isSpilled());
        Preconditions.checkArgument(partitionStat.getNumInMemoryRecords() > 0L);
        long numBuckets = (long)((double)partitionStat.getNumInMemoryRecords() * (1.0 / loadFactor));
        long numEntries = partitionStat.getNumInMemoryRecords();
        long numBatchHolders = (numEntries + (long)this.maxNumRecords - 1L) / (long)this.maxNumRecords;
        long hashTableSize = RecordBatchSizer.multiplyByFactors(BatchSizePredictorImpl.computeValueVectorSize(numBuckets, 4L), this.hashTableDoublingFactor);
        hashTableSize += numBatchHolders * 2L * 4L * (long)this.maxNumRecords;
        long numFullBatchHolders = numEntries % (long)this.maxNumRecords == 0L ? numBatchHolders : numBatchHolders - 1L;
        hashTableSize += numFullBatchHolders * HashTableSizeCalculatorConservativeImpl.computeVectorSizes(keySizes, this.maxNumRecords, safetyFactor);
        if (numFullBatchHolders != numBatchHolders) {
            long partialNumEntries = numEntries % (long)this.maxNumRecords;
            long partialSize = HashTableSizeCalculatorConservativeImpl.computeVectorSizes(keySizes, partialNumEntries, safetyFactor);
            hashTableSize += RecordBatchSizer.multiplyByFactors(partialSize, this.hashTableDoublingFactor);
        }
        return RecordBatchSizer.multiplyByFactors(hashTableSize, fragmentationFactor);
    }

    @Override
    public double getDoublingFactor() {
        return this.hashTableDoublingFactor;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static long computeVectorSizes(Map<String, Long> vectorSizes, long numRecords, double safetyFactor) {
        long totalKeySize = 0L;
        for (Map.Entry<String, Long> entry : vectorSizes.entrySet()) {
            totalKeySize += BatchSizePredictorImpl.computeValueVectorSize(numRecords, entry.getValue(), safetyFactor);
        }
        return totalKeySize;
    }
}

