/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import com.carrotsearch.hppc.IntArrayList;
import java.util.ArrayList;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.common.HashPartition;
import org.apache.drill.exec.physical.impl.join.AbstractHashBinaryRecordBatch;
import org.apache.drill.exec.physical.impl.join.Probe;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.ValueVector;

public abstract class ProbeTemplate<T extends PhysicalOperator>
implements Probe {
    protected VectorContainer container;
    protected RecordBatch probeBatch;
    protected BatchSchema probeSchema;
    protected int recordsToProcess;
    protected int recordsProcessed;
    protected int outputRecords;
    protected boolean getNextRecord = true;
    protected int currentCompositeIdx = -1;
    protected Probe.ProbeState probeState = Probe.ProbeState.PROBE_PROJECT;
    protected IntArrayList unmatchedBuildIndexes;
    protected HashPartition[] partitions;
    protected HashPartition currPartition;
    protected int currRightPartition;
    IntVector read_left_HV_vector;
    protected int cycleNum;
    protected AbstractHashBinaryRecordBatch.SpilledPartition[] spilledInners;
    protected boolean buildSideIsEmpty = true;
    protected int numPartitions = 1;
    protected int partitionMask;
    protected int bitsInMask;
    protected int numberOfBuildSideColumns;
    protected int targetOutputRecords;
    protected AbstractHashBinaryRecordBatch<T> outgoingBatch;

    protected void setup(RecordBatch probeBatch, RecordBatch.IterOutcome leftStartState, HashPartition[] partitions, int cycleNum, VectorContainer container, AbstractHashBinaryRecordBatch.SpilledPartition[] spilledInners, boolean buildSideIsEmpty, int numPartitions) throws SchemaChangeException {
        this.container = container;
        this.spilledInners = spilledInners;
        this.probeBatch = probeBatch;
        this.probeSchema = probeBatch.getSchema();
        this.partitions = partitions;
        this.cycleNum = cycleNum;
        this.buildSideIsEmpty = buildSideIsEmpty;
        this.numPartitions = numPartitions;
        this.partitionMask = numPartitions - 1;
        this.bitsInMask = Integer.bitCount(this.partitionMask);
        this.probeState = Probe.ProbeState.PROBE_PROJECT;
        this.recordsToProcess = 0;
        this.recordsProcessed = 0;
        if (leftStartState == RecordBatch.IterOutcome.NONE) {
            this.changeToFinalProbeState();
        } else {
            this.recordsToProcess = probeBatch.getRecordCount();
        }
        for (HashPartition partn : this.partitions) {
            partn.allocateNewCurrentBatchAndHV();
        }
        if (this.cycleNum == 0 && partitions.length > 0 && partitions[0].getPartitionBatchesCount() == 0) {
            partitions[0].updateBatches();
        }
        this.currRightPartition = 0;
        if (this.cycleNum > 0) {
            if (this.read_left_HV_vector != null) {
                this.read_left_HV_vector.clear();
            }
            if (leftStartState != RecordBatch.IterOutcome.NONE) {
                this.read_left_HV_vector = (IntVector)probeBatch.getContainer().getLast();
            }
        }
    }

    @Override
    public void setTargetOutputCount(int targetOutputRecords) {
        this.targetOutputRecords = targetOutputRecords;
    }

    @Override
    public int getOutputCount() {
        return this.outputRecords;
    }

    private void appendBuild(VectorContainer buildSrcContainer, int buildSrcIndex) {
        for (int vectorIndex = 0; vectorIndex < this.numberOfBuildSideColumns; ++vectorIndex) {
            Object destVector = this.container.getValueVector(vectorIndex).getValueVector();
            Object srcVector = buildSrcContainer.getValueVector(vectorIndex).getValueVector();
            destVector.copyEntry(this.container.getRecordCount(), (ValueVector)srcVector, buildSrcIndex);
        }
    }

    private void appendProbe(VectorContainer probeSrcContainer, int probeSrcIndex) {
        for (int vectorIndex = this.numberOfBuildSideColumns; vectorIndex < this.container.getNumberOfColumns(); ++vectorIndex) {
            Object destVector = this.container.getValueVector(vectorIndex).getValueVector();
            Object srcVector = probeSrcContainer.getValueVector(vectorIndex - this.numberOfBuildSideColumns).getValueVector();
            destVector.copyEntry(this.container.getRecordCount(), (ValueVector)srcVector, probeSrcIndex);
        }
    }

    protected int outputRow(ArrayList<VectorContainer> buildSrcContainers, int compositeBuildSrcIndex, VectorContainer probeSrcContainer, int probeSrcIndex) {
        if (buildSrcContainers != null) {
            int buildBatchIndex = compositeBuildSrcIndex >>> 16;
            int buildOffset = compositeBuildSrcIndex & 0xFFFF;
            this.appendBuild(buildSrcContainers.get(buildBatchIndex), buildOffset);
        }
        if (probeSrcContainer != null) {
            this.appendProbe(probeSrcContainer, probeSrcIndex);
        }
        return this.container.incRecordCount();
    }

    protected void executeProjectRightPhase(int currBuildPart) {
        while (this.outputRecords < this.targetOutputRecords && this.recordsProcessed < this.recordsToProcess) {
            this.outputRecords = this.outputRow(this.partitions[currBuildPart].getContainers(), this.unmatchedBuildIndexes.get(this.recordsProcessed), null, 0);
            ++this.recordsProcessed;
        }
    }

    private void executeProbePhase() throws SchemaChangeException {
        block5: while (this.outputRecords < this.targetOutputRecords && this.probeState != Probe.ProbeState.DONE && this.probeState != Probe.ProbeState.PROJECT_RIGHT) {
            if (this.recordsProcessed == this.recordsToProcess) {
                for (HashPartition[] wrapper : this.probeBatch) {
                    wrapper.getValueVector().clear();
                }
                RecordBatch.IterOutcome leftUpstream = this.outgoingBatch.next(0, this.probeBatch);
                switch (leftUpstream) {
                    case NONE: 
                    case NOT_YET: {
                        this.recordsProcessed = 0;
                        this.recordsToProcess = 0;
                        this.changeToFinalProbeState();
                        for (HashPartition partn : this.partitions) {
                            if (!partn.isSpilled()) continue;
                            partn.completeAnOuterBatch(false);
                            AbstractHashBinaryRecordBatch.SpilledPartition sp = this.spilledInners[partn.getPartitionNum()];
                            sp.updateOuter(partn.getPartitionBatchesCount(), partn.getSpillFile());
                            partn.closeWriter();
                        }
                        continue block5;
                    }
                    case OK_NEW_SCHEMA: {
                        if (this.probeBatch.getSchema().equals(this.probeSchema)) {
                            for (HashPartition partn : this.partitions) {
                                partn.updateBatches();
                            }
                        } else {
                            throw SchemaChangeException.schemaChanged(this.getClass().getSimpleName() + " does not support schema changes in probe side.", this.probeSchema, this.probeBatch.getSchema());
                        }
                    }
                    case OK: {
                        this.outgoingBatch.getBatchMemoryManager().update(this.probeBatch, 0, this.outputRecords);
                        this.setTargetOutputCount(this.outgoingBatch.getBatchMemoryManager().getCurrentOutgoingMaxRowCount());
                        this.recordsToProcess = this.probeBatch.getRecordCount();
                        this.recordsProcessed = 0;
                        if (this.recordsToProcess == 0) continue block5;
                        if (this.cycleNum <= 0) break;
                        this.read_left_HV_vector = (IntVector)this.probeBatch.getContainer().getLast();
                        break;
                    }
                }
            }
            int probeIndex = -1;
            if (this.getNextRecord) {
                if (!this.buildSideIsEmpty) {
                    int hashCode = this.cycleNum == 0 ? this.partitions[0].getProbeHashCode(this.recordsProcessed) : this.read_left_HV_vector.getAccessor().get(this.recordsProcessed);
                    int currBuildPart = hashCode & this.partitionMask;
                    hashCode >>>= this.bitsInMask;
                    this.currPartition = this.partitions[currBuildPart];
                    if (this.outgoingBatch.isSpilledInner(currBuildPart)) {
                        this.currPartition.appendOuterRow(hashCode, this.recordsProcessed);
                        ++this.recordsProcessed;
                        continue;
                    }
                    probeIndex = this.currPartition.probeForKey(this.recordsProcessed, hashCode);
                }
                this.handleProbeResult(probeIndex);
                continue;
            }
            this.currPartition.setRecordMatched(this.currentCompositeIdx);
            this.outputRecords = this.outputRow(this.currPartition.getContainers(), this.currentCompositeIdx, this.probeBatch.getContainer(), this.recordsProcessed);
            this.currentCompositeIdx = this.currPartition.getNextIndex(this.currentCompositeIdx);
            if (this.currentCompositeIdx != -1) continue;
            this.getNextRecord = true;
            ++this.recordsProcessed;
        }
    }

    @Override
    public int probeAndProject() throws SchemaChangeException {
        this.outputRecords = 0;
        if (this.probeState == Probe.ProbeState.DONE) {
            return this.outputRecords;
        }
        if (this.probeState == Probe.ProbeState.PROBE_PROJECT) {
            this.executeProbePhase();
        }
        if (this.probeState == Probe.ProbeState.PROJECT_RIGHT) {
            do {
                if (this.unmatchedBuildIndexes == null) {
                    if (this.buildSideIsEmpty) {
                        return this.outputRecords;
                    }
                    this.unmatchedBuildIndexes = this.partitions[this.currRightPartition].getNextUnmatchedIndex();
                    this.recordsProcessed = 0;
                    this.recordsToProcess = this.unmatchedBuildIndexes.size();
                }
                this.executeProjectRightPhase(this.currRightPartition);
                if (this.recordsProcessed < this.recordsToProcess) {
                    return this.outputRecords;
                }
                ++this.currRightPartition;
                this.unmatchedBuildIndexes = null;
            } while (this.currRightPartition < this.numPartitions);
            this.probeState = Probe.ProbeState.DONE;
        }
        return this.outputRecords;
    }

    protected abstract void handleProbeResult(int var1);
}

