/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.RowKeyJoinPOP;
import org.apache.drill.exec.physical.impl.join.RowKeyJoin;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowKeyJoinBatch
extends AbstractRecordBatch<RowKeyJoinPOP>
implements RowKeyJoin {
    private static final Logger logger = LoggerFactory.getLogger(RowKeyJoinBatch.class);
    private final RecordBatch left;
    private final RecordBatch right;
    private boolean hasRowKeyBatch;
    private RecordBatch.IterOutcome leftUpstream = RecordBatch.IterOutcome.NONE;
    private RecordBatch.IterOutcome rightUpstream = RecordBatch.IterOutcome.NONE;
    private final List<TransferPair> transfers = Lists.newArrayList();
    private int recordCount;
    private final SchemaChangeCallBack callBack = new SchemaChangeCallBack();
    private RowKeyJoin.RowKeyJoinState rkJoinState = RowKeyJoin.RowKeyJoinState.INITIAL;

    public RowKeyJoinBatch(RowKeyJoinPOP config, FragmentContext context, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(config, context, true);
        this.left = left;
        this.right = right;
        this.hasRowKeyBatch = false;
    }

    @Override
    public int getRecordCount() {
        if (this.state == AbstractRecordBatch.BatchState.DONE) {
            return 0;
        }
        return this.recordCount;
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException("RowKeyJoinBatch does not support selection vector");
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException("RowKeyJoinBatch does not support selection vector");
    }

    @Override
    protected void buildSchema() {
        this.container.clear();
        this.rightUpstream = this.next(this.right);
        if (this.right.getRecordCount() > 0) {
            this.hasRowKeyBatch = true;
        }
        this.leftUpstream = this.next(this.left);
        for (VectorWrapper v : this.left) {
            TransferPair pair = v.getValueVector().makeTransferPair((ValueVector)this.container.addOrGet(v.getField(), this.callBack));
            this.transfers.add(pair);
        }
        this.container.buildSchema(this.left.getSchema().getSelectionVectorMode());
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.state == AbstractRecordBatch.BatchState.DONE) {
            return RecordBatch.IterOutcome.NONE;
        }
        try {
            if (this.state == AbstractRecordBatch.BatchState.FIRST && this.left.getRecordCount() > 0) {
                logger.debug("First batch, outputting the batch with {} records.", (Object)this.left.getRecordCount());
                this.outputCurrentLeftBatch();
                if (this.callBack.getSchemaChangedAndReset()) {
                    RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                    return iterOutcome;
                }
                RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK;
                return iterOutcome;
            }
            if (this.rightUpstream == RecordBatch.IterOutcome.NONE) {
                this.rkJoinState = RowKeyJoin.RowKeyJoinState.DONE;
                this.state = AbstractRecordBatch.BatchState.DONE;
                RecordBatch.IterOutcome iterOutcome = this.rightUpstream;
                return iterOutcome;
            }
            this.rightUpstream = this.next(this.right);
            logger.debug("right input IterOutcome: {}", (Object)this.rightUpstream);
            switch (this.rightUpstream) {
                case NONE: {
                    this.rkJoinState = RowKeyJoin.RowKeyJoinState.DONE;
                    this.state = AbstractRecordBatch.BatchState.DONE;
                    RecordBatch.IterOutcome iterOutcome = this.rightUpstream;
                    return iterOutcome;
                }
                case OK_NEW_SCHEMA: 
                case OK: {
                    while ((this.rightUpstream == RecordBatch.IterOutcome.OK || this.rightUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA) && this.right.getRecordCount() == 0) {
                        this.rightUpstream = this.next(this.right);
                        logger.trace("rowkeyjoin loop when recordCount == 0. rightUpstream {}", (Object)this.rightUpstream);
                    }
                    if (!this.hasRowKeyBatch && this.right.getRecordCount() > 0) {
                        this.hasRowKeyBatch = true;
                    }
                    logger.debug("right input num records = {}", (Object)this.right.getRecordCount());
                    if (this.hasRowKeyBatch) {
                        this.leftUpstream = this.next(this.left);
                        logger.debug("left input IterOutcome: {}", (Object)this.leftUpstream);
                        if (this.leftUpstream == RecordBatch.IterOutcome.OK || this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                            logger.debug("left input num records = {}", (Object)this.left.getRecordCount());
                            if (this.left.getRecordCount() > 0) {
                                logger.debug("Outputting the left batch with {} records.", (Object)this.left.getRecordCount());
                                this.outputCurrentLeftBatch();
                                if (this.callBack.getSchemaChangedAndReset()) {
                                    RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                                    return iterOutcome;
                                }
                            }
                        }
                    }
                    if (this.leftUpstream == RecordBatch.IterOutcome.NONE) {
                        this.container.setRecordCount(0);
                        this.recordCount = 0;
                        RecordBatch.IterOutcome iterOutcome = this.rightUpstream;
                        return iterOutcome;
                    }
                    RecordBatch.IterOutcome iterOutcome = this.leftUpstream;
                    return iterOutcome;
                }
            }
            throw new IllegalStateException(String.format("Unknown state %s.", new Object[]{this.rightUpstream}));
        }
        finally {
            if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                this.state = AbstractRecordBatch.BatchState.NOT_FIRST;
            }
            if (this.leftUpstream == RecordBatch.IterOutcome.NONE && this.rkJoinState == RowKeyJoin.RowKeyJoinState.PROCESSING) {
                this.rkJoinState = RowKeyJoin.RowKeyJoinState.INITIAL;
            }
        }
    }

    private void outputCurrentLeftBatch() {
        if (this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA && this.state == AbstractRecordBatch.BatchState.FIRST || this.state == AbstractRecordBatch.BatchState.NOT_FIRST) {
            this.container.zeroVectors();
            this.transfers.clear();
            for (VectorWrapper v : this.left) {
                TransferPair pair = v.getValueVector().makeTransferPair((ValueVector)this.container.addOrGet(v.getField(), this.callBack));
                this.transfers.add(pair);
            }
            if (this.container.isSchemaChanged()) {
                this.container.buildSchema(this.left.getSchema().getSelectionVectorMode());
            }
        }
        for (TransferPair t : this.transfers) {
            t.transfer();
        }
        this.container.setRecordCount(this.left.getRecordCount());
        this.recordCount = this.left.getRecordCount();
    }

    @Override
    public boolean hasRowKeyBatch() {
        return this.hasRowKeyBatch;
    }

    @Override
    public Pair<ValueVector, Integer> nextRowKeyBatch() {
        if (this.hasRowKeyBatch && this.right.getRecordCount() > 0) {
            this.hasRowKeyBatch = false;
            VectorWrapper vw = (VectorWrapper)Iterables.get(this.right, 0);
            Object vv = vw.getValueVector();
            return Pair.of(vv, (Object)(this.right.getRecordCount() - 1));
        }
        return null;
    }

    @Override
    public AbstractRecordBatch.BatchState getBatchState() {
        return this.state;
    }

    @Override
    public void setBatchState(AbstractRecordBatch.BatchState newState) {
        this.state = newState;
    }

    @Override
    public void setRowKeyJoinState(RowKeyJoin.RowKeyJoinState newState) {
        this.rkJoinState = newState;
    }

    @Override
    public RowKeyJoin.RowKeyJoinState getRowKeyJoinState() {
        return this.rkJoinState;
    }

    @Override
    protected void cancelIncoming() {
        this.left.cancel();
        this.right.cancel();
    }

    @Override
    public void close() {
        this.rkJoinState = RowKeyJoin.RowKeyJoinState.DONE;
        super.close();
    }

    @Override
    public void dump() {
        logger.error("RowKeyJoinBatch[container={}, left={}, right={}, hasRowKeyBatch={}, rkJoinState={}]", new Object[]{this.container, this.left, this.right, this.hasRowKeyBatch, this.rkJoinState});
    }
}

