/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.limit;

import java.util.List;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.PartitionLimit;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionLimitRecordBatch
extends AbstractSingleRecordBatch<PartitionLimit> {
    private static final Logger logger = LoggerFactory.getLogger(PartitionLimitRecordBatch.class);
    private final SelectionVector2 outgoingSv;
    private SelectionVector2 incomingSv;
    private int recordStartOffset;
    private int numberOfRecords;
    private final List<TransferPair> transfers = Lists.newArrayList();
    private int partitionId;
    private IntVector partitionColumn;

    public PartitionLimitRecordBatch(PartitionLimit popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context, incoming);
        this.outgoingSv = new SelectionVector2(this.oContext.getAllocator());
        this.refreshLimitState();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        return this.outgoingSv;
    }

    @Override
    public int getRecordCount() {
        return this.outgoingSv.getCount();
    }

    @Override
    public void close() {
        this.outgoingSv.clear();
        this.transfers.clear();
        super.close();
    }

    @Override
    protected boolean setupNewSchema() {
        this.container.clear();
        this.transfers.clear();
        for (VectorWrapper v : this.incoming) {
            TransferPair pair = v.getValueVector().makeTransferPair((ValueVector)this.container.addOrGet(v.getField(), this.callBack));
            this.transfers.add(pair);
            String fieldName = v.getField().getName();
            if (!fieldName.equals(((PartitionLimit)this.popConfig).getPartitionColumn())) continue;
            this.partitionColumn = (IntVector)pair.getTo();
        }
        BatchSchema.SelectionVectorMode svMode = this.incoming.getSchema().getSelectionVectorMode();
        switch (svMode) {
            case NONE: {
                break;
            }
            case TWO_BYTE: {
                this.incomingSv = this.incoming.getSelectionVector2();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.container.isSchemaChanged()) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.TWO_BYTE);
            return true;
        }
        return false;
    }

    @Override
    protected RecordBatch.IterOutcome getFinalOutcome(boolean hasRemainder) {
        RecordBatch.IterOutcome outcomeToReturn = super.getFinalOutcome(hasRemainder);
        if (outcomeToReturn == RecordBatch.IterOutcome.EMIT) {
            this.refreshLimitState();
        }
        return outcomeToReturn;
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        int inputRecordCount = this.incoming.getRecordCount();
        if (inputRecordCount == 0) {
            this.incoming.getContainer().zeroVectors();
            this.outgoingSv.setRecordCount(0);
            this.outgoingSv.setBatchActualRecordCount(0);
            this.container.setEmpty();
            if (this.incomingSv != null) {
                this.incomingSv.clear();
            }
            return this.getFinalOutcome(false);
        }
        for (TransferPair tp : this.transfers) {
            tp.transfer();
        }
        this.outgoingSv.allocateNew(inputRecordCount);
        this.limit(inputRecordCount);
        if (this.incomingSv != null) {
            this.incomingSv.clear();
        }
        return this.getFinalOutcome(false);
    }

    private void limit(int inputRecordCount) {
        boolean outputAllRecords = this.numberOfRecords == Integer.MIN_VALUE;
        int svIndex = 0;
        this.partitionId = this.partitionId == -1 ? this.getCurrentRowId(0) : this.partitionId;
        int i = 0;
        while (i < inputRecordCount) {
            int currentRowId = this.getCurrentRowId(i);
            if (this.partitionId == currentRowId) {
                if (this.recordStartOffset > 0) {
                    --this.recordStartOffset;
                    ++i;
                    continue;
                }
                if (outputAllRecords) {
                    this.updateOutputSV2(svIndex++, i);
                } else if (this.numberOfRecords > 0) {
                    this.updateOutputSV2(svIndex++, i);
                    --this.numberOfRecords;
                }
                ++i;
                continue;
            }
            this.refreshConfigParameter();
            this.partitionId = currentRowId;
        }
        this.setOutgoingRecordCount(inputRecordCount, svIndex);
    }

    private void updateOutputSV2(int svIndex, int incomingIndex) {
        if (this.incomingSv != null) {
            this.outgoingSv.setIndex(svIndex, this.incomingSv.getIndex(incomingIndex));
        } else {
            this.outgoingSv.setIndex(svIndex, (char)incomingIndex);
        }
    }

    private int getCurrentRowId(int incomingIndex) {
        if (this.incomingSv != null) {
            return this.partitionColumn.getAccessor().get(this.incomingSv.getIndex(incomingIndex));
        }
        return this.partitionColumn.getAccessor().get(incomingIndex);
    }

    private void setOutgoingRecordCount(int inputRecordCount, int outputCount) {
        this.outgoingSv.setRecordCount(outputCount);
        int inputValueCount = this.incoming.getContainer().getRecordCount();
        this.container.setRecordCount(inputValueCount);
        this.outgoingSv.setBatchActualRecordCount(inputValueCount);
    }

    private void refreshLimitState() {
        this.refreshConfigParameter();
        this.partitionId = -1;
    }

    private void refreshConfigParameter() {
        this.recordStartOffset = Math.max(0, ((PartitionLimit)this.popConfig).getFirst());
        this.numberOfRecords = ((PartitionLimit)this.popConfig).getLast() == null ? Integer.MIN_VALUE : Math.max(0, ((PartitionLimit)this.popConfig).getLast()) - this.recordStartOffset;
    }

    @Override
    public void dump() {
        logger.error("PartitionLimitRecordBatch[container={}, popConfig={}, incomingSV={}, outgoingSV={}, recordStartOffset={}, numberOfRecords={}, partitionId={}, unionTypeEnabled={}, state={}]", new Object[]{this.container, this.popConfig, this.incomingSv, this.outgoingSv, this.recordStartOffset, this.numberOfRecords, this.partitionId, this.unionTypeEnabled, this.state});
    }
}

