/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.materialize;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.impl.ScreenCreator;
import org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import org.apache.drill.exec.physical.impl.materialize.RecordMaterializer;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;

public interface QueryDataPackage {
    public UserBitShared.QueryId queryId();

    public QueryWritableBatch toWritableBatch();

    public VectorContainer batch();

    public List<UserBitShared.SerializedField> fields();

    public static class DataPackage
    implements QueryDataPackage {
        private final RecordMaterializer materializer;
        private final OperatorStats stats;

        public DataPackage(RecordMaterializer materializer, OperatorStats stats) {
            this.materializer = materializer;
            this.stats = stats;
        }

        @Override
        public UserBitShared.QueryId queryId() {
            return this.materializer.queryId();
        }

        @Override
        public QueryWritableBatch toWritableBatch() {
            QueryWritableBatch batch = this.materializer.convertNext();
            this.stats.addLongStat(ScreenCreator.ScreenRoot.Metric.BYTES_SENT, batch.getByteCount());
            return batch;
        }

        @Override
        public VectorContainer batch() {
            return this.materializer.incoming();
        }

        @Override
        public List<UserBitShared.SerializedField> fields() {
            ArrayList<UserBitShared.SerializedField> metadata = new ArrayList<UserBitShared.SerializedField>();
            for (VectorWrapper<?> vw : this.batch()) {
                metadata.add(vw.getValueVector().getMetadata());
            }
            return metadata;
        }
    }

    public static class EmptyResultsPackage
    implements QueryDataPackage {
        private final UserBitShared.QueryId queryId;

        public EmptyResultsPackage(UserBitShared.QueryId queryId) {
            this.queryId = queryId;
        }

        @Override
        public UserBitShared.QueryId queryId() {
            return this.queryId;
        }

        @Override
        public QueryWritableBatch toWritableBatch() {
            UserBitShared.QueryData header = UserBitShared.QueryData.newBuilder().setQueryId(this.queryId).setRowCount(0).setDef(UserBitShared.RecordBatchDef.getDefaultInstance()).build();
            return new QueryWritableBatch(header, new ByteBuf[0]);
        }

        @Override
        public VectorContainer batch() {
            return null;
        }

        @Override
        public List<UserBitShared.SerializedField> fields() {
            return Collections.emptyList();
        }
    }
}

