/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.materialize;

import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import org.apache.drill.exec.physical.impl.materialize.RecordMaterializer;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.server.options.OptionManager;

public class VectorRecordMaterializer
implements RecordMaterializer {
    private final UserBitShared.QueryId queryId;
    private final RecordBatch batch;
    private final BufferAllocator allocator;
    private final boolean resultResultsForDDL;

    public VectorRecordMaterializer(FragmentContext context, OperatorContext oContext, RecordBatch batch) {
        this.queryId = context.getHandle().getQueryId();
        this.batch = batch;
        this.allocator = oContext.getAllocator();
        BatchSchema schema = batch.getSchema();
        assert (schema != null) : "Schema must be defined.";
        OptionManager options = context.getOptions();
        this.resultResultsForDDL = options.getBoolean("exec.query.return_result_set_for_ddl");
    }

    @Override
    public QueryWritableBatch convertNext() {
        WritableBatch w = this.batch.getWritableBatch().transfer(this.allocator);
        UserBitShared.QueryData.Builder builder = UserBitShared.QueryData.newBuilder().setQueryId(this.queryId).setRowCount(this.batch.getRecordCount()).setDef(w.getDef());
        if (!this.resultResultsForDDL) {
            int count = w.getDef().getAffectedRowsCount();
            builder.setAffectedRowsCount(count == -1 ? 0 : count);
        }
        return new QueryWritableBatch(builder.build(), w.getBuffers());
    }

    @Override
    public UserBitShared.QueryId queryId() {
        return this.queryId;
    }

    @Override
    public VectorContainer incoming() {
        return this.batch.getContainer();
    }
}

