/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.NullExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.metastore.analyze.AnalyzeColumnUtils;
import org.apache.drill.exec.metastore.analyze.MetadataAggregateContext;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class MetadataAggregateHelper {
    private final List<NamedExpression> valueExpressions;
    private final MetadataAggregateContext context;
    private final ColumnNamesOptions columnNamesOptions;
    private final BatchSchema schema;
    private final AggPrelBase.OperatorPhase phase;
    private final List<SchemaPath> excludedColumns;

    public MetadataAggregateHelper(MetadataAggregateContext context, ColumnNamesOptions columnNamesOptions, BatchSchema schema, AggPrelBase.OperatorPhase phase) {
        this.context = context;
        this.columnNamesOptions = columnNamesOptions;
        this.schema = schema;
        this.phase = phase;
        this.valueExpressions = new ArrayList<NamedExpression>();
        this.excludedColumns = new ArrayList<SchemaPath>(context.metadataColumns());
        this.excludedColumns.add(SchemaPath.getSimplePath(columnNamesOptions.projectMetadataColumn()));
        this.createAggregatorInternal();
    }

    public List<NamedExpression> getValueExpressions() {
        return this.valueExpressions;
    }

    private void createAggregatorInternal() {
        this.getUnflattenedFileds(Lists.newArrayList(this.schema), null).forEach((fieldName, fieldRef) -> this.addColumnAggregateCalls((FieldReference)fieldRef, (String)fieldName));
        ArrayList<LogicalExpression> fieldsList = new ArrayList<LogicalExpression>();
        StreamSupport.stream(this.schema.spliterator(), false).map(MaterializedField::getName).filter(field -> !this.excludedColumns.contains(FieldReference.getWithQuotedRef(field))).forEach(filedName -> {
            fieldsList.add(ValueExpressions.getChar(filedName, DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getDefaultPrecision(SqlTypeName.VARCHAR)));
            fieldsList.add(FieldReference.getWithQuotedRef(filedName));
        });
        if (this.createNewAggregations()) {
            this.addMetadataAggregateCalls();
            this.addSchemaCall(fieldsList);
            if (this.context.metadataLevel() == MetadataType.SEGMENT) {
                this.addLocationAggCall(this.columnNamesOptions.fullyQualifiedName());
            }
        } else {
            if (!this.context.createNewAggregations()) {
                this.addCollectListCall(fieldsList);
            }
            this.addMergeSchemaCall();
            if (this.context.metadataLevel() == MetadataType.SEGMENT) {
                this.addParentLocationAggCall();
            }
        }
        for (SchemaPath metadataColumns : this.context.metadataColumns()) {
            if (!metadataColumns.equals(SchemaPath.getSimplePath(this.columnNamesOptions.rowGroupStart())) && !metadataColumns.equals(SchemaPath.getSimplePath(this.columnNamesOptions.rowGroupLength()))) continue;
            FunctionCall anyValueCall = new FunctionCall("any_value", Collections.singletonList(FieldReference.getWithQuotedRef(metadataColumns.getRootSegmentPath())), ExpressionPosition.UNKNOWN);
            this.valueExpressions.add(new NamedExpression(anyValueCall, FieldReference.getWithQuotedRef(metadataColumns.getRootSegmentPath())));
        }
        this.addLastModifiedCall();
    }

    private void addParentLocationAggCall() {
        this.valueExpressions.add(new NamedExpression(new FunctionCall("any_value", Collections.singletonList(new FunctionCall("parentPath", Collections.singletonList(SchemaPath.getSimplePath("location")), ExpressionPosition.UNKNOWN)), ExpressionPosition.UNKNOWN), FieldReference.getWithQuotedRef("location")));
    }

    private void addLocationAggCall(String locationField) {
        this.valueExpressions.add(new NamedExpression(new FunctionCall("any_value", Collections.singletonList(SchemaPath.getSimplePath(locationField)), ExpressionPosition.UNKNOWN), FieldReference.getWithQuotedRef("location")));
    }

    private boolean createNewAggregations() {
        return this.context.createNewAggregations() && (this.phase == AggPrelBase.OperatorPhase.PHASE_1of2 || this.phase == AggPrelBase.OperatorPhase.PHASE_1of1);
    }

    private void addLastModifiedCall() {
        String lastModifiedColumn = this.columnNamesOptions.lastModifiedTime();
        FunctionCall lastModifiedTime = this.context.metadataLevel().includes(MetadataType.FILE) ? new FunctionCall("any_value", Collections.singletonList(FieldReference.getWithQuotedRef(lastModifiedColumn)), ExpressionPosition.UNKNOWN) : new FunctionCall("max", Collections.singletonList(FieldReference.getWithQuotedRef(lastModifiedColumn)), ExpressionPosition.UNKNOWN);
        this.valueExpressions.add(new NamedExpression(lastModifiedTime, FieldReference.getWithQuotedRef(lastModifiedColumn)));
    }

    private void addCollectListCall(List<LogicalExpression> fieldList) {
        ArrayList<LogicalExpression> collectListArguments = new ArrayList<LogicalExpression>(fieldList);
        for (SchemaPath logicalExpressions : this.context.metadataColumns()) {
            collectListArguments.add(ValueExpressions.getChar(logicalExpressions.getRootSegmentPath(), DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getDefaultPrecision(SqlTypeName.VARCHAR)));
            collectListArguments.add(FieldReference.getWithQuotedRef(logicalExpressions.getRootSegmentPath()));
        }
        FunctionCall collectList = new FunctionCall("collect_list", collectListArguments, ExpressionPosition.UNKNOWN);
        this.valueExpressions.add(new NamedExpression(collectList, FieldReference.getWithQuotedRef("collectedMap")));
    }

    private void addMergeSchemaCall() {
        FunctionCall schemaExpr = new FunctionCall("merge_schema", Collections.singletonList(FieldReference.getWithQuotedRef("schema")), ExpressionPosition.UNKNOWN);
        this.valueExpressions.add(new NamedExpression(schemaExpr, FieldReference.getWithQuotedRef("schema")));
    }

    private void addSchemaCall(List<LogicalExpression> fieldsList) {
        FunctionCall schemaExpr = new FunctionCall("schema", fieldsList, ExpressionPosition.UNKNOWN);
        this.valueExpressions.add(new NamedExpression(schemaExpr, FieldReference.getWithQuotedRef("schema")));
    }

    private void addMetadataAggregateCalls() {
        AnalyzeColumnUtils.META_STATISTICS_FUNCTIONS.forEach((statisticsKind, sqlKind) -> {
            IfExpression caseExpr = IfExpression.newBuilder().setIfCondition(new IfExpression.IfCondition(new FunctionCall("isnull", Collections.singletonList(FieldReference.getWithQuotedRef(this.columnNamesOptions.projectMetadataColumn())), ExpressionPosition.UNKNOWN), ValueExpressions.getBigInt(1L))).setElse(NullExpression.INSTANCE).build();
            FunctionCall call = new FunctionCall(sqlKind.name(), Collections.singletonList(caseExpr), ExpressionPosition.UNKNOWN);
            this.valueExpressions.add(new NamedExpression(call, FieldReference.getWithQuotedRef(AnalyzeColumnUtils.getMetadataStatisticsFieldName(statisticsKind))));
        });
    }

    private Map<String, FieldReference> getUnflattenedFileds(Collection<MaterializedField> fields, List<String> parentFields) {
        HashMap<String, FieldReference> fieldNameRefMap = new HashMap<String, FieldReference>();
        for (MaterializedField field : fields) {
            List<String> currentPath;
            if (field.getType().getMode() == TypeProtos.DataMode.REPEATED || parentFields == null && this.excludedColumns.contains(SchemaPath.getSimplePath(field.getName()))) continue;
            if (parentFields == null) {
                currentPath = Collections.singletonList(field.getName());
            } else {
                currentPath = new ArrayList<String>(parentFields);
                currentPath.add(field.getName());
            }
            if (field.getType().getMinorType() == TypeProtos.MinorType.MAP && this.createNewAggregations()) {
                fieldNameRefMap.putAll(this.getUnflattenedFileds(field.getChildren(), currentPath));
                continue;
            }
            SchemaPath schemaPath = SchemaPath.getCompoundPath(currentPath.toArray(new String[0]));
            String name = this.createNewAggregations() ? schemaPath.toExpr() : schemaPath.getRootSegmentPath();
            fieldNameRefMap.put(name, new FieldReference(schemaPath));
        }
        return fieldNameRefMap;
    }

    private void addColumnAggregateCalls(FieldReference fieldRef, String fieldName) {
        List<SchemaPath> interestingColumns = this.context.interestingColumns();
        if (this.createNewAggregations()) {
            if (interestingColumns == null || interestingColumns.contains(fieldRef)) {
                AnalyzeColumnUtils.COLUMN_STATISTICS_FUNCTIONS.forEach((statisticsKind, sqlKind) -> {
                    IfExpression caseExpr = IfExpression.newBuilder().setIfCondition(new IfExpression.IfCondition(new FunctionCall("isnull", Collections.singletonList(FieldReference.getWithQuotedRef(this.columnNamesOptions.projectMetadataColumn())), ExpressionPosition.UNKNOWN), fieldRef)).setElse(NullExpression.INSTANCE).build();
                    FunctionCall call = new FunctionCall(sqlKind.name(), Collections.singletonList(caseExpr), ExpressionPosition.UNKNOWN);
                    this.valueExpressions.add(new NamedExpression(call, FieldReference.getWithQuotedRef(AnalyzeColumnUtils.getColumnStatisticsFieldName(fieldName, statisticsKind))));
                });
            }
        } else if (AnalyzeColumnUtils.isColumnStatisticsField(fieldName) || AnalyzeColumnUtils.isMetadataStatisticsField(fieldName)) {
            SqlKind function = AnalyzeColumnUtils.COLUMN_STATISTICS_FUNCTIONS.get(AnalyzeColumnUtils.getStatisticsKind(fieldName));
            if (function == SqlKind.COUNT) {
                function = SqlKind.SUM;
            }
            FunctionCall functionCall = new FunctionCall(function.name(), Collections.singletonList(fieldRef), ExpressionPosition.UNKNOWN);
            this.valueExpressions.add(new NamedExpression(functionCall, fieldRef));
        }
    }
}

