/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.metastore.analyze.AnalyzeColumnUtils;
import org.apache.drill.exec.metastore.analyze.MetadataIdentifierUtils;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.MetadataHandlerPOP;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetOptionBuilder;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSetReader;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.StatisticsKind;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataHandlerBatch
extends AbstractSingleRecordBatch<MetadataHandlerPOP> {
    private static final Logger logger = LoggerFactory.getLogger(MetadataHandlerBatch.class);
    private final Tables tables;
    private final MetadataType metadataType;
    private final Map<String, MetadataInfo> metadataToHandle;
    private final ColumnNamesOptions columnNamesOptions;
    private boolean firstBatch = true;

    protected MetadataHandlerBatch(MetadataHandlerPOP popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context, incoming);
        this.tables = context.getMetastoreRegistry().get().tables();
        this.metadataType = popConfig.getContext().metadataType();
        this.columnNamesOptions = new ColumnNamesOptions(context.getOptions());
        this.metadataToHandle = popConfig.getContext().metadataToHandle() != null ? popConfig.getContext().metadataToHandle().stream().collect(Collectors.toMap(MetadataInfo::identifier, Function.identity())) : null;
    }

    @Override
    public RecordBatch.IterOutcome doWork() {
        RecordBatch.IterOutcome outcome = this.incoming.getRecordCount() == 0 ? this.next(this.incoming) : this.getLastKnownOutcome();
        switch (outcome) {
            case NONE: {
                if (this.firstBatch) {
                    Preconditions.checkState(this.metadataToHandle.isEmpty(), "Incoming batch didn't return the result for modified segments");
                }
                return outcome;
            }
            case OK_NEW_SCHEMA: {
                if (this.firstBatch) {
                    this.firstBatch = false;
                    if (!this.setupNewSchema()) {
                        outcome = RecordBatch.IterOutcome.OK;
                    }
                }
            }
            case OK: {
                assert (!this.firstBatch) : "First batch should be OK_NEW_SCHEMA";
                this.doWorkInternal();
            }
            case NOT_YET: {
                return outcome;
            }
        }
        throw new UnsupportedOperationException("Unsupported upstream state " + (Object)((Object)outcome));
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        RecordBatch.IterOutcome outcome = this.getLastKnownOutcome();
        if (outcome != RecordBatch.IterOutcome.NONE) {
            outcome = super.innerNext();
        }
        if (outcome == RecordBatch.IterOutcome.NONE && !this.metadataToHandle.isEmpty()) {
            BasicTablesRequests basicTablesRequests = this.tables.basicRequests();
            switch (this.metadataType) {
                case ROW_GROUP: {
                    List<RowGroupMetadata> rowGroups = basicTablesRequests.rowGroupsMetadata(((MetadataHandlerPOP)this.popConfig).getContext().tableInfo(), new ArrayList<MetadataInfo>(this.metadataToHandle.values()));
                    return this.populateContainer(rowGroups);
                }
                case FILE: {
                    List<FileMetadata> files = basicTablesRequests.filesMetadata(((MetadataHandlerPOP)this.popConfig).getContext().tableInfo(), new ArrayList<MetadataInfo>(this.metadataToHandle.values()));
                    return this.populateContainer(files);
                }
                case SEGMENT: {
                    List<SegmentMetadata> segments = basicTablesRequests.segmentsMetadata(((MetadataHandlerPOP)this.popConfig).getContext().tableInfo(), new ArrayList<MetadataInfo>(this.metadataToHandle.values()));
                    return this.populateContainer(segments);
                }
            }
        }
        return outcome;
    }

    private <T extends BaseMetadata> RecordBatch.IterOutcome populateContainer(List<T> metadata) {
        VectorContainer populatedContainer;
        if (this.firstBatch) {
            populatedContainer = this.writeMetadata(metadata);
            this.setupSchemaFromContainer(populatedContainer);
        } else {
            populatedContainer = this.writeMetadataUsingBatchSchema(metadata);
        }
        this.container.transferIn(populatedContainer);
        this.container.setRecordCount(populatedContainer.getRecordCount());
        if (this.firstBatch) {
            this.firstBatch = false;
            return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        return RecordBatch.IterOutcome.OK;
    }

    private <T extends BaseMetadata> VectorContainer writeMetadata(List<T> metadataList) {
        BaseMetadata firstElement = (BaseMetadata)metadataList.iterator().next();
        ResultSetLoader resultSetLoader = this.getResultSetLoaderForMetadata(firstElement);
        resultSetLoader.startBatch();
        RowSetLoader rowWriter = resultSetLoader.writer();
        Iterator<T> segmentsIterator = metadataList.iterator();
        while (!rowWriter.isFull() && segmentsIterator.hasNext()) {
            BaseMetadata metadata = (BaseMetadata)segmentsIterator.next();
            this.metadataToHandle.remove(metadata.getMetadataInfo().identifier());
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(((LocationProvider)((Object)metadata)).getPath().toUri().getPath());
            Collections.addAll(arguments, Arrays.copyOf(MetadataIdentifierUtils.getValuesFromMetadataIdentifier(metadata.getMetadataInfo().identifier()), ((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().size()));
            metadata.getColumnsStatistics().entrySet().stream().sorted(Comparator.comparing(e -> ((SchemaPath)e.getKey()).toExpr())).map(Map.Entry::getValue).flatMap(columnStatistics -> AnalyzeColumnUtils.COLUMN_STATISTICS_FUNCTIONS.keySet().stream().map(columnStatistics::get)).forEach(arguments::add);
            AnalyzeColumnUtils.META_STATISTICS_FUNCTIONS.keySet().stream().map(metadata::getStatistic).forEach(arguments::add);
            arguments.add(new Object[0]);
            if (this.metadataType == MetadataType.SEGMENT) {
                arguments.add(((SegmentMetadata)metadata).getLocations().stream().map(path -> path.toUri().getPath()).toArray(String[]::new));
            }
            if (this.metadataType == MetadataType.ROW_GROUP) {
                arguments.add(String.valueOf(((RowGroupMetadata)metadata).getRowGroupIndex()));
                arguments.add(Long.toString((Long)metadata.getStatistic(() -> "start")));
                arguments.add(Long.toString((Long)metadata.getStatistic(() -> "length")));
            }
            arguments.add(metadata.getSchema().jsonString());
            arguments.add(String.valueOf(metadata.getLastModifiedTime()));
            arguments.add(this.metadataType.name());
            rowWriter.addRow(arguments.toArray());
        }
        return resultSetLoader.harvest();
    }

    private ResultSetLoader getResultSetLoaderForMetadata(BaseMetadata baseMetadata) {
        SchemaBuilder schemaBuilder = new SchemaBuilder().addNullable("location", TypeProtos.MinorType.VARCHAR);
        for (String string : ((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns()) {
            schemaBuilder.addNullable(string, TypeProtos.MinorType.VARCHAR);
        }
        baseMetadata.getColumnsStatistics().entrySet().stream().sorted(Comparator.comparing(e -> ((SchemaPath)e.getKey()).getRootSegmentPath())).forEach(entry -> {
            for (StatisticsKind<?> statisticsKind : AnalyzeColumnUtils.COLUMN_STATISTICS_FUNCTIONS.keySet()) {
                TypeProtos.MinorType type = AnalyzeColumnUtils.COLUMN_STATISTICS_TYPES.get(statisticsKind);
                type = type != null ? type : ((ColumnStatistics)entry.getValue()).getComparatorType();
                schemaBuilder.addNullable(AnalyzeColumnUtils.getColumnStatisticsFieldName(((SchemaPath)entry.getKey()).getRootSegmentPath(), statisticsKind), type);
            }
        });
        for (StatisticsKind statisticsKind : AnalyzeColumnUtils.META_STATISTICS_FUNCTIONS.keySet()) {
            schemaBuilder.addNullable(AnalyzeColumnUtils.getMetadataStatisticsFieldName(statisticsKind), AnalyzeColumnUtils.COLUMN_STATISTICS_TYPES.get(statisticsKind));
        }
        schemaBuilder.addMapArray("collectedMap").resumeSchema();
        if (this.metadataType == MetadataType.SEGMENT) {
            schemaBuilder.addArray("locations", TypeProtos.MinorType.VARCHAR);
        }
        if (this.metadataType == MetadataType.ROW_GROUP) {
            schemaBuilder.addNullable(this.columnNamesOptions.rowGroupIndex(), TypeProtos.MinorType.VARCHAR);
            schemaBuilder.addNullable(this.columnNamesOptions.rowGroupStart(), TypeProtos.MinorType.VARCHAR);
            schemaBuilder.addNullable(this.columnNamesOptions.rowGroupLength(), TypeProtos.MinorType.VARCHAR);
        }
        schemaBuilder.addNullable("schema", TypeProtos.MinorType.VARCHAR).addNullable(this.columnNamesOptions.lastModifiedTime(), TypeProtos.MinorType.VARCHAR).add("metadataType", TypeProtos.MinorType.VARCHAR);
        ResultSetLoaderImpl.ResultSetOptions options = new ResultSetOptionBuilder().readerSchema(schemaBuilder.buildSchema()).build();
        return new ResultSetLoaderImpl(this.container.getAllocator(), options);
    }

    private <T extends BaseMetadata> VectorContainer writeMetadataUsingBatchSchema(List<T> metadataList) {
        Preconditions.checkArgument(!metadataList.isEmpty(), "Metadata list shouldn't be empty.");
        ResultSetLoader resultSetLoader = this.getResultSetLoaderWithBatchSchema();
        resultSetLoader.startBatch();
        RowSetLoader rowWriter = resultSetLoader.writer();
        Iterator<T> segmentsIterator = metadataList.iterator();
        while (!rowWriter.isFull() && segmentsIterator.hasNext()) {
            BaseMetadata metadata = (BaseMetadata)segmentsIterator.next();
            this.metadataToHandle.remove(metadata.getMetadataInfo().identifier());
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (VectorWrapper<?> vectorWrapper : this.container) {
                String[] identifierValues = Arrays.copyOf(MetadataIdentifierUtils.getValuesFromMetadataIdentifier(metadata.getMetadataInfo().identifier()), ((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().size());
                MaterializedField field = vectorWrapper.getField();
                String fieldName = field.getName();
                if (fieldName.equals("location")) {
                    arguments.add(((LocationProvider)((Object)metadata)).getPath().toUri().getPath());
                    continue;
                }
                if (fieldName.equals("locations")) {
                    if (this.metadataType == MetadataType.SEGMENT) {
                        arguments.add(((SegmentMetadata)metadata).getLocations().stream().map(path -> path.toUri().getPath()).toArray(String[]::new));
                        continue;
                    }
                    arguments.add(null);
                    continue;
                }
                if (((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().contains(fieldName)) {
                    arguments.add(identifierValues[((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().indexOf(fieldName)]);
                    continue;
                }
                if (AnalyzeColumnUtils.isColumnStatisticsField(fieldName)) {
                    arguments.add(metadata.getColumnStatistics(SchemaPath.parseFromString(AnalyzeColumnUtils.getColumnName(fieldName))).get(AnalyzeColumnUtils.getStatisticsKind(fieldName)));
                    continue;
                }
                if (AnalyzeColumnUtils.isMetadataStatisticsField(fieldName)) {
                    arguments.add(metadata.getStatistic(AnalyzeColumnUtils.getStatisticsKind(fieldName)));
                    continue;
                }
                if (fieldName.equals("collectedMap")) {
                    arguments.add(new Object[0]);
                    continue;
                }
                if (fieldName.equals("schema")) {
                    arguments.add(metadata.getSchema().jsonString());
                    continue;
                }
                if (fieldName.equals(this.columnNamesOptions.lastModifiedTime())) {
                    arguments.add(String.valueOf(metadata.getLastModifiedTime()));
                    continue;
                }
                if (fieldName.equals(this.columnNamesOptions.rowGroupIndex())) {
                    arguments.add(String.valueOf(((RowGroupMetadata)metadata).getRowGroupIndex()));
                    continue;
                }
                if (fieldName.equals(this.columnNamesOptions.rowGroupStart())) {
                    arguments.add(Long.toString((Long)metadata.getStatistic(() -> "start")));
                    continue;
                }
                if (fieldName.equals(this.columnNamesOptions.rowGroupLength())) {
                    arguments.add(Long.toString((Long)metadata.getStatistic(() -> "length")));
                    continue;
                }
                if (fieldName.equals("metadataType")) {
                    arguments.add(this.metadataType.name());
                    continue;
                }
                throw new UnsupportedOperationException(String.format("Found unexpected field [%s] in incoming batch.", field));
            }
            rowWriter.addRow(arguments.toArray());
        }
        return resultSetLoader.harvest();
    }

    private ResultSetLoader getResultSetLoaderWithBatchSchema() {
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        for (VectorWrapper<?> vectorWrapper : this.container) {
            MaterializedField field = vectorWrapper.getField();
            String fieldName = field.getName();
            if (fieldName.equals("location") || fieldName.equals("schema") || fieldName.equals(this.columnNamesOptions.lastModifiedTime()) || fieldName.equals(this.columnNamesOptions.rowGroupIndex()) || fieldName.equals(this.columnNamesOptions.rowGroupStart()) || fieldName.equals(this.columnNamesOptions.rowGroupLength()) || fieldName.equals("metadataType") || ((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().contains(fieldName)) {
                schemaBuilder.add(fieldName, field.getType().getMinorType(), field.getDataMode());
                continue;
            }
            if (AnalyzeColumnUtils.isColumnStatisticsField(fieldName) || AnalyzeColumnUtils.isMetadataStatisticsField(fieldName)) {
                schemaBuilder.add(fieldName, field.getType().getMinorType(), field.getType().getMode());
                continue;
            }
            if (fieldName.equals("collectedMap")) {
                schemaBuilder.addMapArray(fieldName).resumeSchema();
                continue;
            }
            if (fieldName.equals("locations")) {
                schemaBuilder.addArray(fieldName, TypeProtos.MinorType.VARCHAR);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Found unexpected field [%s] in incoming batch.", field));
        }
        ResultSetLoaderImpl.ResultSetOptions options = new ResultSetOptionBuilder().readerSchema(schemaBuilder.buildSchema()).build();
        return new ResultSetLoaderImpl(this.container.getAllocator(), options);
    }

    private void setupSchemaFromContainer(VectorContainer populatedContainer) {
        this.container.clear();
        StreamSupport.stream(populatedContainer.spliterator(), false).map(VectorWrapper::getField).forEach(this.container::addOrGet);
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container.setEmpty();
    }

    @Override
    protected boolean setupNewSchema() {
        this.setupSchemaFromContainer(this.incoming.getContainer());
        return true;
    }

    private RecordBatch.IterOutcome doWorkInternal() {
        this.container.transferIn(this.incoming.getContainer());
        VarCharVector metadataTypeVector = (VarCharVector)this.container.addOrGet(MaterializedField.create("metadataType", Types.required(TypeProtos.MinorType.VARCHAR)));
        metadataTypeVector.allocateNew();
        for (int i = 0; i < this.incoming.getRecordCount(); ++i) {
            metadataTypeVector.getMutator().setSafe(i, this.metadataType.name().getBytes(StandardCharsets.UTF_8));
        }
        metadataTypeVector.getMutator().setValueCount(this.incoming.getRecordCount());
        this.container.setRecordCount(this.incoming.getRecordCount());
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.updateMetadataToHandle();
        return RecordBatch.IterOutcome.OK;
    }

    private void updateMetadataToHandle() {
        if (this.metadataToHandle != null && !this.metadataToHandle.isEmpty()) {
            RowSetReader reader = DirectRowSet.fromContainer(this.container).reader();
            switch (this.metadataType) {
                case ROW_GROUP: {
                    while (reader.next() && !this.metadataToHandle.isEmpty()) {
                        List<String> partitionValues = ((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().stream().map(columnName -> reader.column((String)columnName).scalar().getString()).collect(Collectors.toList());
                        Path location = new Path(reader.column("location").scalar().getString());
                        int rgi = Integer.parseInt(reader.column(this.columnNamesOptions.rowGroupIndex()).scalar().getString());
                        this.metadataToHandle.remove(MetadataIdentifierUtils.getRowGroupMetadataIdentifier(partitionValues, location, rgi));
                    }
                    break;
                }
                case FILE: {
                    while (reader.next() && !this.metadataToHandle.isEmpty()) {
                        List<String> partitionValues = ((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().stream().map(columnName -> reader.column((String)columnName).scalar().getString()).collect(Collectors.toList());
                        Path location = new Path(reader.column("location").scalar().getString());
                        this.metadataToHandle.remove(MetadataIdentifierUtils.getFileMetadataIdentifier(partitionValues, location));
                    }
                    break;
                }
                case SEGMENT: {
                    while (reader.next() && !this.metadataToHandle.isEmpty()) {
                        List<String> partitionValues = ((MetadataHandlerPOP)this.popConfig).getContext().segmentColumns().stream().limit(((MetadataHandlerPOP)this.popConfig).getContext().depthLevel()).map(columnName -> reader.column((String)columnName).scalar().getString()).collect(Collectors.toList());
                        this.metadataToHandle.remove(MetadataIdentifierUtils.getMetadataIdentifierKey(partitionValues));
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void dump() {
        logger.error("MetadataHandlerBatch[container={}, popConfig={}]", (Object)this.container, (Object)this.popConfig);
    }

    @Override
    public int getRecordCount() {
        return this.container.getRecordCount();
    }
}

