/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import java.util.ArrayList;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.exec.expr.AbstractExecExprVisitor;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.fn.output.OutputWidthCalculator;

public abstract class OutputWidthExpression {
    abstract <T, V, E extends Exception> T accept(AbstractExecExprVisitor<T, V, E> var1, V var2) throws E;

    public static class FixedLenExpr
    extends OutputWidthExpression {
        private int fixedDataWidth;

        public FixedLenExpr(int fixedWidth) {
            this.fixedDataWidth = fixedWidth;
        }

        public int getDataWidth() {
            return this.fixedDataWidth;
        }

        @Override
        public <T, V, E extends Exception> T accept(AbstractExecExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitFixedLenExpr(this, value);
        }
    }

    public static class VarLenReadExpr
    extends OutputWidthExpression {
        ValueVectorReadExpression readExpression;
        String inputColumnName;

        public VarLenReadExpr(ValueVectorReadExpression readExpression) {
            this.readExpression = readExpression;
            this.inputColumnName = null;
        }

        public VarLenReadExpr(String inputColumnName) {
            this.readExpression = null;
            this.inputColumnName = inputColumnName;
        }

        public ValueVectorReadExpression getReadExpression() {
            return this.readExpression;
        }

        public String getInputColumnName() {
            return this.inputColumnName;
        }

        @Override
        public <T, V, E extends Exception> T accept(AbstractExecExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitVarLenReadExpr(this, value);
        }
    }

    public static class FunctionCallExpr
    extends OutputWidthExpression {
        FunctionHolderExpression holder;
        ArrayList<OutputWidthExpression> args;
        OutputWidthCalculator widthCalculator;

        public FunctionCallExpr(FunctionHolderExpression holder, OutputWidthCalculator widthCalculator, ArrayList<OutputWidthExpression> args) {
            this.holder = holder;
            this.args = args;
            this.widthCalculator = widthCalculator;
        }

        public FunctionHolderExpression getHolder() {
            return this.holder;
        }

        public ArrayList<OutputWidthExpression> getArgs() {
            return this.args;
        }

        public OutputWidthCalculator getCalculator() {
            return this.widthCalculator;
        }

        @Override
        public <T, V, E extends Exception> T accept(AbstractExecExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitFunctionCallExpr(this, value);
        }
    }

    public static class IfElseWidthExpr
    extends OutputWidthExpression {
        OutputWidthExpression[] expressions = new OutputWidthExpression[2];

        public IfElseWidthExpr(OutputWidthExpression ifExpr, OutputWidthExpression elseExpr) {
            this.expressions[0] = ifExpr;
            this.expressions[1] = elseExpr;
        }

        @Override
        public <T, V, E extends Exception> T accept(AbstractExecExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitIfElseWidthExpr(this, value);
        }
    }
}

