/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import java.util.ArrayList;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.TypedNullConstant;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.AbstractExecExprVisitor;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.output.OutputWidthCalculator;
import org.apache.drill.exec.physical.impl.project.OutputWidthExpression;
import org.apache.drill.exec.physical.impl.project.OutputWidthVisitorState;
import org.apache.drill.exec.physical.impl.project.ProjectMemoryManager;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class OutputWidthVisitor
extends AbstractExecExprVisitor<OutputWidthExpression, OutputWidthVisitorState, RuntimeException> {
    @Override
    public OutputWidthExpression visitVarDecimalConstant(ValueExpressions.VarDecimalExpression varDecimalExpression, OutputWidthVisitorState state) throws RuntimeException {
        Preconditions.checkArgument(varDecimalExpression.getMajorType().hasPrecision());
        return new OutputWidthExpression.FixedLenExpr(varDecimalExpression.getMajorType().getPrecision());
    }

    @Override
    public OutputWidthExpression visitIfExpression(IfExpression ifExpression, OutputWidthVisitorState state) throws RuntimeException {
        IfExpression.IfCondition condition = ifExpression.ifCondition;
        LogicalExpression ifExpr = condition.expression;
        LogicalExpression elseExpr = ifExpression.elseExpression;
        OutputWidthExpression ifWidthExpr = ifExpr.accept(this, state);
        OutputWidthExpression elseWidthExpr = null;
        if (elseExpr != null) {
            elseWidthExpr = elseExpr.accept(this, state);
        }
        return new OutputWidthExpression.IfElseWidthExpr(ifWidthExpr, elseWidthExpr);
    }

    @Override
    public OutputWidthExpression visitFunctionHolderExpression(FunctionHolderExpression holderExpr, OutputWidthVisitorState state) throws RuntimeException {
        OutputWidthExpression fixedWidth = this.getFixedLenExpr(holderExpr.getMajorType());
        if (fixedWidth != null) {
            return fixedWidth;
        }
        if (!(holderExpr instanceof DrillFuncHolderExpr)) {
            return new OutputWidthExpression.FixedLenExpr(50);
        }
        DrillFuncHolder holder = ((DrillFuncHolderExpr)holderExpr).getHolder();
        int estimate = holder.variableOutputSizeEstimate();
        if (estimate != -1) {
            return new OutputWidthExpression.FixedLenExpr(estimate);
        }
        OutputWidthCalculator widthCalculator = holder.getOutputWidthCalculator();
        int argSize = holderExpr.args.size();
        ArrayList<OutputWidthExpression> arguments = null;
        if (argSize != 0) {
            arguments = new ArrayList<OutputWidthExpression>(argSize);
            for (LogicalExpression expr : holderExpr.args) {
                arguments.add(expr.accept(this, state));
            }
        }
        return new OutputWidthExpression.FunctionCallExpr(holderExpr, widthCalculator, arguments);
    }

    @Override
    public OutputWidthExpression visitValueVectorWriteExpression(ValueVectorWriteExpression writeExpr, OutputWidthVisitorState state) throws RuntimeException {
        OutputWidthExpression outputExpr;
        TypedFieldId fieldId = writeExpr.getFieldId();
        ProjectMemoryManager manager = state.getManager();
        if (manager.isFixedWidth(fieldId)) {
            outputExpr = this.getFixedLenExpr(fieldId.getFinalType());
        } else {
            LogicalExpression writeArg = writeExpr.getChild();
            outputExpr = writeArg.accept(this, state);
        }
        return outputExpr;
    }

    @Override
    public OutputWidthExpression visitValueVectorReadExpression(ValueVectorReadExpression readExpr, OutputWidthVisitorState state) throws RuntimeException {
        return new OutputWidthExpression.VarLenReadExpr(readExpr);
    }

    @Override
    public OutputWidthExpression visitQuotedStringConstant(ValueExpressions.QuotedString quotedString, OutputWidthVisitorState state) throws RuntimeException {
        return new OutputWidthExpression.FixedLenExpr(quotedString.getString().length());
    }

    @Override
    public OutputWidthExpression visitUnknown(LogicalExpression logicalExpression, OutputWidthVisitorState state) {
        OutputWidthExpression fixedLenExpr = this.getFixedLenExpr(logicalExpression.getMajorType());
        if (fixedLenExpr != null) {
            return fixedLenExpr;
        }
        throw new IllegalStateException("Unknown variable width expression: " + logicalExpression);
    }

    @Override
    public OutputWidthExpression visitNullConstant(TypedNullConstant nullConstant, OutputWidthVisitorState state) throws RuntimeException {
        int width = nullConstant.getMajorType().hasPrecision() ? nullConstant.getMajorType().getPrecision() : 0;
        return new OutputWidthExpression.FixedLenExpr(width);
    }

    @Override
    public OutputWidthExpression visitFixedLenExpr(OutputWidthExpression.FixedLenExpr fixedLenExpr, OutputWidthVisitorState state) throws RuntimeException {
        return fixedLenExpr;
    }

    @Override
    public OutputWidthExpression visitVarLenReadExpr(OutputWidthExpression.VarLenReadExpr varLenReadExpr, OutputWidthVisitorState state) throws RuntimeException {
        String columnName = varLenReadExpr.getInputColumnName();
        if (columnName == null) {
            TypedFieldId fieldId = varLenReadExpr.getReadExpression().getTypedFieldId();
            columnName = TypedFieldId.getPath(fieldId, state.manager.incomingBatch());
        }
        RecordBatchSizer.ColumnSize columnSize = state.manager.getColumnSize(columnName);
        int columnWidth = columnSize.getDataSizePerEntry();
        return new OutputWidthExpression.FixedLenExpr(columnWidth);
    }

    @Override
    public OutputWidthExpression visitFunctionCallExpr(OutputWidthExpression.FunctionCallExpr functionCallExpr, OutputWidthVisitorState state) throws RuntimeException {
        ArrayList<OutputWidthExpression> args = functionCallExpr.getArgs();
        ArrayList<OutputWidthExpression.FixedLenExpr> estimatedArgs = null;
        if (args != null && args.size() != 0) {
            estimatedArgs = new ArrayList<OutputWidthExpression.FixedLenExpr>(args.size());
            for (OutputWidthExpression expr : args) {
                OutputWidthExpression.FixedLenExpr fixedLenExpr = (OutputWidthExpression.FixedLenExpr)expr.accept(this, state);
                estimatedArgs.add(fixedLenExpr);
            }
        }
        OutputWidthCalculator estimator = functionCallExpr.getCalculator();
        int estimatedSize = estimator.getOutputWidth(estimatedArgs);
        return new OutputWidthExpression.FixedLenExpr(estimatedSize);
    }

    @Override
    public OutputWidthExpression visitIfElseWidthExpr(OutputWidthExpression.IfElseWidthExpr ifElseWidthExpr, OutputWidthVisitorState state) throws RuntimeException {
        OutputWidthExpression ifReducedExpr = ifElseWidthExpr.expressions[0].accept(this, state);
        assert (ifReducedExpr instanceof OutputWidthExpression.FixedLenExpr);
        int ifWidth = ((OutputWidthExpression.FixedLenExpr)ifReducedExpr).getDataWidth();
        int elseWidth = -1;
        if (ifElseWidthExpr.expressions[1] != null) {
            OutputWidthExpression elseReducedExpr = ifElseWidthExpr.expressions[1].accept(this, state);
            assert (elseReducedExpr instanceof OutputWidthExpression.FixedLenExpr);
            elseWidth = ((OutputWidthExpression.FixedLenExpr)elseReducedExpr).getDataWidth();
        }
        int outputWidth = Math.max(ifWidth, elseWidth);
        return new OutputWidthExpression.FixedLenExpr(outputWidth);
    }

    private OutputWidthExpression getFixedLenExpr(TypeProtos.MajorType majorType) {
        TypeProtos.MajorType type = majorType;
        if (Types.isFixedWidthType(type)) {
            int fixedDataWidth = ProjectMemoryManager.getFixedWidth(type);
            return new OutputWidthExpression.FixedLenExpr(fixedDataWidth);
        }
        return null;
    }
}

