/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.physical.impl.project.OutputWidthExpression;
import org.apache.drill.exec.physical.impl.project.OutputWidthVisitor;
import org.apache.drill.exec.physical.impl.project.OutputWidthVisitorState;
import org.apache.drill.exec.physical.impl.project.ProjectRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchMemoryManager;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectMemoryManager
extends RecordBatchMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(ProjectMemoryManager.class);
    private RecordBatch incomingBatch;
    private ProjectRecordBatch outgoingBatch;
    private int rowWidth;
    private final Map<String, VariableWidthColumnInfo> varWidthColumnSizes = new HashMap<String, VariableWidthColumnInfo>();
    private int variableWidthColumnCount;
    private int fixedWidthColumnCount;
    private int complexColumnsCount;
    private int totalFixedWidthColumnWidth;
    private int totalComplexColumnWidth;

    public ProjectMemoryManager(int configuredOutputSize) {
        super(configuredOutputSize);
    }

    private void reset() {
        this.rowWidth = 0;
        this.totalFixedWidthColumnWidth = 0;
        this.totalComplexColumnWidth = 0;
        this.fixedWidthColumnCount = 0;
        this.complexColumnsCount = 0;
    }

    private void setIncomingBatch(RecordBatch recordBatch) {
        this.incomingBatch = recordBatch;
    }

    public RecordBatch incomingBatch() {
        return this.incomingBatch;
    }

    private void setOutgoingBatch(ProjectRecordBatch outgoingBatch) {
        this.outgoingBatch = outgoingBatch;
    }

    public boolean isComplex(TypeProtos.MajorType majorType) {
        return Types.isComplex(majorType) || Types.isUnion(majorType);
    }

    public boolean isFixedWidth(TypedFieldId fieldId) {
        ValueVector vv = this.getOutgoingValueVector(fieldId);
        return ProjectMemoryManager.isFixedWidth(vv);
    }

    private ValueVector getOutgoingValueVector(TypedFieldId fieldId) {
        Class<? extends ValueVector> clazz = fieldId.getIntermediateClass();
        int[] fieldIds = fieldId.getFieldIds();
        return this.outgoingBatch.getValueAccessorById(clazz, fieldIds).getValueVector();
    }

    private static boolean isFixedWidth(ValueVector vv) {
        return vv instanceof FixedWidthVector;
    }

    public static int getFixedWidth(TypeProtos.MajorType majorType) {
        Preconditions.checkArgument(!Types.isVarWidthType(majorType.getMinorType()), "Expected fixed type but was '%s'.", (Object)majorType.getMinorType());
        return TypeHelper.getSize(majorType);
    }

    public void addTransferField(ValueVector vvIn, String inputColumnName, String outputColumnName) {
        this.addField(vvIn, null, OutputColumnType.TRANSFER, inputColumnName, outputColumnName);
    }

    public void addNewField(ValueVector vvOut, LogicalExpression logicalExpression) {
        this.addField(vvOut, logicalExpression, OutputColumnType.NEW, null, vvOut.getField().getName());
    }

    private void addField(ValueVector vv, LogicalExpression logicalExpression, OutputColumnType outputColumnType, String inputColumnName, String outputColumnName) {
        if (ProjectMemoryManager.isFixedWidth(vv)) {
            this.addFixedWidthField(vv);
        } else {
            this.addVariableWidthField(vv, logicalExpression, outputColumnType, inputColumnName, outputColumnName);
        }
    }

    private void addVariableWidthField(ValueVector vv, LogicalExpression logicalExpression, OutputColumnType outputColumnType, String inputColumnName, String outputColumnName) {
        ++this.variableWidthColumnCount;
        logger.trace("addVariableWidthField(): vv {} totalCount: {} outputColumnType: {}", new Object[]{ProjectMemoryManager.vvAsString(vv), this.variableWidthColumnCount, outputColumnType});
        OutputWidthExpression outWidthExpr = outputColumnType == OutputColumnType.TRANSFER ? new OutputWidthExpression.VarLenReadExpr(inputColumnName) : logicalExpression.accept(new OutputWidthVisitor(), new OutputWidthVisitorState(this));
        VariableWidthColumnInfo columnWidthInfo = new VariableWidthColumnInfo(outWidthExpr, vv);
        VariableWidthColumnInfo existingInfo = this.varWidthColumnSizes.put(outputColumnName, columnWidthInfo);
        Preconditions.checkState(existingInfo == null);
    }

    private static String vvAsString(ValueVector vv) {
        return vv == null ? "null" : String.format("%s %s", vv.getField().getName(), vv.getField().getType());
    }

    public void addComplexField(ValueVector vv) {
        assert (vv == null || this.isComplex(vv.getField().getType()));
        ++this.complexColumnsCount;
        this.totalComplexColumnWidth += 50;
        if (logger.isTraceEnabled()) {
            logger.trace("addComplexField(): vv {} totalCount: {} totalComplexColumnWidth: {}", new Object[]{ProjectMemoryManager.vvAsString(vv), this.complexColumnsCount, this.totalComplexColumnWidth});
        }
    }

    private void addFixedWidthField(ValueVector vv) {
        assert (ProjectMemoryManager.isFixedWidth(vv));
        ++this.fixedWidthColumnCount;
        int fixedFieldWidth = ((FixedWidthVector)vv).getValueWidth();
        this.totalFixedWidthColumnWidth += fixedFieldWidth;
        if (logger.isTraceEnabled()) {
            logger.trace("addFixedWidthField(): vv {} totalCount: {} totalComplexColumnWidth: {}", new Object[]{ProjectMemoryManager.vvAsString(vv), this.fixedWidthColumnCount, this.totalFixedWidthColumnWidth});
        }
    }

    public void init(RecordBatch incomingBatch, ProjectRecordBatch outgoingBatch) {
        this.setIncomingBatch(incomingBatch);
        this.setOutgoingBatch(outgoingBatch);
        this.reset();
        RecordBatchStats.printConfiguredBatchSize(outgoingBatch.getRecordBatchStatsContext(), this.getOutputBatchSize());
    }

    @Override
    public void update() {
        int outPutRowCount;
        long updateStartTime = System.currentTimeMillis();
        RecordBatchSizer batchSizer = new RecordBatchSizer(this.incomingBatch);
        long batchSizerEndTime = System.currentTimeMillis();
        this.setRecordBatchSizer(batchSizer);
        this.rowWidth = 0;
        int totalVariableColumnWidth = 0;
        for (String outputColumnName : this.varWidthColumnSizes.keySet()) {
            OutputWidthVisitorState state;
            VariableWidthColumnInfo columnWidthInfo = this.varWidthColumnSizes.get(outputColumnName);
            int width = -1;
            OutputWidthExpression savedWidthExpr = columnWidthInfo.getOutputExpression();
            OutputWidthExpression reducedExpr = savedWidthExpr.accept(new OutputWidthVisitor(), state = new OutputWidthVisitorState(this));
            width = ((OutputWidthExpression.FixedLenExpr)reducedExpr).getDataWidth();
            Preconditions.checkState(width >= 0);
            int metadataWidth = ProjectMemoryManager.getMetadataWidth(columnWidthInfo.outputVV);
            logger.trace("update(): fieldName {} width: {} metadataWidth: {}", new Object[]{columnWidthInfo.outputVV.getField().getName(), width, metadataWidth});
            totalVariableColumnWidth += (width += metadataWidth);
        }
        this.rowWidth += this.totalFixedWidthColumnWidth;
        this.rowWidth += this.totalComplexColumnWidth;
        this.rowWidth += totalVariableColumnWidth;
        if (this.rowWidth != 0) {
            this.setOutputRowCount(this.getOutputBatchSize(), this.rowWidth);
            outPutRowCount = Math.min(this.getOutputRowCount(), batchSizer.rowCount());
        } else {
            outPutRowCount = this.incomingBatch.getRecordCount();
        }
        this.setOutputRowCount(outPutRowCount);
        long updateEndTime = System.currentTimeMillis();
        logger.trace("update() : Output RC {}, BatchSizer RC {}, incoming RC {}, width {}, total fixed width {}, total variable width {}, total complex width {}, batchSizer time {} ms, update time {}  ms, manager {}, incoming {}", new Object[]{outPutRowCount, batchSizer.rowCount(), this.incomingBatch.getRecordCount(), this.rowWidth, this.totalFixedWidthColumnWidth, totalVariableColumnWidth, this.totalComplexColumnWidth, batchSizerEndTime - updateStartTime, updateEndTime - updateStartTime, this, this.incomingBatch});
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.INPUT, this.getRecordBatchSizer(), this.outgoingBatch.getRecordBatchStatsContext());
        this.updateIncomingStats();
    }

    public static int getMetadataWidth(ValueVector vv) {
        int width = 0;
        if (vv instanceof NullableVector) {
            width += ((NullableVector)vv).getBitsVector().getPayloadByteCount(1);
        }
        if (vv instanceof VariableWidthVector) {
            width += ((VariableWidthVector)vv).getOffsetVector().getPayloadByteCount(1);
        }
        if (vv instanceof BaseRepeatedValueVector) {
            width += ((BaseRepeatedValueVector)vv).getOffsetVector().getPayloadByteCount(1);
            width += ProjectMemoryManager.getMetadataWidth(((BaseRepeatedValueVector)vv).getDataVector()) * 5;
        }
        return width;
    }

    private static enum OutputColumnType {
        TRANSFER,
        NEW;

    }

    public static class VariableWidthColumnInfo {
        private final OutputWidthExpression outputExpression;
        private final ValueVector outputVV;

        VariableWidthColumnInfo(OutputWidthExpression outputWidthExpression, ValueVector outputVV) {
            this.outputExpression = outputWidthExpression;
            this.outputVV = outputVV;
        }

        public OutputWidthExpression getOutputExpression() {
            return this.outputExpression;
        }
    }
}

