/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.Project;
import org.apache.drill.exec.physical.impl.project.ProjectBatchBuilder;
import org.apache.drill.exec.physical.impl.project.ProjectMemoryManager;
import org.apache.drill.exec.physical.impl.project.ProjectionMaterializer;
import org.apache.drill.exec.physical.impl.project.Projector;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.SimpleRecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRecordBatch
extends AbstractSingleRecordBatch<Project> {
    private static final Logger logger = LoggerFactory.getLogger(ProjectRecordBatch.class);
    protected List<ValueVector> allocationVectors;
    @Deprecated
    protected List<BaseWriter.ComplexWriter> complexWriters;
    protected ResultSetLoader rsLoader;
    protected List<FieldReference> complexFieldReferencesList;
    protected ProjectMemoryManager memoryManager;
    private Projector projector;
    private boolean hasRemainder;
    private int remainderIndex;
    private int recordCount;
    private boolean first = true;
    private boolean wasNone;

    public ProjectRecordBatch(Project pop, RecordBatch incoming, FragmentContext context) {
        super(pop, context, incoming);
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    protected void cancelIncoming() {
        super.cancelIncoming();
        this.hasRemainder = false;
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.wasNone) {
            return RecordBatch.IterOutcome.NONE;
        }
        this.recordCount = 0;
        if (this.hasRemainder) {
            this.handleRemainder();
            return this.getFinalOutcome(this.hasRemainder);
        }
        return super.innerNext();
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.container;
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        if (this.wasNone) {
            return RecordBatch.IterOutcome.NONE;
        }
        int incomingRecordCount = this.incoming.getRecordCount();
        logger.trace("doWork(): incoming rc {}, incoming {}, Project {}", new Object[]{incomingRecordCount, this.incoming, this});
        this.memoryManager.update();
        if (this.first && incomingRecordCount == 0 && (!CollectionUtils.isEmpty(this.complexWriters) || this.rsLoader != null)) {
            RecordBatch.IterOutcome next = null;
            while (incomingRecordCount == 0) {
                if (this.getLastKnownOutcome() == RecordBatch.IterOutcome.EMIT) {
                    throw new UnsupportedOperationException("Currently functions producing complex types as output are not supported in project list for subquery between LATERAL and UNNEST. Please re-write the query using this function in the projection list of outermost query.");
                }
                next = this.next(this.incoming);
                this.setLastKnownOutcome(next);
                if (next == RecordBatch.IterOutcome.NONE) {
                    this.doAlloc(0);
                    this.setValueCount(0);
                    this.wasNone = true;
                    return RecordBatch.IterOutcome.NONE;
                }
                if (next != RecordBatch.IterOutcome.OK && next != RecordBatch.IterOutcome.OK_NEW_SCHEMA && next != RecordBatch.IterOutcome.EMIT) {
                    return next;
                }
                if (next == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                    try {
                        this.stats.startSetup();
                        this.setupNewSchema();
                    }
                    finally {
                        this.stats.stopSetup();
                    }
                }
                incomingRecordCount = this.incoming.getRecordCount();
                this.memoryManager.update();
                logger.trace("doWork():[1] memMgr RC {}, incoming rc {}, incoming {}, Project {}", new Object[]{this.memoryManager.getOutputRowCount(), incomingRecordCount, this.incoming, this});
            }
        }
        if (!(CollectionUtils.isEmpty(this.complexWriters) && this.rsLoader == null || this.getLastKnownOutcome() != RecordBatch.IterOutcome.EMIT)) {
            throw UserException.unsupportedError().message("Currently functions producing complex types as output are not supported in project list for subquery between LATERAL and UNNEST. Please re-write the query using this function in the projection list of outermost query.", new Object[0]).build(logger);
        }
        this.first = false;
        this.container.zeroVectors();
        int maxOuputRecordCount = this.memoryManager.getOutputRowCount();
        logger.trace("doWork():[2] memMgr RC {}, incoming rc {}, incoming {}, project {}", new Object[]{this.memoryManager.getOutputRowCount(), incomingRecordCount, this.incoming, this});
        this.doAlloc(maxOuputRecordCount);
        long projectStartTime = System.currentTimeMillis();
        int outputRecords = this.projector.projectRecords(this.incoming, 0, maxOuputRecordCount, 0);
        long projectEndTime = System.currentTimeMillis();
        logger.trace("doWork(): projection: records {}, time {} ms", (Object)outputRecords, (Object)(projectEndTime - projectStartTime));
        this.setValueCount(outputRecords);
        this.recordCount = outputRecords;
        if (outputRecords < incomingRecordCount) {
            this.hasRemainder = true;
            this.remainderIndex = outputRecords;
        } else {
            assert (outputRecords == incomingRecordCount);
            this.incoming.getContainer().zeroVectors();
        }
        if (this.rsLoader != null) {
            MapVector map = this.container.addOrGet(this.container.getLast().getField().getName(), Types.required(TypeProtos.MinorType.MAP), MapVector.class);
            map.setMapValueCount(this.recordCount);
            for (VectorWrapper<?> vectorWrapper : this.rsLoader.harvest()) {
                Object valueVector = vectorWrapper.getValueVector();
                map.putChild(valueVector.getField().getName(), (ValueVector)valueVector);
            }
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        } else if (!CollectionUtils.isEmpty(this.complexWriters)) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
        this.memoryManager.updateOutgoingStats(outputRecords);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this, this.getRecordBatchStatsContext());
        return this.getFinalOutcome(this.hasRemainder);
    }

    private void handleRemainder() {
        int remainingRecordCount = this.incoming.getRecordCount() - this.remainderIndex;
        assert (this.memoryManager.incomingBatch() == this.incoming);
        int recordsToProcess = Math.min(remainingRecordCount, this.memoryManager.getOutputRowCount());
        this.doAlloc(recordsToProcess);
        logger.trace("handleRemainder: remaining RC {}, toProcess {}, remainder index {}, incoming {}, Project {}", new Object[]{remainingRecordCount, recordsToProcess, this.remainderIndex, this.incoming, this});
        long projectStartTime = System.currentTimeMillis();
        int projRecords = this.projector.projectRecords(this.incoming, this.remainderIndex, recordsToProcess, 0);
        long projectEndTime = System.currentTimeMillis();
        logger.trace("handleRemainder: projection: records {}, time {} ms", (Object)projRecords, (Object)(projectEndTime - projectStartTime));
        if (projRecords < remainingRecordCount) {
            this.setValueCount(projRecords);
            this.recordCount = projRecords;
            this.remainderIndex += projRecords;
        } else {
            this.setValueCount(remainingRecordCount);
            this.hasRemainder = false;
            this.remainderIndex = 0;
            this.incoming.getContainer().zeroVectors();
            this.recordCount = remainingRecordCount;
        }
        if (!CollectionUtils.isEmpty(this.complexWriters) || this.rsLoader != null) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
        this.memoryManager.updateOutgoingStats(projRecords);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this, this.getRecordBatchStatsContext());
    }

    public void addComplexWriter(BaseWriter.ComplexWriter writer) {
        this.complexWriters.add(writer);
    }

    public void addLoader(ResultSetLoader loader) {
        this.rsLoader = loader;
    }

    private void doAlloc(int recordCount) {
        for (ValueVector v : this.allocationVectors) {
            AllocationHelper.allocateNew(v, recordCount);
        }
        if (this.complexWriters != null) {
            for (BaseWriter.ComplexWriter writer : this.complexWriters) {
                writer.allocate();
            }
        }
    }

    private void setValueCount(int count) {
        if (count == 0) {
            this.container.setEmpty();
            return;
        }
        for (ValueVector v : this.allocationVectors) {
            v.getMutator().setValueCount(count);
        }
        this.container.setRecordCount(count);
        if (this.complexWriters != null) {
            for (BaseWriter.ComplexWriter writer : this.complexWriters) {
                writer.setValueCount(count);
            }
        } else if (this.rsLoader != null) {
            this.rsLoader.setTargetRowCount(count);
        }
    }

    @Override
    protected boolean setupNewSchema() {
        this.setupNewSchemaFromInput(this.incoming);
        if (this.container.isSchemaChanged() || this.callBack.getSchemaChangedAndReset()) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            return true;
        }
        return false;
    }

    private void setupNewSchemaFromInput(RecordBatch incomingBatch) {
        int configuredBatchSize = (int)this.context.getOptions().getOption(ExecConstants.OUTPUT_BATCH_SIZE_VALIDATOR);
        this.setupNewSchema(incomingBatch, configuredBatchSize);
        ProjectBatchBuilder batchBuilder = new ProjectBatchBuilder(this, this.container, this.callBack, incomingBatch);
        ProjectionMaterializer em = new ProjectionMaterializer(this.context.getOptions(), incomingBatch, ((Project)this.popConfig).getExprs(), this.context.getFunctionRegistry(), batchBuilder, this.unionTypeEnabled);
        boolean saveCode = false;
        this.projector = em.generateProjector(this.context, saveCode);
        try {
            this.projector.setup(this.context, incomingBatch, this, batchBuilder.transfers());
        }
        catch (SchemaChangeException e) {
            throw UserException.schemaChangeError(e).addContext("Unexpected schema change in the Project operator").build(logger);
        }
    }

    @Override
    protected RecordBatch.IterOutcome handleNullInput() {
        if (!((Project)this.popConfig).isOutputProj()) {
            BatchSchema incomingSchema = this.incoming.getSchema();
            if (incomingSchema != null && incomingSchema.getFieldCount() > 0) {
                this.setupNewSchemaFromInput(this.incoming);
            }
            return super.handleNullInput();
        }
        VectorContainer emptyVC = new VectorContainer();
        emptyVC.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        SimpleRecordBatch emptyIncomingBatch = new SimpleRecordBatch(emptyVC, this.context);
        this.setupNewSchemaFromInput(emptyIncomingBatch);
        this.doAlloc(0);
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container.setEmpty();
        this.wasNone = true;
        return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
    }

    @Override
    protected RecordBatch.IterOutcome getFinalOutcome(boolean hasMoreRecordInBoundary) {
        if (!CollectionUtils.isEmpty(this.complexWriters) || this.rsLoader != null) {
            return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        return super.getFinalOutcome(hasMoreRecordInBoundary);
    }

    private void setupNewSchema(RecordBatch incomingBatch, int configuredBatchSize) {
        this.memoryManager = new ProjectMemoryManager(configuredBatchSize);
        this.memoryManager.init(incomingBatch, this);
        if (this.allocationVectors != null) {
            for (ValueVector v : this.allocationVectors) {
                v.clear();
            }
        }
        this.allocationVectors = new ArrayList<ValueVector>();
        if (this.rsLoader != null) {
            this.container.clear();
            this.rsLoader.close();
        } else if (!CollectionUtils.isEmpty(this.complexWriters)) {
            this.container.clear();
        } else {
            this.container.zeroVectors();
        }
    }

    @Override
    public void dump() {
        logger.error("ProjectRecordBatch[projector={}, hasRemainder={}, remainderIndex={}, recordCount={}, container={}]", new Object[]{this.projector, this.hasRemainder, this.remainderIndex, this.recordCount, this.container});
    }
}

