/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.protocol;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.protocol.BatchAccessor;
import org.apache.drill.exec.physical.impl.protocol.OperatorExec;
import org.apache.drill.exec.record.RecordBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorDriver {
    private static final Logger logger = LoggerFactory.getLogger(OperatorDriver.class);
    private State state = State.START;
    private final OperatorContext opContext;
    private final OperatorExec operatorExec;
    private final BatchAccessor batchAccessor;
    private int schemaVersion;
    private final boolean enableSchemaBatch;

    public OperatorDriver(OperatorContext opContext, OperatorExec opExec, boolean enableSchemaBatch) {
        this.opContext = opContext;
        this.operatorExec = opExec;
        this.batchAccessor = this.operatorExec.batchAccessor();
        this.enableSchemaBatch = enableSchemaBatch;
    }

    public RecordBatch.IterOutcome next() {
        try {
            switch (this.state) {
                case START: {
                    return this.start();
                }
                case RUN: {
                    return this.doNext();
                }
            }
            logger.debug("Extra call to next() in state {}: {}", (Object)this.state, (Object)this.operatorLabel());
            return RecordBatch.IterOutcome.NONE;
        }
        catch (UserException e) {
            this.cancelSilently();
            this.state = State.FAILED;
            throw e;
        }
        catch (Throwable t) {
            this.cancelSilently();
            this.state = State.FAILED;
            throw UserException.executionError(t).addContext("Exception thrown from", this.operatorLabel()).build(logger);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel() {
        try {
            switch (this.state) {
                case START: 
                case RUN: {
                    this.cancelSilently();
                    return;
                }
            }
            return;
        }
        finally {
            this.state = State.CANCELED;
        }
    }

    private RecordBatch.IterOutcome start() {
        this.state = State.STARTING;
        this.schemaVersion = -1;
        if (!this.enableSchemaBatch) {
            return this.doNext();
        }
        if (this.operatorExec.buildSchema()) {
            this.schemaVersion = this.batchAccessor.schemaVersion();
            this.batchAccessor.container().schemaChanged();
            this.state = State.RUN;
            return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        this.state = State.END;
        return RecordBatch.IterOutcome.NONE;
    }

    private RecordBatch.IterOutcome doNext() {
        boolean schemaChanged;
        if (!this.operatorExec.next()) {
            this.state = State.END;
            return RecordBatch.IterOutcome.NONE;
        }
        int newVersion = this.batchAccessor.schemaVersion();
        boolean bl = schemaChanged = newVersion != this.schemaVersion;
        if (schemaChanged) {
            this.batchAccessor.container().schemaChanged();
        }
        if (this.state == State.STARTING || schemaChanged) {
            this.schemaVersion = newVersion;
            this.state = State.RUN;
            return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        this.state = State.RUN;
        return RecordBatch.IterOutcome.OK;
    }

    private void cancelSilently() {
        try {
            if (this.state == State.STARTING || this.state == State.RUN) {
                this.operatorExec.cancel();
            }
        }
        catch (Throwable t) {
            logger.error("Exception thrown from cancel() for {}", (Object)this.operatorLabel(), (Object)t);
        }
    }

    private String operatorLabel() {
        return this.operatorExec.getClass().getCanonicalName();
    }

    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        try {
            this.operatorExec.close();
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable t) {
            throw UserException.executionError(t).addContext("Exception thrown from", this.operatorLabel()).build(logger);
        }
        finally {
            this.opContext.close();
            this.state = State.CLOSED;
        }
    }

    public BatchAccessor batchAccessor() {
        return this.batchAccessor;
    }

    public OperatorContext operatorContext() {
        return this.opContext;
    }

    public static enum State {
        START,
        STARTING,
        RUN,
        END,
        FAILED,
        CANCELED,
        CLOSED;

    }
}

