/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.protocol;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;

public class SchemaTracker {
    private int schemaVersion;
    private BatchSchema currentSchema;
    private List<ValueVector> currentVectors = new ArrayList<ValueVector>();

    public void trackSchema(VectorContainer newBatch) {
        if (this.schemaVersion == 0 || !this.isSameSchema(newBatch)) {
            ++this.schemaVersion;
            this.captureSchema(newBatch);
        }
    }

    private boolean isSameSchema(VectorContainer newBatch) {
        if (this.currentVectors.size() != newBatch.getNumberOfColumns()) {
            return false;
        }
        for (int i = 0; i < this.currentVectors.size(); ++i) {
            if (this.currentVectors.get(i) == newBatch.getValueVector(i).getValueVector()) continue;
            return false;
        }
        return true;
    }

    private void captureSchema(VectorContainer newBatch) {
        this.currentVectors.clear();
        for (VectorWrapper<?> vw : newBatch) {
            this.currentVectors.add((ValueVector)vw.getValueVector());
        }
        this.currentSchema = newBatch.getSchema();
    }

    public int schemaVersion() {
        return this.schemaVersion;
    }

    public BatchSchema schema() {
        return this.currentSchema;
    }
}

