/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.rangepartitioner;

import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.RootFragmentContext;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.physical.config.RangePartitionSender;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.physical.impl.partitionsender.PartitionSenderRootExec;
import org.apache.drill.exec.physical.impl.rangepartitioner.RangePartitionRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class RangePartitionSenderCreator
implements RootCreator<RangePartitionSender> {
    @Override
    public RootExec getRoot(ExecutorFragmentContext context, RangePartitionSender config, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument(children.size() == 1);
        RangePartitionRecordBatch rangep = new RangePartitionRecordBatch(config, children.iterator().next(), context);
        HashPartitionSender hpc = new HashPartitionSender(config.getOppositeMajorFragmentId(), config, config.getPartitionFunction().getPartitionFieldRef(), config.getDestinations(), 4095);
        return new PartitionSenderRootExec((RootFragmentContext)context, rangep, hpc);
    }
}

